<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';
yetkili_mi();

$sayfa_baslik = __("product_management");

// --- Ayarları Getir Başlangıç ---
try {
    $ayar_sorgusu = $db->query("SELECT ayar_adi, ayar_degeri FROM ayarlar WHERE ayar_adi IN ('api_resim_gorunur', 'stok_resim_yukleme_dizin')");
    $ayarlar_raw = $ayar_sorgusu->fetchAll(PDO::FETCH_KEY_PAIR);
    
    $api_resim_gorunur = $ayarlar_raw['api_resim_gorunur'] ?? '0';
    $stok_resim_dizini = $ayarlar_raw['stok_resim_yukleme_dizin'] ?? 'uploads/urun_resimleri';

} catch (PDOException $e) {
    error_log("Ürünler sayfası ayar okuma hatası: " . $e->getMessage());
    // Hata durumunda güvenli varsayılanlar
    $api_resim_gorunur = '0';
    $stok_resim_dizini = 'uploads/urun_resimleri';
}
// --- Ayarları Getir Bitiş ---

// Depo yönetimi modülünü kontrol et
$depo_yonetimi_aktif = depoYonetimiAktifMi($db, $_SESSION['aktif_sirket_id']);

// Arama ve filtre parametreleri
$arama = $_GET['arama'] ?? '';
$kategori_filtre = $_GET['kategori'] ?? '';

// --- Ürünleri Getir Başlangıç ---
try {
    $sql_select_fields = "u.*, u.alis_para_birimi, u.satis_para_birimi, ms.miktar as stok_miktari, ms.ortalama_maliyet, k.kategori_adi, m.marka_adi,
                   CASE 
                       WHEN ms.miktar <= 0 THEN 'danger'
                       WHEN ms.miktar <= u.kritik_stok AND u.kritik_stok > 0 THEN 'warning'
                       ELSE 'success'
                   END as stok_durumu_class";
    
    // Sadece resim gösterme ayarı aktifse resim yolunu sorguya ekle
    if ($api_resim_gorunur == '1') {
        $sql_select_fields .= ", (SELECT resim_yolu FROM urun_resimleri WHERE urun_id = u.id AND varsayilan = 1 LIMIT 1) as varsayilan_resim";
    }

    $sql = "SELECT $sql_select_fields
            FROM urunler u
            LEFT JOIN mevcut_stok ms ON u.id = ms.urun_id AND ms.sirket_id = u.sirket_id
            LEFT JOIN kategoriler k ON u.kategori_id = k.id
            LEFT JOIN markalar m ON u.marka_id = m.id
            WHERE u.aktif = 1 AND u.sirket_id = ?";
    
    $params = [$_SESSION['aktif_sirket_id']];
    
    if (!empty($arama)) {
        $sql .= " AND (u.urun_adi LIKE ? OR u.barkod LIKE ?)";
        $params[] = '%' . $arama . '%';
        $params[] = '%' . $arama . '%';
    }
    
    if (!empty($kategori_filtre)) {
        $sql .= " AND u.kategori_id = ?";
        $params[] = $kategori_filtre;
    }
    
    $sql .= " ORDER BY u.urun_adi";
    
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $urunler = $stmt->fetchAll();
    
    // Kategorileri getir
    $stmt_kategoriler = $db->prepare("SELECT id, kategori_adi FROM kategoriler WHERE sirket_id = ? ORDER BY kategori_adi");
    $stmt_kategoriler->execute([$_SESSION['aktif_sirket_id']]);
    $kategoriler = $stmt_kategoriler->fetchAll();
    
} catch (PDOException $e) {
    error_log("Ürün listesi hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Ürün listesi yüklenirken bir hata oluştu.";
    $urunler = [];
    $kategoriler = [];
}
// --- Ürünleri Getir Bitiş ---

// --- İstatistikleri Hesapla Başlangıç ---
try {
    // Şirketin para birimi ayarlarını kontrol et
    $aktif_sirket_id = $_SESSION['aktif_sirket_id'];
    $stmt_sirket = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$aktif_sirket_id]);
    $sirket_ayarlari = $stmt_sirket->fetch(PDO::FETCH_ASSOC);
    $coklu_para_birimi_aktif = $sirket_ayarlari['coklu_para_birimi'] ?? 0;
    $sirket_para_birimi = $sirket_ayarlari['para_birimi'] ?? 'TL';
    
    // Döviz kurlarını veritabanından al
    $doviz_kurlari = [];
    try {
        $stmt_doviz = $db->query("SELECT para_birimi, satis FROM doviz_kurlari ORDER BY guncelleme_tarihi DESC");
        while ($row = $stmt_doviz->fetch(PDO::FETCH_ASSOC)) {
            $doviz_kurlari[$row['para_birimi']] = (float)$row['satis'];
        }
    } catch (Exception $e) {
        error_log("Döviz kuru okuma hatası: " . $e->getMessage());
        // Hata durumunda boş array kullan
    }
    
    // İstatistikleri hesapla - mevcut ürün listesini kullan
    $istatistikler = [
        'toplam_urun_cesidi' => 0,
        'toplam_stok_miktari' => 0,
        'toplam_alis_degeri' => 0,
        'toplam_satis_degeri' => 0
    ];
    
    foreach ($urunler as $urun) {
        $miktar = (float)($urun['stok_miktari'] ?? 0);
        $alis_fiyati = (float)($urun['alis_fiyati'] ?? 0);
        $satis_fiyati = (float)($urun['satis_fiyati'] ?? 0);
        $alis_para_birimi = $urun['alis_para_birimi'] ?? 'TL';
        $satis_para_birimi = $urun['satis_para_birimi'] ?? 'TL';
        
        // Alış kuru - veritabanından al
        $alis_kur = $doviz_kurlari[$alis_para_birimi] ?? 1.0;
        
        // Satış kuru - veritabanından al
        $satis_kur = $doviz_kurlari[$satis_para_birimi] ?? 1.0;
        
        if ($miktar > 0) {
            $istatistikler['toplam_urun_cesidi']++;
            $istatistikler['toplam_stok_miktari'] += $miktar;
            
            // TL cinsinden değerleri hesapla
            $alis_tl = $alis_fiyati * $miktar * $alis_kur;
            $satis_tl = $satis_fiyati * $miktar * $satis_kur;
            
            // Varsayılan para birimi farklıysa çevir
            if ($sirket_para_birimi != 'TL') {
                $varsayilan_kur = $doviz_kurlari[$sirket_para_birimi] ?? 1.0;
                if ($varsayilan_kur > 0) {
                    $alis_tl = $alis_tl / $varsayilan_kur;
                    $satis_tl = $satis_tl / $varsayilan_kur;
                }
            }
            
            $istatistikler['toplam_alis_degeri'] += $alis_tl;
            $istatistikler['toplam_satis_degeri'] += $satis_tl;
        }
    }
    
    // Toplam değerleri yuvarla
    $istatistikler['toplam_alis_degeri'] = round($istatistikler['toplam_alis_degeri'], 2);
    $istatistikler['toplam_satis_degeri'] = round($istatistikler['toplam_satis_degeri'], 2);
    
} catch (PDOException $e) {
    error_log("Ürün istatistikleri hatası: " . $e->getMessage());
    $istatistikler = ['toplam_urun_cesidi' => 0, 'toplam_stok_miktari' => 0, 'toplam_alis_degeri' => 0, 'toplam_satis_degeri' => 0];
}
// --- İstatistikleri Hesapla Bitiş ---

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Begeb Creative Yönetim - <?= __("product_management") ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        body {
            background: #f8fafc;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        }

        .page-header {
            background: white;
            border-radius: 2px;
            padding: 1.5rem;
            margin-bottom: 2rem;
            border: 1px solid #e2e8f0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
        }

        .page-header h2 {
            color: #1e293b;
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0;
        }

        .page-header .btn {
            border-radius: 2px;
            padding: 0.5rem 1rem;
            font-weight: 600;
            font-size: 0.875rem;
            border-width: 1.5px;
        }

        .modern-card {
            background: white;
            border-radius: 2px;
            border: 1px solid #e2e8f0;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
            overflow: hidden;
            margin-bottom: 1.5rem;
        }

        .card-section {
            padding: 1.5rem;
            border-bottom: 1px solid #f1f5f9;
        }

        .card-section:last-child {
            border-bottom: none;
        }

        .section-title {
            color: #1e293b;
            font-size: 1rem;
            font-weight: 700;
            margin-bottom: 1.25rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .section-title i {
            color: #3b82f6;
            font-size: 1.125rem;
        }

        .stats-card {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 2px;
            padding: 1.5rem;
            color: white;
            border: none;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: transform 0.2s ease;
        }

        .stats-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
        }

        .stats-card.primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }

        .stats-card.info {
            background: linear-gradient(135deg, #00d2ff 0%, #3a7bd5 100%);
        }

        .stats-card.danger {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }

        .stats-card.success {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }

        .stats-card .stats-icon {
            font-size: 2rem;
            opacity: 0.9;
        }

        .stats-card .stats-value {
            font-size: 1.75rem;
            font-weight: 700;
            margin: 0.5rem 0;
        }

        .stats-card .stats-label {
            font-size: 0.875rem;
            opacity: 0.95;
            font-weight: 500;
        }

        .form-label {
            color: #334155;
            font-weight: 600;
            font-size: 0.8125rem;
            margin-bottom: 0.375rem;
        }

        .form-control, .form-select {
            border: 1px solid #e2e8f0;
            border-radius: 2px;
            padding: 0.5rem 0.75rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.08);
        }

        .btn-primary {
            background: #3b82f6;
            border: none;
            border-radius: 2px;
            padding: 0.625rem 1.25rem;
            font-weight: 600;
            font-size: 0.875rem;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: #2563eb;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
        }

        .btn-outline-primary {
            border: 1.5px solid #3b82f6;
            color: #3b82f6;
            border-radius: 2px;
            padding: 0.625rem 1.25rem;
            font-weight: 600;
            font-size: 0.875rem;
        }

        .btn-outline-primary:hover {
            background: #3b82f6;
            color: white;
        }

        .table {
            font-size: 0.875rem;
        }

        .table thead th {
            background: #f8fafc;
            color: #475569;
            font-weight: 600;
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: 0.025em;
            border-bottom: 2px solid #e2e8f0;
            padding: 0.75rem 1rem;
        }

        .table tbody td {
            padding: 1rem;
            vertical-align: middle;
            border-bottom: 1px solid #f1f5f9;
            white-space: nowrap;
        }

        .table tbody tr:hover {
            background: #f8fafc;
        }

        .table tbody td.product-name-cell {
            white-space: normal;
            max-width: 400px;
        }

        .table tbody td.product-name-cell .fw-semibold {
            display: block;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
        }

        .table tbody td.product-name-cell .product-info-line {
            font-size: 0.525rem; /* %30 küçültülmüş (0.75rem * 0.7 = 0.525rem) */
            line-height: 1.4;
        }

        .table tbody td.product-name-cell .product-info-line small {
            font-size: inherit;
        }

        .table tbody td.product-name-cell .product-info-line span {
            white-space: nowrap;
        }

        .table tbody td.product-name-cell .product-info-line strong {
            color: #475569;
        }

        .stok-badge {
            min-width: 60px;
            padding: 0.375rem 0.75rem;
            font-weight: 600;
            white-space: nowrap;
        }

        .product-image {
            width: 50px;
            height: 50px;
            object-fit: cover;
            border-radius: 4px;
            border: 1px solid #e2e8f0;
        }

        .product-icon {
            font-size: 2rem;
            color: #cbd5e1;
        }

        .btn-group-sm .btn {
            padding: 0.375rem 0.625rem;
            font-size: 0.75rem;
            white-space: nowrap;
        }

        .price-cell {
            white-space: nowrap;
        }

        .price-cell .fw-semibold {
            display: block;
        }

        .price-cell small {
            display: block;
        }

        @media (max-width: 768px) {
            .page-header {
                padding: 1rem;
            }

            .page-header h2 {
                font-size: 1.25rem;
            }

            .stats-card {
                padding: 1rem;
            }

            .stats-card .stats-value {
                font-size: 1.5rem;
            }

            .card-section {
                padding: 1.25rem;
            }

            .table {
                font-size: 0.8125rem;
            }
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4 mb-5">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center flex-wrap gap-3">
                <h2><i class="bi bi-box-seam me-2"></i><?= temizle($sayfa_baslik) ?></h2>
                <a href="urun_ekle.php" class="btn btn-primary">
                    <i class="bi bi-plus-circle me-2"></i><?= __('add_new_product') ?>
                </a>
            </div>
        </div>

        <!-- İstatistik Kartları -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="stats-card primary">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <div class="stats-label"><?= __('product_variety') ?></div>
                            <div class="stats-value"><?= number_format($istatistikler['toplam_urun_cesidi'] ?? 0) ?></div>
                        </div>
                        <div class="stats-icon">
                            <i class="bi bi-collection"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="stats-card info">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <div class="stats-label"><?= __('total_stock') ?></div>
                            <div class="stats-value"><?= number_format($istatistikler['toplam_stok_miktari'] ?? 0) ?></div>
                        </div>
                        <div class="stats-icon">
                            <i class="bi bi-boxes"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="stats-card danger">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <div class="stats-label"><?= __('stock_purchase_value') ?></div>
                            <div class="stats-value"><?= number_format($istatistikler['toplam_alis_degeri'] ?? 0, 2, ',', '.') ?> ₺</div>
                            <?php if ($coklu_para_birimi_aktif): ?>
                                <small class="opacity-75"><?= __('total_value_in_tl') ?></small>
                            <?php endif; ?>
                        </div>
                        <div class="stats-icon">
                            <i class="bi bi-arrow-down-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6 mb-3">
                <div class="stats-card success">
                    <div class="d-flex justify-content-between align-items-start">
                        <div>
                            <div class="stats-label"><?= __('stock_sale_value') ?></div>
                            <div class="stats-value"><?= number_format($istatistikler['toplam_satis_degeri'] ?? 0, 2, ',', '.') ?> ₺</div>
                            <?php if ($coklu_para_birimi_aktif): ?>
                                <small class="opacity-75"><?= __('total_value_in_tl') ?></small>
                            <?php endif; ?>
                        </div>
                        <div class="stats-icon">
                            <i class="bi bi-arrow-up-circle"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Arama ve Filtreler -->
        <div class="modern-card">
            <div class="card-section">
                <div class="section-title">
                    <i class="bi bi-funnel"></i>
                    <span><?= __('search_and_filter') ?></span>
                </div>
                <form method="get" class="row g-3">
                    <div class="col-md-5">
                        <label for="arama" class="form-label"><?= __('product_search') ?></label>
                        <div class="input-group">
                            <span class="input-group-text bg-white border-end-0">
                                <i class="bi bi-search text-muted"></i>
                            </span>
                            <input type="text" class="form-control border-start-0" id="arama" name="arama" 
                                   placeholder="<?= __('product_search_placeholder') ?>" value="<?= htmlspecialchars($arama) ?>">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <label for="kategori" class="form-label"><?= __('category') ?></label>
                        <select class="form-select" id="kategori" name="kategori">
                            <option value=""><?= __('all_categories') ?></option>
                            <?php foreach ($kategoriler as $kategori): ?>
                                <option value="<?= $kategori['id'] ?>" <?= $kategori_filtre == $kategori['id'] ? 'selected' : '' ?>>
                                    <?= temizle($kategori['kategori_adi']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3 d-flex align-items-end gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">
                            <i class="bi bi-search me-1"></i><?= __('search') ?>
                        </button>
                        <a href="urunler.php" class="btn btn-outline-secondary" title="<?= __('reset') ?>">
                            <i class="bi bi-arrow-clockwise"></i>
                        </a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Ürün Listesi -->
        <div class="modern-card">
            <div class="card-section">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div class="section-title mb-0">
                        <i class="bi bi-list-ul"></i>
                        <span><?= __('product_list') ?></span>
                        <span class="badge bg-secondary ms-2"><?= count($urunler) ?></span>
                    </div>
                </div>
                
                <?php if (empty($urunler)): ?>
                    <div class="text-center py-5">
                        <div class="mb-3">
                            <i class="bi bi-inbox" style="font-size: 4rem; color: #cbd5e1;"></i>
                        </div>
                        <h5 class="text-muted mb-2">
                            <?= empty($arama) && empty($kategori_filtre) ? __('no_products_added') : __('no_products_found') ?>
                        </h5>
                        <?php if (empty($arama) && empty($kategori_filtre)): ?>
                            <p class="text-muted mb-3"><?= __('start_by_adding_first_product') ?></p>
                            <a href="urun_ekle.php" class="btn btn-primary">
                                <i class="bi bi-plus-circle me-2"></i><?= __('add_first_product') ?>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <?php if ($api_resim_gorunur == '1'): ?>
                                        <th style="width: 70px;"><?= __('image') ?></th>
                                    <?php endif; ?>
                                    <th><?= __('product_name') ?></th>
                                    <th class="text-end"><?= __('purchase_price') ?></th>
                                    <th class="text-end"><?= __('sale_price') ?></th>
                                    <th class="text-center"><?= __('vat') ?> (%)</th>
                                    <th class="text-center"><?= __('stock') ?></th>
                                    <th class="text-center"><?= __('critical_stock_level') ?></th>
                                    <th class="text-center"><?= __('actions') ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $toplam_alis_degeri_kart = 0;
                                $toplam_satis_degeri_kart = 0;
                                foreach ($urunler as $urun): 
                                    // Ürünün para birimi bilgilerini al
                                    $alis_para_birimi = $urun['alis_para_birimi'] ?? 'TL';
                                    $satis_para_birimi = $urun['satis_para_birimi'] ?? 'TL';
                                    
                                    if ($alis_para_birimi === 'TRY') { $alis_para_birimi = 'TL'; }
                                    if ($satis_para_birimi === 'TRY') { $satis_para_birimi = 'TL'; }
                                    
                                    // Para birimi sembolünü belirle
                                    $alis_para_birimi_sembol = '';
                                    $satis_para_birimi_sembol = '';
                                    
                                    switch($alis_para_birimi) {
                                        case 'USD':
                                            $alis_para_birimi_sembol = '$';
                                            break;
                                        case 'EUR':
                                            $alis_para_birimi_sembol = '€';
                                            break;
                                        case 'GBP':
                                            $alis_para_birimi_sembol = '£';
                                            break;
                                        default:
                                            $alis_para_birimi_sembol = '₺';
                                            $alis_para_birimi = 'TL';
                                    }
                                    
                                    switch($satis_para_birimi) {
                                        case 'USD':
                                            $satis_para_birimi_sembol = '$';
                                            break;
                                        case 'EUR':
                                            $satis_para_birimi_sembol = '€';
                                            break;
                                        case 'GBP':
                                            $satis_para_birimi_sembol = '£';
                                            break;
                                        default:
                                            $satis_para_birimi_sembol = '₺';
                                            $satis_para_birimi = 'TL';
                                    }
                                    
                                    // Ürün için güncel kurları al - veritabanından alınan kurları kullan
                                    $alis_kuru = $doviz_kurlari[$alis_para_birimi] ?? 1.0;
                                    $satis_kuru = $doviz_kurlari[$satis_para_birimi] ?? 1.0;
                                ?>
                                <tr>
                                    <?php if ($api_resim_gorunur == '1'): ?>
                                    <td class="text-center">
                                        <?php if (!empty($urun['varsayilan_resim'])): 
                                            $resim_yolu = htmlspecialchars(trim($stok_resim_dizini, '/') . '/' . $urun['varsayilan_resim']);
                                            
                                        // Para birimi sembolünü al
                                        $para_birimi = $urun['para_birimi'] ?? 'TL';
                                        $para_birimi_sembol = getParaBirimiSembolu($para_birimi);
                                        ?>
                                            <img src="<?= BASE_URL . '/' . $resim_yolu ?>" 
                                                 alt="<?= htmlspecialchars($urun['urun_adi']) ?>" 
                                                 class="product-image">
                                        <?php else: ?>
                                            <i class="bi bi-image product-icon"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <td class="product-name-cell">
                                        <div class="fw-semibold text-dark" title="<?= temizle($urun['urun_adi']) ?>">
                                            <?= temizle($urun['urun_adi']) ?>
                                        </div>
                                        <div class="mt-1 product-info-line">
                                            <small class="text-muted">
                                                <?php if (!empty($urun['barkod'])): ?>
                                                    <span>Kod: <strong><?= temizle($urun['barkod']) ?></strong></span>
                                                <?php endif; ?>
                                                <?php if (!empty($urun['kategori_adi'])): ?>
                                                    <span class="ms-2">| Kategori: <strong><?= temizle($urun['kategori_adi']) ?></strong></span>
                                                <?php endif; ?>
                                                <?php if (!empty($urun['marka_adi'])): ?>
                                                    <span class="ms-2">| Marka: <strong><?= temizle($urun['marka_adi']) ?></strong></span>
                                                <?php endif; ?>
                                                <?php if (!empty($urun['birim'])): ?>
                                                    <span class="ms-2">| Birim: <strong><?= temizle($urun['birim']) ?></strong></span>
                                                <?php endif; ?>
                                                <?php
                                                // Depo ve raf bilgilerini getir
                                                if ($depo_yonetimi_aktif) {
                                                    try {
                                                        $stmt_depo_raf = $db->prepare("
                                                            SELECT d.depo_adi, r.raf_adi 
                                                            FROM urun_depo_raf udr
                                                            LEFT JOIN depolar d ON udr.depo_id = d.id
                                                            LEFT JOIN raflar r ON udr.raf_id = r.id
                                                            WHERE udr.urun_id = ? AND udr.sirket_id = ?
                                                            LIMIT 1
                                                        ");
                                                        $stmt_depo_raf->execute([$urun['id'], $_SESSION['aktif_sirket_id']]);
                                                        $depo_raf_info = $stmt_depo_raf->fetch(PDO::FETCH_ASSOC);
                                                        
                                                        if ($depo_raf_info):
                                                            if (!empty($depo_raf_info['depo_adi'])):
                                                ?>
                                                    <span class="ms-2">| Depo: <strong><?= temizle($depo_raf_info['depo_adi']) ?></strong></span>
                                                <?php 
                                                            endif;
                                                            if (!empty($depo_raf_info['raf_adi'])):
                                                ?>
                                                    <span class="ms-2">| Raf: <strong><?= temizle($depo_raf_info['raf_adi']) ?></strong></span>
                                                <?php 
                                                            endif;
                                                        endif;
                                                    } catch (Exception $e) {
                                                        // Hata durumunda sessizce devam et
                                                    }
                                                }
                                                ?>
                                            </small>
                                        </div>
                                    </td>
                                    <td class="text-end price-cell">
                                        <?php 
                                        $alis_fiyati = (float)($urun['alis_fiyati'] ?? 0);
                                        echo '<span class="fw-semibold">' . number_format($alis_fiyati, 2, ',', '.') . ' ' . $alis_para_birimi_sembol . '</span>';
                                         if ($alis_para_birimi != 'TL' && $alis_fiyati > 0) {
                                             // Veritabanından alınan kurları kullan
                                             $guncel_kur = $doviz_kurlari[$alis_para_birimi] ?? 1.0;
                                             echo ' <small class="text-muted">(~' . number_format($alis_fiyati * $guncel_kur, 2, ',', '.') . ' ₺)</small>';
                                         }
                                        ?>
                                    </td>
                                    <td class="text-end price-cell">
                                        <?php 
                                        $satis_fiyati = (float)($urun['satis_fiyati'] ?? 0);
                                        echo '<span class="fw-semibold">' . number_format($satis_fiyati, 2, ',', '.') . ' ' . $satis_para_birimi_sembol . '</span>';
                                         if ($satis_para_birimi != 'TL' && $satis_fiyati > 0) {
                                             // Veritabanından alınan kurları kullan
                                             $guncel_kur = $doviz_kurlari[$satis_para_birimi] ?? 1.0;
                                             echo ' <small class="text-muted">(~' . number_format($satis_fiyati * $guncel_kur, 2, ',', '.') . ' ₺)</small>';
                                         }
                                        ?>
                                    </td>
                                    <td class="text-center">
                                        <?php if ($urun['kdv_orani'] > 0): ?>
                                            <span class="badge bg-info">%<?= number_format($urun['kdv_orani'], 0) ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-secondary"><?= __('vat_free') ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-<?= $urun['stok_durumu_class'] ?> stok-badge">
                                            <?= number_format($urun['stok_miktari'] ?? 0, 2, ',', '.') ?>
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <?= $urun['kritik_stok'] > 0 ? number_format($urun['kritik_stok'], 0) : '-' ?>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="urun_duzenle.php?id=<?= $urun['id'] ?>" 
                                               class="btn btn-outline-primary" title="<?= __('edit') ?>">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            <a href="stok_detay.php?id=<?= $urun['id'] ?>" 
                                               class="btn btn-outline-success" title="<?= __('stock_detail_analysis') ?>">
                                                <i class="bi bi-graph-up"></i>
                                            </a>
                                            <a href="stok_hareketleri.php?urun_id=<?= $urun['id'] ?>" 
                                               class="btn btn-outline-info" title="<?= __('stock_movements') ?>">
                                                <i class="bi bi-clock-history"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php include __DIR__ . '/../includes/footer.php'; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // Smooth scroll to top
    window.addEventListener('scroll', function() {
        const scrollTop = document.documentElement.scrollTop;
        if (scrollTop > 300) {
            document.body.classList.add('scrolled');
        } else {
            document.body.classList.remove('scrolled');
        }
    });
    </script>
</body>
</html>

