<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/ayar_fonksiyonlari.php';
yetkili_mi('yonetici'); // Admin ve Yöneticiler erişebilir

$sayfa_baslik = __("quote_without_stock");
$paraBirimi = getParaBirimiSembolu(); // Varsayılan para birimi

// Çoklu para birimi desteği
$coklu_para_birimi_aktif = true; // Her zaman aktif

// Döviz kurlarını veritabanından çek
try {
    $stmt = $db->query("SELECT para_birimi, alis, satis, guncelleme_tarihi FROM doviz_kurlari ORDER BY id");
    $doviz_kurlari = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log('Döviz kurları çekilemedi: ' . $e->getMessage());
    $doviz_kurlari = [];
}

// Varsayılan para birimi
$sirket_para_birimi = 'TL';

// Varsayılan para birimleri (hata durumu için)
$para_birimleri = [
    ['kod' => 'TL', 'ad' => 'Türk Lirası', 'symbol' => '₺'],
    ['kod' => 'USD', 'ad' => 'Dolar', 'symbol' => '$'],
    ['kod' => 'EUR', 'ad' => 'Euro', 'symbol' => '€']
];

// Varsayılan para birimi
$secili_para_birimi = 'TL';

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
    } else {
        $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);
        $teklif_tarihi = filter_input(INPUT_POST, 'teklif_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
        $gecerlilik_tarihi = filter_input(INPUT_POST, 'gecerlilik_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
        $genel_aciklama = temizle($_POST['genel_aciklama'] ?? '');
        $indirim_tutari = filter_var(str_replace(',', '.', $_POST['indirim_tutari'] ?? '0'), FILTER_VALIDATE_FLOAT);
        if ($indirim_tutari === false) $indirim_tutari = 0;
        
        // Para birimini al
        $teklif_para_birimi = temizle($_POST['fatura_para_birimi'] ?? 'TL');
        // Eğer TL seçildiyse, veritabanında TRY olarak kaydet
        if ($teklif_para_birimi === 'TL') {
            $teklif_para_birimi = 'TRY';
        }
        if ($teklif_para_birimi === 'TL') {
            $teklif_para_birimi = 'TRY';
        }

        // Kalem kalem girişleri al
        $aciklamalar = $_POST['aciklama'] ?? [];
        $tutarlar = $_POST['tutar'] ?? [];
        $birlesik_aciklama = '';
        $toplam_tutar = 0;

        if (is_array($aciklamalar) && is_array($tutarlar)) {
            foreach ($tutarlar as $index => $tutar) {
                $tutar_float = filter_var(str_replace(',', '.', $tutar ?? '0'), FILTER_VALIDATE_FLOAT);
                $aciklama_satiri = temizle($aciklamalar[$index] ?? '');

                if ($tutar_float > 0) {
                    $toplam_tutar += $tutar_float;
                    // Açıklamayı, satır tutarıyla birlikte birleştir
                    $birlesik_aciklama .= $aciklama_satiri . " (" . number_format($tutar_float, 2, ',', '.') . " " . $teklif_para_birimi . ")\n";
                }
            }
        }
        $birlesik_aciklama = trim($birlesik_aciklama);
        
        // Genel açıklama varsa ekle
        if (!empty($genel_aciklama)) {
            $birlesik_aciklama = $genel_aciklama . "\n\n" . $birlesik_aciklama;
        }
        
        $toplam_kdv = 0; // Stoksuz işlemlerde KDV hesaplaması yapılmaz
        
        $hatalar = [];
        if (empty($cari_id)) $hatalar[] = __("customer_required");
        if (empty($teklif_tarihi)) $hatalar[] = __("quote_date_required");
        if ($toplam_tutar <= 0) $hatalar[] = __("at_least_one_item_required");

        if (empty($hatalar)) {
            try {
                $db->beginTransaction();
                $stmt_teklif = $db->prepare("INSERT INTO teklifler (sirket_id, cari_id, teklif_tarihi, gecerlilik_tarihi, tutar, toplam_kdv, indirim_tutari, aciklama, para_birimi) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt_teklif->execute([$_SESSION['aktif_sirket_id'], $cari_id, $teklif_tarihi, empty($gecerlilik_tarihi) ? null : $gecerlilik_tarihi, $toplam_tutar, $toplam_kdv, $indirim_tutari, $birlesik_aciklama, $teklif_para_birimi]);
                $teklif_id = $db->lastInsertId();

                // Stoksuz tekliflerde ürün detayları kaydedilmez, sadece açıklama kullanılır

                $db->commit();

                // LOGLAMA İŞLEMİ EKLENDİ
                $stmt_cari_ad = $db->prepare("SELECT ad_soyad FROM cariler WHERE id = ? AND sirket_id = ?");
                $stmt_cari_ad->execute([$cari_id, $_SESSION['aktif_sirket_id']]);
                $cari_adi = $stmt_cari_ad->fetchColumn();
                $genel_toplam = $toplam_tutar - $indirim_tutari;
                $log_mesaji = sprintf(__('user_created_quote_log'), $teklif_id, $cari_adi, number_format($genel_toplam, 2) . ' ' . $teklif_para_birimi);
                sistem_log_ekle($db, 'ekle', 'teklifler', $teklif_id, $_SESSION['aktif_sirket_id'], ['teklif_verileri' => $_POST], $log_mesaji);

                $_SESSION['mesaj'] = sprintf(__('quote_without_stock_created'), $teklif_id);
                header("Location: teklifler.php");
                exit();
            } catch (Exception $e) {
                $db->rollBack();
                $_SESSION['hata'] = __("error_creating_quote") . ': ' . $e->getMessage();
            }
        } else {
            $_SESSION['form_hatalari'] = $hatalar;
            $_SESSION['form_verileri'] = $_POST;
        }
    }
    header("Location: teklifstoksuz.php");
    exit();
}

// Cariler ve tedarikçiler sorgularını güncelle
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

$stmt_cariler = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE sirket_id = ? ORDER BY ad_soyad");
$stmt_cariler->execute([$aktif_sirket_id]);
$cariler = $stmt_cariler->fetchAll(PDO::FETCH_ASSOC);



$csrf_token = csrf_token_olustur();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?> - <?= __("app_name") ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .hidden { display: none !important; }
        .toplam-alan { background: #fff3cd; border: 1px solid #ffeeba; border-radius: 0.375rem; }
        .is-invalid { border-color: #dc3545 !important; }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center">
            <h2><i class="bi bi-file-earmark-text-fill"></i> <?= temizle($sayfa_baslik) ?></h2>
            <a href="teklifler.php" class="btn btn-secondary"><i class="bi bi-list-ul"></i> <?= __("quote_list") ?></a>
        </div>
        <hr>

        <form method="post" id="teklifForm">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            
            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><?= __("quote_information") ?></span>
                    <div class="d-flex align-items-center">
                        <label for="fatura_para_birimi" class="form-label mb-0 small me-2"><?= __('currency') ?></label>
                        <select class="form-select form-select-sm w-auto" id="fatura_para_birimi" name="fatura_para_birimi" onchange="faturaParaBirimiDegistir(this)">
                            <option value="TL" <?= (empty($secili_para_birimi) || $secili_para_birimi === 'TL' || $secili_para_birimi === 'TRY') ? 'selected' : '' ?>>TL</option>
                            <?php $___seen_pb = []; foreach ($doviz_kurlari as $kur): $pb = $kur['para_birimi']; if (in_array($pb, $___seen_pb)) continue; $___seen_pb[] = $pb; ?>
                                <option value="<?= htmlspecialchars($pb) ?>" <?= ($secili_para_birimi === $pb) ? 'selected' : '' ?>><?= htmlspecialchars($pb) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="cari_arama" class="form-label"><?= __("customer") ?> <span class="text-danger">*</span></label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="cari_arama" placeholder="<?= __("search_customer") ?>" autocomplete="off">
                                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#yeniCariModal"><i class="bi bi-plus-circle"></i></button>
                            </div>
                            <div id="cariSonuclar" class="list-group position-absolute w-100 shadow-sm" style="z-index: 1050; display: none;"></div>
                            <input type="hidden" id="cari_id" name="cari_id" required>
                            <div id="seciliCari" class="form-text mt-2"></div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="teklif_tarihi" class="form-label"><?= __("quote_date") ?> <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="teklif_tarihi" name="teklif_tarihi" value="<?= date('Y-m-d') ?>" required>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="gecerlilik_tarihi" class="form-label"><?= __("valid_until") ?></label>
                            <input type="date" class="form-control" id="gecerlilik_tarihi" name="gecerlilik_tarihi">
                        </div>
                        <div class="col-12">
                            <label for="genel_aciklama" class="form-label"><?= __("general_description") ?></label>
                            <textarea class="form-control" id="genel_aciklama" name="genel_aciklama" rows="2"></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dinamik İşlem Kalemleri -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light d-flex justify-content-between align-items-center">
                    <h5 class="mb-0"><i class="bi bi-journal-text me-2"></i><?= __("transaction_items") ?></h5>
                    <button type="button" class="btn btn-sm btn-outline-primary" id="addKalemRow"><i class="bi bi-plus-circle me-1"></i> <?= __("add_item") ?></button>
                </div>
                <div class="card-body">
                    <div id="kalemRows">
                        <div class="row kalem-row mb-2">
                            <div class="col-md-7">
                                <label class="form-label"><?= __("description") ?></label>
                                <input type="text" class="form-control" name="aciklama[]" placeholder="<?= __("e_g_consulting_services_project_management") ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label"><?= __("amount") ?> </label>
                                <input type="text" class="form-control tutar-input" name="tutar[]" placeholder="0,00" required>
                            </div>
                            <div class="col-md-1 d-flex align-items-end">
                                <button type="button" class="btn btn-outline-danger remove-kalem-row"><i class="bi bi-x-circle"></i></button>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row justify-content-end">
                        <div class="col-md-5">
                            <div class="toplam-alan p-3">
                                <ul class="list-group">
                                    <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                        <strong><?= __("total") ?>:</strong>
                                        <span class="fw-bold">
                                            <span id="genelToplam">0.00</span> 
                                            <span id="toplamParaBirimi" class="para-birimi-sembol"><?= $secili_para_birimi ?></span>
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="text-center">
                <button type="submit" class="btn btn-success btn-lg"><i class="bi bi-save"></i> <?= __("save_quote") ?></button>
            </div>
        </form>
    </div>


    
    <!-- Yeni Cari Modalı -->
    <?php include __DIR__ . '/../includes/cari_ekle_modal.php'; ?>
    
    <script src="<?= BASE_URL ?>/assets/js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    // Fatura para birimi değiştiğinde
    function faturaParaBirimiDegistir(select) {
        const yeniParaBirimi = select.value;
        
        // Toplam para birimini güncelle
        document.getElementById('toplamParaBirimi').textContent = yeniParaBirimi;
        
        // Tüm para birimi sembollerini güncelle
        document.querySelectorAll('.para-birimi-sembol').forEach(el => {
            el.textContent = yeniParaBirimi;
        });
        
        // Tüm kalemlerin para birimini güncelle
        document.querySelectorAll('.kalem-para-birimi').forEach(el => {
            el.value = yeniParaBirimi;
        });
        
        // Toplamı güncelle
        if (typeof updateToplam === 'function') {
            updateToplam();
        }
    }

    document.addEventListener('DOMContentLoaded', function() {
        const kalemRowsContainer = document.getElementById('kalemRows');
        const genelToplamElement = document.getElementById('genelToplam');
        let paraBirimi = "<?= $paraBirimi ?>";

        function formatCurrency(value) {
            let val = parseFloat(value);
            if (isNaN(val)) val = 0;
            return val.toLocaleString('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
        }

        function calculateTotal() {
            let total = 0;
            kalemRowsContainer.querySelectorAll('.tutar-input').forEach(input => {
                let value = parseFloat(input.value.replace(/\./g, '').replace(',', '.')) || 0;
                total += value;
            });
            const currentCurrency = document.getElementById('fatura_para_birimi').value;
            genelToplamElement.textContent = formatCurrency(total);
        }

        function addRowListeners(row) {
            row.querySelector('.tutar-input').addEventListener('input', function(e) {
                let value = e.target.value.replace(/[^\d,]/g, '');
                e.target.value = value;
                calculateTotal();
            });

            row.querySelector('.remove-kalem-row').addEventListener('click', function() {
                if (kalemRowsContainer.querySelectorAll('.kalem-row').length > 1) {
                    row.remove();
                    calculateTotal();
                } else {
                    alert('<?= __("at_least_one_item") ?>');
                }
            });
        }

        document.getElementById('addKalemRow').addEventListener('click', function() {
            const firstRow = kalemRowsContainer.querySelector('.kalem-row');
            const newRow = firstRow.cloneNode(true);
            newRow.querySelectorAll('input').forEach(input => input.value = '');
            kalemRowsContainer.appendChild(newRow);
            addRowListeners(newRow);
            calculateTotal();
        });

        // İlk satır için dinleyicileri ekle
        kalemRowsContainer.querySelectorAll('.kalem-row').forEach(row => {
            addRowListeners(row);
        });

        calculateTotal(); // Sayfa yüklendiğinde toplamı hesapla

        // Global cariSec fonksiyonu
        window.cariSec = function(id, adi) {
            document.getElementById('cari_id').value = id;
            document.getElementById('cari_arama').value = adi;
            document.getElementById('seciliCari').innerHTML = `<span class="badge bg-primary">${adi} <i class="bi bi-check-circle-fill ms-1"></i></span>`;
            document.getElementById('cariSonuclar').style.display = 'none';
        };

        // Cari arama fonksiyonları
        function cariAramaBaslat() {
            const cariArama = document.getElementById('cari_arama');
            const cariSonuclar = document.getElementById('cariSonuclar');

            cariArama.addEventListener('input', function() {
                const arama = this.value.trim();
                if (arama.length >= 2) {
                    fetch("../ajax/cari_ara_ajax.php", {
                        method: 'POST',
                        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                        body: 'arama=' + encodeURIComponent(arama)
                    })
                    .then(response => response.json())
                    .then(data => {
                        let html = '';
                        if (data.success && data.cariler.length > 0) {
                            data.cariler.forEach(cari => {
                                const adi = cari.ad_soyad.replace(/'/g, "\\'").replace(/"/g, "&quot;");
                                html += `<a href="#" class="list-group-item list-group-item-action" onclick="event.preventDefault(); cariSec(${cari.id}, '${adi}')">${cari.ad_soyad}</a>`;
                            });
                        } else {
                            html = '<div class="list-group-item text-muted">' + '<?= __("customer_not_found") ?>' + '</div>';
                        }
                        cariSonuclar.innerHTML = html;
                        cariSonuclar.style.display = 'block';
                    });
                } else {
                    cariSonuclar.style.display = 'none';
                }
            });

            document.addEventListener('click', function(e) {
                if (!cariArama.contains(e.target) && !cariSonuclar.contains(e.target)) {
                    cariSonuclar.style.display = 'none';
                }
            });
        }

        // Cari arama sistemini başlat
        cariAramaBaslat();
    });

    // AJAX ile cari ekleme işlemi
    $(function(){
        $('#cariEkleBtn').off('click').on('click', function() {
            var form = $('#yeniCariForm');
            var btn = $(this);
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Kaydediliyor...');
            $.ajax({
                url: '<?= BASE_URL ?>/ajax/cari_ekle_ajax.php',
                method: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(data) {
                    if(data.success) {
                        $('#cariEkleMessage').removeClass('d-none alert-danger').addClass('alert-success').text(data.message);
                        setTimeout(function(){
                            $('#yeniCariModal').modal('hide');
                            form[0].reset();
                            $('#cariEkleMessage').addClass('d-none');
                            // Sayfada cari arama varsa otomatik ekle
                             if ($('#cari_arama').length) {
                                $('#cari_id').val(data.id);
                                $('#seciliCari').html(`<div class="alert alert-success p-2">Seçilen: <strong>${data.ad_soyad}</strong></div>`);
                                $('#cariSonuclar').hide();
                            }
                        }, 1000);
                    } else {
                        $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text(data.message);
                    }
                },
                error: function() {
                    $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text('Cari eklenirken bir hata oluştu.');
                },
                complete: function() {
                    btn.prop('disabled', false).html('Cari Ekle');
                }
            });
        });
    });
    </script>
    
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
