<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/language_functions.php';

yetkili_mi();

// Initialize language
$current_language = getCurrentLanguage();
$translation_file = __DIR__ . "/../languages/{$current_language}.php";
$translations = file_exists($translation_file) ? require $translation_file : [];

// Translation function
if (!function_exists('__')) {
    function __($key, $params = []) {
        global $translations;
        $translation = $translations[$key] ?? $key;
        
        // Replace placeholders if any
        if (!empty($params)) {
            foreach ($params as $param => $value) {
                $translation = str_replace(':' . $param, $value, $translation);
            }
        }
        
        return $translation;
    }
}

$sayfa_baslik = __("quotes");
$paraBirimi = getParaBirimiSembolu(); // Get currency symbol

// Aktif şirket ID'sini al
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

$stmt = $db->prepare("
    SELECT t.*, c.ad_soyad as cari_adi, (t.tutar + t.toplam_kdv - t.indirim_tutari) as toplam_tutar, 
           COALESCE(t.para_birimi, 'TRY') as para_birimi
    FROM teklifler t
    JOIN cariler c ON t.cari_id = c.id AND c.sirket_id = t.sirket_id
    WHERE t.sirket_id = :sirket_id
    ORDER BY t.teklif_tarihi DESC, t.id DESC
");
$stmt->execute(['sirket_id' => $aktif_sirket_id]);
$teklifler = $stmt->fetchAll(PDO::FETCH_ASSOC);

function getDurumBadge($durum) {
    $renkler = [
        'Beklemede' => 'warning text-dark',
        'Onaylandı' => 'info',
        'Reddedildi' => 'danger',
        'Faturalastirildi' => 'success'
    ];
    
    // Translate status text
    $durumText = $durum;
    if (function_exists('__')) {
        $durumText = __(strtolower($durum));
    }
    
    $renk = $renkler[$durum] ?? 'secondary';
    return "<span class=\"badge bg-{$renk}\">{$durumText}</span>";
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>
    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2><i class="bi bi-file-earmark-text-fill"></i> <?= temizle($sayfa_baslik) ?></h2>
            <div>
                <a href="teklifstoksuz.php" class="btn btn-warning me-2"><i class="bi bi-file-earmark-text"></i> <?= __("quote_without_stock") ?></a>
                <a href="teklif_yeni.php" class="btn btn-primary"><i class="bi bi-plus-circle"></i> <?= __("new_quote") ?></a>
            </div>
        </div>

        <?php if (isset($_SESSION['mesaj'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['mesaj'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['mesaj']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['hata'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $_SESSION['hata'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['hata']); ?>
        <?php endif; ?>

        <div class="table-responsive">
            <table class="table table-striped table-hover">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th><?= __("customer") ?></th>
                        <th><?= __("quote_date") ?></th>
                        <th class="text-end"><?= __("amount") ?></th>
                        <th><?= __("status") ?></th>
                        <th class="text-center"><?= __("actions") ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($teklifler)): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted py-3"><?= __("no_quotes_found") ?></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($teklifler as $teklif): ?>
                        <tr>
                            <td><?= $teklif['id'] ?></td>
                            <td><?= temizle($teklif['cari_adi']) ?></td>
                            <td><?= date('d.m.Y', strtotime($teklif['teklif_tarihi'])) ?></td>
                            <td class="text-end">
                                <?= number_format($teklif['toplam_tutar'], 2, ',', '.') ?> 
                                <?= !empty($teklif['para_birimi']) ? $teklif['para_birimi'] : $paraBirimi ?>
                            </td>
                            <td><?= getDurumBadge($teklif['durum']) ?></td>
                            <td class="text-center">
                                <a href="teklif_goruntule.php?id=<?= $teklif['id'] ?>" class="btn btn-info btn-sm" title="<?= __('view') ?>"><i class="bi bi-eye"></i></a>
                                
                                <!-- Stoksuz teklifler için düzenleme linki -->
                                <?php if (empty($teklif['toplam_kdv']) || $teklif['toplam_kdv'] == 0): ?>
                                    <a href="teklifstoksuz_duzenle.php?id=<?= $teklif['id'] ?>" class="btn btn-warning btn-sm" title="<?= __('edit') ?>"><i class="bi bi-pencil"></i></a>
                                <?php else: ?>
                                    <!-- Stoklu teklifler için düzenleme linki -->
                                    <a href="teklif_duzenle.php?id=<?= $teklif['id'] ?>" class="btn btn-warning btn-sm" title="<?= __('edit') ?>"><i class="bi bi-pencil"></i></a>
                                <?php endif; ?>
                                
                                <?php if ($teklif['durum'] != 'Faturalastirildi'): ?>
                                    <a href="teklif_donustur.php?id=<?= $teklif['id'] ?>" class="btn btn-success btn-sm" title="<?= __('convert_to_invoice') ?>" onclick="return confirm('<?= addslashes(__('confirm_convert_to_invoice')) ?>')"><i class="bi bi-arrow-right-circle"></i></a>
                                <?php endif; ?>
                                <?php if ($teklif['durum'] == 'Beklemede'): ?>
                                    <a href="teklif_iptal.php?id=<?= $teklif['id'] ?>" class="btn btn-warning btn-sm" title="<?= __('cancel') ?>" onclick="return confirm('<?= addslashes(__('confirm_cancel_quote')) ?>')"><i class="bi bi-x-circle"></i></a>
                                <?php endif; ?>
                                <a href="teklif_sil.php?id=<?= $teklif['id'] ?>" class="btn btn-danger btn-sm" title="<?= __('delete') ?>" onclick="return confirm('<?= addslashes(__('confirm_delete_quote')) ?>')"><i class="bi bi-trash"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
