<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi('yonetici'); // Admin ve Yöneticiler erişebilir

$sayfa_baslik = __("new_quote");
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

// Çoklu para birimi durumunu kontrol et
try {
    $stmt_coklu_pb = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
    $stmt_coklu_pb->execute([$aktif_sirket_id]);
    $sirket_ayarlari = $stmt_coklu_pb->fetch(PDO::FETCH_ASSOC);
    $coklu_para_birimi_aktif = (bool) ($sirket_ayarlari['coklu_para_birimi'] ?? 0);
    $sirket_para_birimi = $sirket_ayarlari['para_birimi'] ?? 'TL';
} catch (PDOException $e) {
    $coklu_para_birimi_aktif = 0;
    $sirket_para_birimi = 'TL';
}

$paraBirimi = getParaBirimiSembolu(); // Para birimini al

// Veritabanından döviz kurlarını çek
$doviz_kurlari = [];
if ($coklu_para_birimi_aktif) {
    try {
        $stmt_doviz = $db->prepare("SELECT para_birimi, alis, satis, guncelleme_tarihi FROM doviz_kurlari ORDER BY id");
        $stmt_doviz->execute();
        $doviz_kurlari = $stmt_doviz->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // Hata durumunda boş dizi kullan
        $doviz_kurlari = [];
    }
}

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
    } else {
        $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);
        $teklif_tarihi = filter_input(INPUT_POST, 'teklif_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
        $gecerlilik_tarihi = filter_input(INPUT_POST, 'gecerlilik_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
        $aciklama = temizle($_POST['aciklama'] ?? '');
        $indirim_tutari = filter_var(str_replace(',', '.', $_POST['indirim_tutari'] ?? '0'), FILTER_VALIDATE_FLOAT);
        if ($indirim_tutari === false) $indirim_tutari = 0;
        
        // Teklif para birimi
        $teklif_para_birimi = temizle($_POST['teklif_para_birimi'] ?? 'TL');
        if ($teklif_para_birimi === 'TL') $teklif_para_birimi = 'TRY';

        $urun_detaylari = [];
        $toplam_tutar = 0;
        $toplam_kdv = 0;

        $urun_ids = $_POST['urun_id'] ?? [];
        $miktarlar = $_POST['miktar'] ?? [];
        $birim_fiyatlar = $_POST['birim_fiyat'] ?? [];
        $kdv_oranlari = $_POST['kdv_orani'] ?? [];
        $kurlar = $_POST['kur'] ?? [];
        $satis_para_birimleri = $_POST['satis_para_birimi'] ?? [];

        foreach ($urun_ids as $index => $urun_id) {
            if (!empty($urun_id) && !empty($miktarlar[$index]) && isset($birim_fiyatlar[$index])) {
                $miktar = filter_var(str_replace(',', '.', $miktarlar[$index]), FILTER_VALIDATE_FLOAT);
                $birim_fiyat = filter_var(str_replace(',', '.', $birim_fiyatlar[$index]), FILTER_VALIDATE_FLOAT);
                $kdv_orani = filter_var(str_replace(',', '.', $kdv_oranlari[$index]), FILTER_VALIDATE_FLOAT);
                $kur = filter_var(str_replace(',', '.', $kurlar[$index] ?? '1'), FILTER_VALIDATE_FLOAT);
                $satis_para_birimi = temizle($satis_para_birimleri[$index] ?? 'TL');

                if ($miktar > 0 && $birim_fiyat >= 0) {
                    // KDV ve toplam önce orijinal para biriminde hesaplanır, sonra teklif para birimine çevrilir
                    $satir_toplam_orj = $miktar * $birim_fiyat; // Orijinal para birimi
                    $kdv_tutari_orj = ($satir_toplam_orj * $kdv_orani) / 100; // Orijinal para birimi

                    $satir_toplam_teklif_pb = $satir_toplam_orj * $kur; // Teklif para birimi
                    $kdv_tutari_teklif_pb = $kdv_tutari_orj * $kur; // Teklif para birimi

                    $urun_detaylari[] = [
                        'urun_id' => $urun_id, 
                        'miktar' => $miktar, 
                        'birim_fiyat' => $birim_fiyat, // Orijinal birim fiyat
                        'toplam_tutar' => $satir_toplam_teklif_pb, // Teklif para birimi cinsinden toplam tutar
                        'kdv_orani' => $kdv_orani, 
                        'kdv_tutari' => $kdv_tutari_teklif_pb, // Teklif para birimi cinsinden KDV tutarı
                        'kur' => $kur,
                        'satis_para_birimi' => $satis_para_birimi
                    ];
                    
                    // Genel toplama çevrilmiş tutarları ekle
                    $toplam_tutar += $satir_toplam_teklif_pb;
                    $toplam_kdv += $kdv_tutari_teklif_pb;
                }
            }
        }
        
        $hatalar = [];
        if (empty($cari_id)) $hatalar[] = "Müşteri seçimi zorunludur.";
        if (empty($teklif_tarihi)) $hatalar[] = "Teklif tarihi zorunludur.";
        if (empty($urun_detaylari)) $hatalar[] = "Teklif için en az bir ürün eklemelisiniz.";

        if (empty($hatalar)) {
            try {
                $db->beginTransaction();
                $stmt_teklif = $db->prepare("INSERT INTO teklifler (sirket_id, cari_id, teklif_tarihi, gecerlilik_tarihi, tutar, toplam_kdv, indirim_tutari, aciklama, para_birimi) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt_teklif->execute([$_SESSION['aktif_sirket_id'], $cari_id, $teklif_tarihi, empty($gecerlilik_tarihi) ? null : $gecerlilik_tarihi, $toplam_tutar, $toplam_kdv, $indirim_tutari, $aciklama, $teklif_para_birimi]);
                $teklif_id = $db->lastInsertId();

                $stmt_detay = $db->prepare("INSERT INTO teklif_detaylari (teklif_id, urun_id, miktar, birim_fiyat, kdv_orani, kdv_tutari, toplam_tutar, sirket_id, para_birimi, kur) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                foreach ($urun_detaylari as $detay) {
                    $stmt_detay->execute([
                        $teklif_id, 
                        $detay['urun_id'], 
                        $detay['miktar'], 
                        $detay['birim_fiyat'], 
                        $detay['kdv_orani'], 
                        $detay['kdv_tutari'], 
                        $detay['toplam_tutar'], 
                        $_SESSION['aktif_sirket_id'],
                        $teklif_para_birimi,
                        $detay['kur'] ?? 1.0
                    ]);
                }

                $db->commit();

                // LOGLAMA İŞLEMİ EKLENDİ
                $stmt_cari_ad = $db->prepare("SELECT ad_soyad FROM cariler WHERE id = ? AND sirket_id = ?");
                $stmt_cari_ad->execute([$cari_id, $_SESSION['aktif_sirket_id']]);
                $cari_adi = $stmt_cari_ad->fetchColumn();
                $genel_toplam = $toplam_tutar + $toplam_kdv - $indirim_tutari;
                $log_mesaji = sprintf(__('user_created_quote_log'), $teklif_id, $cari_adi, number_format($genel_toplam, 2) . ' ' . getParaBirimiSembolu($teklif_para_birimi));
                sistem_log_ekle($db, 'ekle', 'teklifler', $teklif_id, $_SESSION['aktif_sirket_id'], ['teklif_verileri' => $_POST], $log_mesaji);

                $_SESSION['mesaj'] = sprintf(__('quote_created_success'), $teklif_id);
                header("Location: teklifler.php");
                exit();
            } catch (Exception $e) {
                $db->rollBack();
                $_SESSION['hata'] = __("error_creating_quote") . ': ' . $e->getMessage();
            }
        } else {
            $_SESSION['form_hatalari'] = $hatalar;
            $_SESSION['form_verileri'] = $_POST;
        }
    }
    header("Location: teklifler.php");
    exit();
}

// Cariler ve tedarikçiler sorgularını güncelle

$stmt_cariler = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE sirket_id = ? ORDER BY ad_soyad");
$stmt_cariler->execute([$aktif_sirket_id]);
$cariler = $stmt_cariler->fetchAll(PDO::FETCH_ASSOC);

$stmt_tedarikciler = $db->prepare("
    SELECT DISTINCT c.id, c.ad_soyad 
    FROM cariler c 
    JOIN urunler u ON c.id = u.tedarikci_id AND u.sirket_id = c.sirket_id
    WHERE u.tedarikci_id IS NOT NULL AND c.sirket_id = ? 
    ORDER BY c.ad_soyad
");
$stmt_tedarikciler->execute([$aktif_sirket_id]);
$tedarikciler = $stmt_tedarikciler->fetchAll(PDO::FETCH_ASSOC);

$stmt_cari_gruplari = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ? ORDER BY grup_adi");
$stmt_cari_gruplari->execute([$aktif_sirket_id]);
$cari_gruplari = $stmt_cari_gruplari->fetchAll(PDO::FETCH_ASSOC);

$csrf_token = csrf_token_olustur();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?> - <?= __("app_name") ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .hidden { display: none !important; }
        .toplam-alan { background: #fff3cd; border: 1px solid #ffeeba; border-radius: 0.375rem; }
        .is-invalid { border-color: #dc3545 !important; }
        
        /* Cari arama sonuçları için güzel görünüm */
        #cariSonuclar {
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            z-index: 1050;
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 0.375rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
            max-height: 250px;
            overflow-y: auto;
        }
        
        .autocomplete-suggestion {
            display: block;
            padding: 0.75rem 1rem;
            text-decoration: none;
            color: #212529;
            border-bottom: 1px solid #f8f9fa;
            transition: all 0.2s ease-in-out;
            cursor: pointer;
        }
        
        .autocomplete-suggestion:last-child {
            border-bottom: none;
        }
        
        .autocomplete-suggestion:hover {
            background-color: #e9ecef;
            color: #0d6efd;
            text-decoration: none;
        }
        
        .autocomplete-suggestion:focus {
            background-color: #0d6efd;
            color: white;
            outline: none;
        }
        
        .autocomplete-suggestion.text-muted {
            font-style: italic;
            color: #6c757d !important;
            cursor: default;
        }
        
        .autocomplete-suggestion.text-muted:hover {
            background-color: transparent;
            color: #6c757d !important;
        }
        
        /* Cari arama input container için relative position */
        .position-relative {
            position: relative;
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center">
            <h2><i class="bi bi-file-earmark-text-fill"></i> <?= temizle($sayfa_baslik) ?></h2>
            <a href="teklifler.php" class="btn btn-secondary"><i class="bi bi-list-ul"></i> <?= __("quote_list") ?></a>
        </div>
        <hr>

        <form method="post" id="teklifForm">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            <input type="hidden" id="coklu_para_birimi_aktif" value="<?= $coklu_para_birimi_aktif ? '1' : '0' ?>">
            
            <div class="card shadow-sm mb-4">
                <div class="card-header"><?= __("quote_information") ?></div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="cari_arama" class="form-label"><?= __("customer") ?> <span class="text-danger">*</span></label>
                            <div class="input-group position-relative">
                                <input type="text" class="form-control" id="cari_arama" placeholder="<?= __("search_customer") ?>..." autocomplete="off">
                                <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#yeniCariModal"><i class="bi bi-plus-circle"></i></button>
                                <div id="cariSonuclar" style="display: none;"></div>
                            </div>
                            <input type="hidden" id="cari_id" name="cari_id" required>
                            <div id="seciliCari" class="form-text mt-2"><span class="text-muted"><?= __("no_customer_selected") ?></span></div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="teklif_tarihi" class="form-label"><?= __("quote_date") ?> <span class="text-danger">*</span></label>
                            <input type="date" class="form-control" id="teklif_tarihi" name="teklif_tarihi" value="<?= date('Y-m-d') ?>" required>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="gecerlilik_tarihi" class="form-label"><?= __("valid_until") ?></label>
                            <input type="date" class="form-control" id="gecerlilik_tarihi" name="gecerlilik_tarihi">
                        </div>
                        <div class="col-12">
                            <label for="aciklama" class="form-label"><?= __("description") ?></label>
                            <textarea class="form-control" id="aciklama" name="aciklama" rows="2"></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><?= __("products") ?></span>
                    <div class="d-flex align-items-center gap-2">
                        <?php if ($coklu_para_birimi_aktif): ?>
                            <div class="d-flex align-items-center">
                                <label for="teklif_para_birimi" class="me-2 mb-0 small text-muted"><?= __("invoice_currency") ?></label>
                                <select class="form-select form-select-sm w-auto" id="teklif_para_birimi" name="teklif_para_birimi" onchange="handleTeklifParaBirimiChange.call(this)">
                                    <option value="TL" <?= ($sirket_para_birimi == 'TL') ? 'selected' : '' ?>>TL</option>
                                    <?php $___seen_pb = []; foreach ($doviz_kurlari as $kur): $pb = $kur['para_birimi']; if (in_array($pb, $___seen_pb)) continue; $___seen_pb[] = $pb; ?>
                                        <option value="<?= $pb ?>" <?= ($sirket_para_birimi == $pb) ? 'selected' : '' ?>><?= $pb ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        <?php endif; ?>
                        <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#urunSecModal"><i class="bi bi-plus-circle"></i> <?= __("add_product") ?></button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th style="width: 5%;">#</th>
                                    <th style="width: 20%;"><?= __("product_name") ?></th>
                                    <th style="width: 12%;"><?= __("quantity") ?></th>
                                    <th style="width: 12%;"><?= __("unit_price") ?></th>
                                    <?php if ($coklu_para_birimi_aktif): ?>
                                    <th style="width: 10%;"><?= __("product_currency") ?></th>
                                    <th style="width: 10%;"><?= __("exchange_rate") ?></th>
                                    <?php endif; ?>
                                    <th style="width: 10%;"><?= __("vat") ?> (%)</th>
                                    <th style="width: 12%;" class="text-end"><?= __("vat_amount") ?></th>
                                    <th style="width: 15%;" class="text-end"><?= __("total") ?></th>
                                    <th style="width: 4%;"></th>
                                </tr>
                            </thead>
                            <tbody id="urunListesi">
                                <!-- Ürünler buraya eklenecek -->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-12 mb-2">
                            <div class="p-2 bg-white rounded">
                                <i class="bi bi-box-seam me-2"></i>
                                <strong id="toplamUrunAdedi">0 adet ürün eklendi</strong>
                            </div>
                        </div>
                        <div class="col-md-5 ms-auto">
                            <ul class="list-group">
                                <li class="list-group-item d-flex justify-content-between align-items-center"><?= __("subtotal") ?>: <span id="araToplam">0,00 <?= $paraBirimi ?></span></li>
                                <li class="list-group-item d-flex justify-content-between align-items-center"><?= __("total_vat") ?>: <span id="toplamKdv">0,00 <?= $paraBirimi ?></span></li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <span><?= __("discount") ?> (<?= $paraBirimi ?>):</span>
                                    <input type="text" class="form-control form-control-sm text-end" style="width: 100px;" id="indirim_tutari" name="indirim_tutari" value="0,00" oninput="genelToplamGuncelle()">
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center fw-bold bg-light">
                                    <span><?= __("grand_total") ?>:</span>
                                    <span id="genelToplam">0,00 <?= $paraBirimi ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="text-center">
                <button type="submit" class="btn btn-success btn-lg"><i class="bi bi-save"></i> <?= __("save_quote") ?></button>
            </div>
        </form>
    </div>

    <!-- Ürün Seçim Modalı -->
    <div class="modal fade" id="urunSecModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?= __("select_product") ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-8"><input type="text" class="form-control" id="urunArama" placeholder="<?= __("search_product") ?>"></div>
                        <div class="col-md-4">
                            <select class="form-select" id="tedarikciFiltre">
                                <option value=""><?= __("all_suppliers") ?></option>
                                <?php foreach ($tedarikciler as $tedarikci): ?>
                                    <option value="<?= $tedarikci['id'] ?>"><?= temizle($tedarikci['ad_soyad']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div id="urunSonuclari" style="max-height: 300px; overflow-y: auto;"></div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Yeni Cari Modalı -->
    <?php include __DIR__ . '/../includes/cari_ekle_modal.php'; ?>
    
    <script src="<?= BASE_URL ?>/assets/js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/fatura.js"></script>
    <script src="js/stokarama.js"></script>
    <script src="js/cariarama.js"></script>
    <script>
    const cokluParaBirimiAktif = <?= $coklu_para_birimi_aktif ? 'true' : 'false' ?>;
    const paraBirimi = '<?= getParaBirimiSembolu($sirket_para_birimi === 'TL' ? 'TRY' : $sirket_para_birimi) ?>';
    
    // Alış/Satış sayfalarındakiyle aynı mantık: DB'den gelen kurlarla çapraz kur hesaplayıcı
    (function(){
        <?php $dk = $doviz_kurlari ?? []; ?>
        const dovizKurlari = <?= json_encode($dk, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES) ?>;
        function findPB(kod){
            if (!kod) return null;
            return dovizKurlari.find(k => k.para_birimi === kod.toUpperCase()) || null;
        }
        // Üstteki kutuyu DB'den gelen kurlarla doldur
        try {
            const listEl = document.getElementById('dovizKurlariList');
            const loadingEl = document.getElementById('dovizKurlariLoading');
            const tarihEl = document.getElementById('dovizKurlariTarih');
            if (listEl && loadingEl) {
                loadingEl.style.display = 'none';
                listEl.style.display = 'flex';
                listEl.innerHTML = (dovizKurlari||[]).map(k => {
                    const val = (parseFloat(k.satis)||1).toFixed(4);
                    return `<span class="badge bg-light text-dark border">${k.para_birimi}: ${val}</span>`;
                }).join('');
                if (tarihEl && (dovizKurlari||[]).length && dovizKurlari[0].guncelleme_tarihi) {
                    tarihEl.textContent = 'Güncelleme: ' + dovizKurlari[0].guncelleme_tarihi;
                }
            }
        } catch(e) { /* no-op */ }
        // fromPB -> toPB kur oranı
        window.fetchKur = async function(fromPB, toPB){
            const from = (fromPB === 'TL') ? 'TRY' : (fromPB||'').toUpperCase();
            const to = (toPB === 'TL') ? 'TRY' : (toPB||'').toUpperCase();
            if (!from || !to || from === to) return 1.0;
            const fromRec = (from === 'TRY') ? null : findPB(from);
            const toRec = (to === 'TRY') ? null : findPB(to);
            if (from === 'TRY' && toRec) { const v = 1.0 / parseFloat(toRec.satis||'1'); return isNaN(v)?1.0:v; }
            if (to === 'TRY' && fromRec) { const v = parseFloat(fromRec.satis||'1'); return isNaN(v)?1.0:v; }
            if (fromRec && toRec) { const v = parseFloat(fromRec.satis||'1')/parseFloat(toRec.satis||'1'); return isNaN(v)?1.0:v; }
            return 1.0;
        };
    })();
    
    // Teklif para birimi değiştiğinde çalışacak fonksiyon
    window.handleTeklifParaBirimiChange = function() {
        const teklifParaBirimi = document.getElementById('teklif_para_birimi')?.value || 'TL';
        
        // Tüm ürün satırlarında kur değerlerini güncelle
        document.querySelectorAll('#urunListesi tr').forEach(row => {
            const kurInput = row.querySelector('.kur');
            const urunParaBirimiInput = row.querySelector('input[name^="satis_para_birimi"]');
            
            if (kurInput && urunParaBirimiInput) {
                const urunParaBirimi = urunParaBirimiInput.value || 'TL';
                
                if (urunParaBirimi === teklifParaBirimi) {
                    kurInput.value = '1.0000';
                } else {
                    // DB kurlarına göre çapraz kur
                    (async () => {
                        const kurOrani = await window.fetchKur(urunParaBirimi, teklifParaBirimi);
                        if (kurOrani) {
                            kurInput.value = parseFloat(kurOrani).toFixed(4);
                        }
                    })();
                }
            }
        });
        
        // Para birimi değişikliği sonrası toplamları güncelle
        setTimeout(() => {
            genelToplamGuncelle();
        }, 200);
    };

    // Kur güncelleme fonksiyonu
    window.kurGuncelleTeklif = function(selectElement) {
        if (!cokluParaBirimiAktif) return;
        
        const row = selectElement.closest('tr');
        const kurInput = row.querySelector('.kur'); // class selector kullan
        const urunParaBirimi = selectElement.value;
        const teklifParaBirimi = document.getElementById('teklif_para_birimi')?.value || 'TL';
        
        if (urunParaBirimi === teklifParaBirimi) {
            kurInput.value = '1.0000'; // İngilizce format - nokta ondalık ayırıcı
        } else {
            (async () => {
                const kurOrani = await window.fetchKur(urunParaBirimi, teklifParaBirimi);
                if (kurOrani) {
                    kurInput.value = parseFloat(kurOrani).toFixed(4); // İngilizce format - nokta ondalık ayırıcı
                    genelToplamGuncelle();
                }
            })();
        }
    };

    // Ürün adedini güncelleme fonksiyonu
    function urunAdediGuncelle() {
        const urunSatirlari = document.querySelectorAll('#urunListesi .urun-satiri');
        let toplamUrun = 0;
        
        // Sıra numaralarını güncelle
        urunSatirlari.forEach((satir, index) => {
            const siraNoHucresi = satir.querySelector('.sira-no');
            if (siraNoHucresi) {
                siraNoHucresi.textContent = (index + 1);
            }
            
            // Toplam ürün miktarını hesapla
            const miktarInput = satir.querySelector('.miktar');
            if (miktarInput) {
                const miktar = parseFloat(miktarInput.value.replace(',', '.')) || 0;
                toplamUrun += miktar;
            }
        });
        
        // Toplam ürün adedini güncelle
        const toplamUrunElement = document.getElementById('toplamUrunAdedi');
        if (toplamUrunElement) {
            const formattedTotal = toplamUrun % 1 === 0 ? toplamUrun.toFixed(0) : toplamUrun.toFixed(2);
            toplamUrunElement.textContent = `${formattedTotal} adet ürün eklendi`;
        }
    }

    // Genel toplam güncelleme fonksiyonu
    window.genelToplamGuncelle = function() {
        let araToplam = 0;
        let toplamKdv = 0;
        
        // Ürün adedini güncelle
        urunAdediGuncelle();
        
        document.querySelectorAll('#urunListesi .urun-satiri').forEach(row => {
            const miktarInput = row.querySelector('.miktar');
            const fiyatInput = row.querySelector('.fiyat');
            const kdvInput = row.querySelector('.kdv');
            const kurInput = row.querySelector('.kur');
            
            if (miktarInput && fiyatInput && kdvInput) {
                const miktar = parseFloatOrZero(miktarInput.value);
                const birimFiyat = parseFloatOrZero(fiyatInput.value);
                const kdvOrani = parseFloatOrZero(kdvInput.value);
                const kur = kurInput ? parseKurValue(kurInput.value) : 1;
                
                // Orijinal para birimindeki hesaplama
                const satirToplam_orj = miktar * birimFiyat;
                const kdvTutari_orj = (satirToplam_orj * kdvOrani) / 100;
                
                // Teklif para birimine çevrilmiş hesaplama
                const satirToplam_teklif = satirToplam_orj * kur;
                const kdvTutari_teklif = kdvTutari_orj * kur;
                
                // Satır toplamlarını güncelle
                const kdvTutariElement = row.querySelector('.kdv-tutari');
                const satirToplamElement = row.querySelector('.satir-toplam');
                
                if (kdvTutariElement) {
                    kdvTutariElement.textContent = formatCurrency(kdvTutari_teklif) + ' ' + getCurrentParaBirimi();
                }
                if (satirToplamElement) {
                    satirToplamElement.textContent = formatCurrency(satirToplam_teklif) + ' ' + getCurrentParaBirimi();
                }
                
                araToplam += satirToplam_teklif;
                toplamKdv += kdvTutari_teklif;
            }
        });

        const indirim = parseFloatOrZero(document.getElementById('indirim_tutari')?.value || '0');
        const genelToplam = araToplam + toplamKdv - indirim;
        
        const currentParaBirimi = getCurrentParaBirimi();
        document.getElementById('araToplam').textContent = formatCurrency(araToplam) + ' ' + currentParaBirimi;
        document.getElementById('toplamKdv').textContent = formatCurrency(toplamKdv) + ' ' + currentParaBirimi;
        document.getElementById('genelToplam').textContent = formatCurrency(genelToplam) + ' ' + currentParaBirimi;

    };

    // Mevcut para birimini al
    window.getCurrentParaBirimi = function() {
        if (cokluParaBirimiAktif) {
            const teklifParaBirimi = document.getElementById('teklif_para_birimi')?.value || 'TL';
            // Para birimi kodunu döndür, sembol değil
            return teklifParaBirimi;
        }
        return paraBirimi;
    };

    // Helper functions
    window.formatCurrency = function(value) {
        return new Intl.NumberFormat('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 }).format(value);
    };

    window.parseFloatOrZero = function(value) {
        if (typeof value !== 'string') {
            const parsed = parseFloat(value);
            return isNaN(parsed) ? 0 : parsed;
        }
        // Türkçe format: virgül ondalık ayırıcı, nokta binlik ayırıcı
        // Örnek: "1.234,56" -> 1234.56
        const cleanedValue = value.replace(/\./g, '').replace(',', '.');
        const parsed = parseFloat(cleanedValue);
        return isNaN(parsed) ? 0 : parsed;
    };

    // Kur değerleri için özel parsing (İngilizce format - nokta ondalık ayırıcı)
    window.parseKurValue = function(value) {
        if (typeof value !== 'string') {
            const parsed = parseFloat(value);
            return isNaN(parsed) ? 0 : parsed;
        }
        // Kur değerleri İngilizce format: nokta ondalık ayırıcı
        // Örnek: "54.6926" -> 54.6926
        const parsed = parseFloat(value);
        return isNaN(parsed) ? 0 : parsed;
    };

    // AJAX ile cari ekleme işlemi
    $(function(){
        $('#cariEkleBtn').off('click').on('click', function() {
            var form = $('#yeniCariForm');
            var btn = $(this);
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> Kaydediliyor...');
            $.ajax({
                url: '<?= BASE_URL ?>/ajax/cari_ekle_ajax.php',
                method: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(data) {
                    if(data.success) {
                        $('#cariEkleMessage').removeClass('d-none alert-danger').addClass('alert-success').text(data.message);
                        setTimeout(function(){
                            $('#yeniCariModal').modal('hide');
                            form[0].reset();
                            $('#cariEkleMessage').addClass('d-none');
                            // Sayfada cari arama varsa otomatik ekle
                             if ($('#cari_arama').length) {
                                $('#cari_id').val(data.id);
                                $('#seciliCari').html(`<div class="alert alert-success p-2">Seçilen: <strong>${data.ad_soyad}</strong></div>`);
                                $('#cariSonuclar').hide();
                            }
                        }, 1000);
                    } else {
                        $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text(data.message);
                    }
                },
                error: function() {
                    $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text('Cari eklenirken bir hata oluştu.');
                },
                complete: function() {
                    btn.prop('disabled', false).html('Cari Ekle');
                }
            });
        });
        
        // İndirim tutarı değiştiğinde hesapla
        $('#indirim_tutari').on('input', genelToplamGuncelle);
    });
    </script>
    
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>
