<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

$teklif_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null;

if (!$teklif_id) {
    $_SESSION['hata'] = "Geçersiz teklif ID'si.";
    header('Location: teklifler.php');
    exit();
}

if (!$aktif_sirket_id) {
    $_SESSION['hata'] = "Şirket seçimi gerekli.";
    header('Location: teklifler.php');
    exit();
}

try {
    $db->beginTransaction();

    // 1. Teklif bilgilerini çek
    $stmt_teklif = $db->prepare("SELECT * FROM teklifler WHERE id = ? AND durum != 'Faturalastirildi'");
    $stmt_teklif->execute([$teklif_id]);
    $teklif = $stmt_teklif->fetch(PDO::FETCH_ASSOC);

    if (!$teklif) {
        throw new Exception("Teklif bulunamadı veya zaten faturalaştırılmış.");
    }

    // 2. Teklif detaylarını çek
    $stmt_detaylar = $db->prepare("SELECT * FROM teklif_detaylari WHERE teklif_id = ?");
    $stmt_detaylar->execute([$teklif_id]);
    $detaylar = $stmt_detaylar->fetchAll(PDO::FETCH_ASSOC);

    // 3. Yeni bir satış faturası (borç) oluştur
    $toplam_fatura_tutari = $teklif['tutar'] + $teklif['toplam_kdv'] - $teklif['indirim_tutari'];
    
    $stmt_borc = $db->prepare("INSERT INTO borclar (sirket_id, cari_id, tur, tutar, toplam_kdv, indirim_tutari, aciklama, tarih, stoklu_islem) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 1)");
    $stmt_borc->execute([$aktif_sirket_id, $teklif['cari_id'], 'satis', $teklif['tutar'], $teklif['toplam_kdv'], $teklif['indirim_tutari'], "Teklif #{$teklif_id} den dönüştürüldü. " . $teklif['aciklama'], date('Y-m-d')]);
    $borc_id = $db->lastInsertId();

    // 4. Fatura detaylarını ve stokları güncelle
    $stmt_fatura_detay = $db->prepare("INSERT INTO fatura_detaylari (borc_id, urun_id, miktar, birim_fiyat, kdv_orani, kdv_tutari, toplam_tutar, sirket_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    foreach ($detaylar as $detay) {
        $stmt_fatura_detay->execute([$borc_id, $detay['urun_id'], $detay['miktar'], $detay['birim_fiyat'], $detay['kdv_orani'], $detay['kdv_tutari'], $detay['toplam_tutar'], $aktif_sirket_id]);
        
        // HATA DÜZELTMESİ: Fonksiyona göndermeden önce birim fiyatı float tipine dönüştür.
        $birim_fiyat_float = (float)$detay['birim_fiyat'];
        // HATA DÜZELTMESİ: Fonksiyona göndermeden önce birim fiyatı float tipine dönüştür.
	$birim_fiyat_float = (float)$detay['birim_fiyat'];
	// 'satis' parametresi kaldırıldı ve doğru değişken gönderildi.
	stokGuncelle($db, $detay['urun_id'], -$detay['miktar'], $birim_fiyat_float);
    }
    
    // 5. Cari bakiyesini güncelle
    cariBakiyeGuncelle($db, $teklif['cari_id'], $toplam_fatura_tutari, 0);

    // 6. Teklifin durumunu güncelle
    $stmt_update_teklif = $db->prepare("UPDATE teklifler SET durum = 'Faturalastirildi' WHERE id = ?");
    $stmt_update_teklif->execute([$teklif_id]);

    $db->commit();

    // LOGLAMA İŞLEMİ
    $log_mesaji = "kullanıcısı, Teklif #{$teklif_id}'i, Fatura #{$borc_id} olarak dönüştürdü.";
    sistem_log_ekle($db, 'donusturme', 'teklifler', $teklif_id, ['durum' => $teklif['durum']], ['durum' => 'Faturalastirildi'], $log_mesaji);

    $_SESSION['mesaj'] = "Teklif #{$teklif_id}, Fatura #{$borc_id} olarak başarıyla dönüştürüldü.";

} catch (Exception $e) {
    $db->rollBack();
    $_SESSION['hata'] = "Dönüştürme sırasında hata: " . $e->getMessage();
}

header('Location: teklifler.php');
exit();
