<?php
// Gerekli dosyaları ve fonksiyonları dahil et
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';

// Yetki kontrolü (Gerekli yetki seviyelerini kendi sisteminize göre ayarlayın)
yetkili_mi('kullanici');

// Filtreleme için ürün ID'sini al
$urun_id_filter = isset($_GET['urun_id']) ? (int)$_GET['urun_id'] : null;
$params = [];
$sayfa_baslik = __("stock_movements"); // Varsayılan başlık

// SQL sorgusu, hem filtreleme yapacak hem de tasarım için gerekli tüm verileri çekecek şekilde güncellendi.
$sql = "SELECT
            sh.*,
            u.urun_adi,
            u.barkod,
            c.ad_soyad as cari_adi,
            b.tur as fatura_tipi
        FROM
            stok_hareketleri sh
        LEFT JOIN
            urunler u ON sh.urun_id = u.id AND u.sirket_id = ?
        LEFT JOIN
            cariler c ON sh.cari_id = c.id AND c.sirket_id = ?
        LEFT JOIN
            borclar b ON sh.borc_id = b.id AND b.sirket_id = ?
        WHERE sh.sirket_id = ?";

// Aktif şirket ID'sini al
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$params = [$aktif_sirket_id, $aktif_sirket_id, $aktif_sirket_id, $aktif_sirket_id];

// Eğer urun_id filtresi varsa, sorguyu ve parametreleri güncelle
if ($urun_id_filter) {
    $sql .= " AND sh.urun_id = ?";
    $params[] = $urun_id_filter;

    // Ürün adını başlıkta göstermek için veritabanından çek
    try {
        $stmt_urun = $db->prepare("SELECT urun_adi FROM urunler WHERE id = ? AND sirket_id = ?");
        $stmt_urun->execute([$urun_id_filter, $aktif_sirket_id]);
        $urun = $stmt_urun->fetch(PDO::FETCH_ASSOC);
        if ($urun) {
            // Sayfa başlığını filtrelenen ürün adıyla güncelle
            $sayfa_baslik = __("stock_movements") . ": " . temizle($urun['urun_adi']);
        }
    } catch (PDOException $e) {
        // Hata olursa logla, ama programı durdurma
        error_log("Ürün adı çekilirken hata: " . $e->getMessage());
    }
}

$sql .= " ORDER BY sh.tarih DESC, sh.id DESC";

// Stok hareketlerini veritabanından çek
try {
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $stok_hareketleri = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log("Stok hareketleri çekilirken hata: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_stock_movements");
    $stok_hareketleri = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        .table-responsive-custom {
            overflow-x: auto;
        }
        @media (max-width: 768px) {
            .table-responsive-custom table {
                width: 100%;
                min-width: 700px; /* Minimum genişlik */
            }
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <h2><i class="bi bi-arrow-left-right"></i> <?= temizle($sayfa_baslik) ?></h2>
        <hr>

        <?php if (isset($_SESSION['mesaj'])): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?= $_SESSION['mesaj'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['mesaj']); ?>
        <?php endif; ?>

        <?php if (isset($_SESSION['hata'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?= $_SESSION['hata'] ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            <?php unset($_SESSION['hata']); ?>
        <?php endif; ?>

        <div class="table-responsive table-responsive-custom">
            <table class="table table-hover table-striped align-middle">
                <thead class="table-light">
                    <tr>
                        <th><?= __("date") ?></th>
                        <th><?= __("product_name_detail") ?></th>
                        <th><?= __("transaction_type") ?></th>
                        <th><?= __("quantity") ?></th>
                        <th><?= __("unit_price") ?></th>
                        <th><?= __("total_amount") ?></th>
                        <th><?= __("current") ?></th>
                        <th><?= __("description") ?></th>
                        <th><?= __("info") ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($stok_hareketleri)): ?>
                        <tr>
                            <td colspan="9" class="text-center"><?= __("no_stock_movements_yet") ?></td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($stok_hareketleri as $hareket): ?>
                            <tr class="<?= ($hareket['hareket_turu'] == 'giris') ? 'table-success' : 'table-danger' ?>">
                                <td><?= htmlspecialchars(date('d.m.Y H:i', strtotime($hareket['tarih']))) ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <span class="me-2"><?= temizle($hareket['urun_adi']) ?></span>
                                        <a href="stok_detay.php?id=<?= $hareket['urun_id'] ?>" 
                                           class="btn btn-sm btn-outline-success" 
                                           title="<?= __("stock_detail_analysis") ?>">
                                            <i class="bi bi-graph-up"></i>
                                        </a>
                                    </div>
                                </td>
                                <td>
                                    <?php if ($hareket['hareket_turu'] == 'giris'): ?>
                                        <span class="badge bg-success"><i class="bi bi-arrow-down-left"></i> <?= __("entry") ?></span>
                                    <?php else: ?>
                                        <span class="badge bg-danger"><i class="bi bi-arrow-up-right"></i> <?= __("exit") ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?= number_format($hareket['miktar'], 2) ?></td>
                                <td><?= number_format($hareket['birim_fiyat'], 2) . ' ' . getParaBirimiSembolu() ?></td>
                                <td><?= number_format($hareket['toplam_tutar'], 2) . ' ' . getParaBirimiSembolu() ?></td>
                                <td><?= temizle($hareket['cari_adi']) ?></td>
                                <td><?= temizle($hareket['aciklama']) ?></td>
								<td>
                                        <?php
                                        // Açıklama alanı korundu
                                        echo temizle($hareket['aciklama']);
                                        // Fatura linki, açıklamanın yanına eklendi
                                        if ($hareket['borc_id'] && isset($hareket['fatura_tipi'])) {
                                            $fatura_link = 'fatura_goruntule.php?id=' . ($hareket['fatura_tipi'] == 'alis' ? 'alis_detay' : 'satis_detay') . '&id=' . $hareket['borc_id'];
                                            echo ' <a href="' . $fatura_link . '" class="badge badge-info text-dark text-decoration-none" title="' . __("view_related_invoice") . '">' . __("invoice") . ' #' . $hareket['borc_id'] . '</a>';
                                        }
                                        ?>
                                    </td>
									
								
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html>


