<?php
// Gerekli dosyaları ve ayarları dahil et
require_once __DIR__ . '/../includes/config.php'; 
// Kullanıcının yetkili olup olmadığını kontrol et (Bu fonksiyonun tanımlı olduğunu varsayıyoruz)
yetkili_mi(); 

// Sayfa başlığını ayarla
$sayfa_baslik = __("profile_management");
// Mesaj ve hata değişkenlerini başlangıçta boş olarak ayarla
$mesaj = '';
$hata = '';
// Kullanıcı bilgilerini tutacak dizi
$kullanici = [];

// Oturumda mesaj varsa al ve temizle
if(isset($_SESSION['mesaj'])) {
    $mesaj = $_SESSION['mesaj'];
    unset($_SESSION['mesaj']);
}

// Veritabanından mevcut kullanıcı bilgilerini çek
try {
    // Oturumdaki kullanıcı ID'sine göre kullanıcıyı seçmek için sorgu hazırla
    $stmt = $db->prepare("SELECT id, ad_soyad, kullanici_adi, sifre FROM kullanicilar WHERE id = ?");
    // Sorguyu oturumdaki kullanıcı ID'si ile çalıştır
    $stmt->execute([$_SESSION['kullanici_id']]);
    // Sonucu ilişkisel dizi olarak al
    $kullanici = $stmt->fetch(PDO::FETCH_ASSOC);

    // Kullanıcı bulunamazsa hata ver (Normalde yetkili_mi kontrolü bunu engellemeli)
    if (!$kullanici) {
        die("Kullanıcı bulunamadı!");
    }
} catch(PDOException $e) {
    // Veritabanı hatası olursa işlemi durdur ve hata mesajını göster
    die("Veritabanı hatası: " . $e->getMessage());
}

// --- Form İşlemleri ---

// Eğer istek POST metodu ile geldiyse ve 'bilgi_guncelle' butonu tıklandıysa
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['bilgi_guncelle'])) {
    // CSRF token kontrolü yap
    if(!csrf_token_dogrula($_POST['csrf_token'])) {
        die("Geçersiz CSRF token!");
    }
    
    // Formdan gelen ad_soyad ve kullanici_adi değerlerini temizle (temizle fonksiyonu varsayılıyor)
    $ad_soyad = temizle($_POST['ad_soyad']);
    $kullanici_adi = temizle($_POST['kullanici_adi']);
    
    // Ad Soyad ve Kullanıcı Adı boş olamaz kontrolü
    if (empty($ad_soyad) || empty($kullanici_adi)) {
        $hata = __("name_username_required");
    } else {
        // Bilgileri güncellemek için veritabanı işlemi
        try {
            // Kullanıcı bilgilerini güncellemek için sorgu hazırla
            $stmt = $db->prepare("UPDATE kullanicilar SET ad_soyad = ?, kullanici_adi = ? WHERE id = ?");
            // Sorguyu yeni bilgiler ve kullanıcı ID'si ile çalıştır
            $stmt->execute([$ad_soyad, $kullanici_adi, $_SESSION['kullanici_id']]);
            
            // Başarı mesajını oturuma kaydet ve sayfayı yeniden yükle
            $_SESSION['mesaj'] = __("information_updated");
            header("Location: profil.php");
            exit();
        } catch(PDOException $e) {
            // Güncelleme sırasında hata olursa hata mesajını ayarla
            // Kullanıcı adının benzersiz olması gibi durumlar için özel hata kontrolü eklenebilir (örn: $e->getCode() == 23000)
            if ($e->getCode() == 23000) { // Benzersizlik kısıtlaması hatası (örnek)
                 $hata = __("username_already_exists");
            } else {
                 $hata = __("update_error", ['error' => $e->getMessage()]);
            }
        }
    }
}

// Eğer istek POST metodu ile geldiyse ve 'sifre_guncelle' butonu tıklandıysa
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['sifre_guncelle'])) {
    // CSRF token kontrolü yap
    if(!csrf_token_dogrula($_POST['csrf_token'])) {
        die("Geçersiz CSRF token!");
    }
    
    // Formdan gelen şifreleri al
    $eski_sifre = $_POST['eski_sifre'];
    $yeni_sifre = $_POST['yeni_sifre'];
    $yeni_sifre_tekrar = $_POST['yeni_sifre_tekrar'];
    
    // --- Şifre Doğrulamaları ---
    // Eski şifre veritabanındaki hash ile uyuşmuyor mu kontrol et
    if (!password_verify($eski_sifre, $kullanici['sifre'])) {
        $hata = __("old_password_incorrect");
    // Yeni şifreler birbiriyle uyuşmuyor mu kontrol et
    } elseif ($yeni_sifre !== $yeni_sifre_tekrar) {
        $hata = __("passwords_not_match");
    // Yeni şifre yeterince uzun mu kontrol et (örneğin en az 6 karakter)
    } elseif (strlen($yeni_sifre) < 6) {
        $hata = __("password_too_short");
    // Tüm doğrulamalar başarılıysa şifreyi güncelle
    } else {
        try {
            // Yeni şifreyi güvenli bir şekilde hash'le
            $yeni_sifre_hash = password_hash($yeni_sifre, PASSWORD_DEFAULT);
            // Şifreyi güncellemek için sorgu hazırla
            $stmt = $db->prepare("UPDATE kullanicilar SET sifre = ? WHERE id = ?");
            // Sorguyu yeni hash ve kullanıcı ID'si ile çalıştır
            $stmt->execute([$yeni_sifre_hash, $_SESSION['kullanici_id']]);
            
            // Başarı mesajını oturuma kaydet ve sayfayı yeniden yükle
            $_SESSION['mesaj'] = __("password_changed");
            header("Location: profil.php");
            exit();
        } catch(PDOException $e) {
            // Şifre güncelleme sırasında hata olursa hata mesajını ayarla
            $hata = __("password_update_error", ['error' => $e->getMessage()]);
        }
    }
}

// Eğer istek POST metodu ile geldiyse ve 'dil_guncelle' butonu tıklandıysa
if($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['dil_guncelle'])) {
    // CSRF token kontrolü yap
    if(!csrf_token_dogrula($_POST['csrf_token'])) {
        die("Geçersiz CSRF token!");
    }
    
    // Formdan gelen dili al
    $yeni_dil = $_POST['dil'];
    
    // Dili güncelle
    if (setUserLanguage($yeni_dil)) {
        $_SESSION['mesaj'] = __("language_updated");
        header("Location: profil.php");
        exit();
    } else {
        $hata = "Dil güncelleme sırasında bir hata oluştu!";
    }
}

// Yeni bir CSRF token oluştur
$csrf_token = csrf_token_olustur(); 
?>
<!DOCTYPE html>
<html lang="<?= getCurrentLanguage() ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= htmlspecialchars($sayfa_baslik) // XSS önlemi ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            background-color: #f8f9fa; /* Hafif gri arka plan */
        }
        .card {
            border: none; /* Kart kenarlıklarını kaldır */
            border-radius: 0.75rem; /* Daha yuvarlak köşeler */
        }
        .card-header {
            border-top-left-radius: 0.75rem;
            border-top-right-radius: 0.75rem;
            font-weight: 500; /* Başlık fontunu biraz kalınlaştır */
        }
        .btn i {
            margin-right: 0.5rem; /* Buton ikonları ile yazı arasına boşluk */
        }
        /* Başarı ve Hata mesajları için stil */
        .alert {
             border-radius: 0.5rem;
        }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; // Navbar'ı dahil et ?>

    <div class="container py-5">
        <h2 class="text-center mb-4"><?= htmlspecialchars($sayfa_baslik) ?></h2>

        <?php if (!empty($mesaj)): ?>
            <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                <i class="bi bi-check-circle-fill me-2"></i><?= htmlspecialchars($mesaj) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>
        
        <?php if (!empty($hata)): ?>
            <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
                <i class="bi bi-exclamation-triangle-fill me-2"></i><?= htmlspecialchars($hata) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <div class="row justify-content-center g-4"> 
            <div class="col-lg-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0"><i class="bi bi-person-lines-fill"></i> <?= __("general_information") ?></h5>
                    </div>
                    <div class="card-body p-4">
                        <form method="post" action="profil.php">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            
                            <div class="mb-3">
                                <label for="ad_soyad" class="form-label"><?= __("full_name") ?></label>
                                <input type="text" class="form-control" id="ad_soyad" 
                                       name="ad_soyad" 
                                       value="<?= htmlspecialchars($kullanici['ad_soyad'] ?? '') // Değer yoksa boş göster ?>" 
                                       required>
                            </div>

                            <div class="mb-3">
                                <label for="kullanici_adi" class="form-label"><?= __("username") ?></label>
                                <input type="text" class="form-control" id="kullanici_adi" 
                                       name="kullanici_adi" 
                                       value="<?= htmlspecialchars($kullanici['kullanici_adi'] ?? '') ?>" 
                                       required>
                            </div>

                            <div class="d-grid">
                                <button type="submit" name="bilgi_guncelle" class="btn btn-primary btn-lg">
                                    <i class="bi bi-save"></i> <?= __("update_information") ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-warning text-dark">
                         <h5 class="mb-0"><i class="bi bi-shield-lock-fill"></i> <?= __("change_password") ?></h5>
                    </div>
                    <div class="card-body p-4">
                        <form method="post" action="profil.php">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            
                            <div class="mb-3">
                                <label for="eski_sifre" class="form-label"><?= __("old_password") ?></label>
                                <input type="password" class="form-control" id="eski_sifre" 
                                       name="eski_sifre" required>
                            </div>

                            <div class="mb-3">
                                <label for="yeni_sifre" class="form-label"><?= __("new_password") ?></label>
                                <input type="password" class="form-control" id="yeni_sifre" 
                                       name="yeni_sifre" minlength="6" required>
                                <div class="form-text"><?= __("password_min_length") ?></div>
                            </div>

                            <div class="mb-3">
                                <label for="yeni_sifre_tekrar" class="form-label"><?= __("confirm_new_password") ?></label>
                                <input type="password" class="form-control" id="yeni_sifre_tekrar" 
                                       name="yeni_sifre_tekrar" minlength="6" required>
                            </div>

                            <div class="d-grid">
                                <button type="submit" name="sifre_guncelle" class="btn btn-warning btn-lg">
                                    <i class="bi bi-key-fill"></i> <?= __("change_password_button") ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card shadow-sm">
                    <div class="card-header bg-info text-white">
                        <h5 class="mb-0"><i class="bi bi-translate"></i> <?= __("language_settings") ?></h5>
                    </div>
                    <div class="card-body p-4">
                        <form method="post" action="profil.php">
                            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                            
                            <div class="mb-3">
                                <label for="dil" class="form-label"><?= __("select_language") ?></label>
                                <select class="form-select" id="dil" name="dil" required>
                                    <?php 
                                    $current_language = getCurrentLanguage();
                                    $available_languages = getAvailableLanguages();
                                    foreach ($available_languages as $code => $lang): 
                                    ?>
                                    <option value="<?= $code ?>" <?= $current_language === $code ? 'selected' : '' ?>>
                                        <?= $lang['flag'] ?> <?= $lang['name'] ?>
                                    </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="d-grid">
                                <button type="submit" name="dil_guncelle" class="btn btn-info btn-lg">
                                    <i class="bi bi-check-circle"></i> <?= __("language_updated") ?>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div> </div> 
		<?php include __DIR__ . "/../includes/footer.php"; ?>
		<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-C6RzsynM9kWDrMNeT87bh95OGNyZPhcTNXj1NW7RuBCsyN/o0jlpcV8Qyq46cDfL" crossorigin="anonymous"></script>
</body>
</html>
