<?php
require_once '../includes/config.php';
require_once '../includes/guvenlik_kontrol.php'; // Güvenlik kontrolünü dahil et
require_once '../includes/yetki_kontrol.php';    // Yetki kontrolünü dahil et
require_once '../functions/kullanici_fonksiyonlari.php';
require_once '../functions/log_fonksiyonlari.php';

// Sadece POST isteği kabul et
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kullanici_id = filter_input(INPUT_POST, 'kullanici_id', FILTER_SANITIZE_NUMBER_INT);

    if ($kullanici_id) {
        try {
            // Kullanıcı silme yetkisi kontrolü (örneğin, yönetici veya admin yetkisi olmalı)
            // Bu kontrolü yetki_kontrol.php veya burada manuel olarak yapabilirsiniz.
            // Örnek: if (!yetki_kontrol($_SESSION['yetkiler'], 'kullanici_silme_yetkisi')) { ... }
            // veya doğrudan yetki seviyesine göre:
            if (!yetki_seviyesi_kontrol('admin', $_SESSION['yetki_seviyesi'] ?? 'misafir')) {
                throw new Exception("Bu işlemi yapmaya yetkiniz bulunmamaktadır.");
            }

            if (kullanici_sil($db, $kullanici_id)) {
                $_SESSION['success_message'] = "Kullanıcı başarıyla silindi.";
            } else {
                $_SESSION['error_message'] = "Kullanıcı silinirken bir hata oluştu.";
            }
        } catch (Exception $e) {
            $_SESSION['error_message'] = $e->getMessage();
            error_log("Kullanıcı silme işlemi hatası: " . $e->getMessage());
        }
    } else {
        $_SESSION['error_message'] = "Geçersiz kullanıcı ID'si.";
    }
} else {
    $_SESSION['error_message'] = "Geçersiz istek metodu.";
}

// Kullanıcı listesi veya önceki sayfaya yönlendirme
header('Location: ../views/kullanicilar.php');
exit();
?>
