<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/tfpdf/tfpdf.php';

yetkili_mi('kasa');

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$id) {
    die('Geçersiz makbuz ID!');
}

// Şirket bilgilerini çek
$stmt_sirket = $db->prepare("SELECT * FROM sirketler WHERE id = ?");
$stmt_sirket->execute([$_SESSION['aktif_sirket_id']]);
$sirket = $stmt_sirket->fetch(PDO::FETCH_ASSOC);

// Gider kaydını çek
$stmt = $db->prepare("SELECT hh.*, h.hesap_adi FROM hesap_hareketleri hh LEFT JOIN hesaplar h ON h.id = hh.hesap_id WHERE hh.id = ? AND hh.sirket_id = ? AND hh.tur = 'cikis'");
$stmt->execute([$id, $_SESSION['aktif_sirket_id']]);
$gider = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$gider) {
    die('Gider kaydı bulunamadı veya bu kaydı görme yetkiniz yok.');
}

class PDF extends tFPDF
{
    private $sirket_adi;
    private $logo_path;

    public function setSirketAdi($sirket_adi)
    {
        $this->sirket_adi = $sirket_adi;
    }
    
    public function setLogoPath($logo_path)
    {
        $this->logo_path = $logo_path;
    }

    function Header()
    {
        // Add logo if exists
        if (!empty($this->logo_path) && file_exists($this->logo_path)) {
            $this->Image($this->logo_path, 15, 10, 30);
            $this->SetY(15); // Reset Y position after logo
        }
        
        $this->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
        $this->SetFont('DejaVu', '', 16);
        $this->SetTextColor(50, 50, 50);
        
        // Move right if logo exists
        $x = !empty($this->logo_path) ? 50 : 0;
        $this->SetX($x);
        
        $this->Cell(0, 10, temizle($this->sirket_adi), 0, 1, 'C');
        $this->SetFont('DejaVu', '', 10);
        $this->SetTextColor(150, 150, 150);
        $this->SetX($x);
        $this->Cell(0, 7, 'Kasa Gider Makbuzu', 0, 1, 'C');
        $this->Ln(10);
    }

    function Footer()
    {
        $this->SetY(-15);
        $this->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
        $this->SetFont('DejaVu', '', 8);
        $this->SetTextColor(128);
        $this->Cell(0, 10, 'Sayfa ' . $this->PageNo() . ' / {nb}', 0, 0, 'C');
    }
}

// Find company logo
$logo_path = null;
$logo_dir = __DIR__ . '/../uploads/company_logos/';
$logo_pattern = 'logo_' . $_SESSION['aktif_sirket_id'] . '_*';
$logo_files = glob($logo_dir . $logo_pattern . '.{png,jpg,jpeg,svg}', GLOB_BRACE);

if (!empty($logo_files)) {
    // Sort by modification time to get the most recent logo
    usort($logo_files, function($a, $b) {
        return filemtime($b) - filemtime($a);
    });
    $logo_path = $logo_files[0];
}

$pdf = new PDF('P', 'mm', 'A4');
$pdf->setSirketAdi($sirket['sirket_adi'] ?? 'Şirket Adı Belirtilmemiş');

// Set logo path if exists
if ($logo_path && file_exists($logo_path)) {
    $pdf->setLogoPath($logo_path);
}

$pdf->AliasNbPages();
$pdf->AddPage();
$pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
$pdf->AddFont('DejaVu', 'B', 'DejaVuSans-Bold.ttf', true);

// Makbuz Bilgileri
$pdf->SetFont('DejaVu', 'B', 11);
$pdf->SetTextColor(0);
$pdf->Cell(95, 7, 'Makbuz Bilgileri', 0, 0, 'L');
$pdf->Ln(8);

$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(35, 6, 'Makbuz No:', 0, 0, 'L');
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(60, 6, 'GDR-' . str_pad($gider['id'], 6, '0', STR_PAD_LEFT), 0, 1, 'L');

$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(35, 6, 'Tarih:', 0, 0, 'L');
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(60, 6, date('d.m.Y', strtotime($gider['tarih'])), 0, 1, 'L');

$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(35, 6, 'Ödeme Yapılan Kasa:', 0, 0, 'L');
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(60, 6, temizle($gider['hesap_adi']), 0, 1, 'L');

$pdf->Ln(12);

// Gider Detayları
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->SetFillColor(240, 240, 240);
$pdf->SetTextColor(0);
$pdf->Cell(150, 8, 'Açıklama', 1, 0, 'L', true);
$pdf->Cell(40, 8, 'Tutar', 1, 1, 'R', true);

$pdf->SetFont('DejaVu', '', 10);
$pdf->MultiCell(150, 8, temizle($gider['aciklama']), 1, 'L');
$pdf->SetXY(160, $pdf->GetY() - 8);
$pdf->Cell(40, 8, number_format($gider['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($sirket['para_birimi'] ?? null), 1, 1, 'R');

$pdf->Ln(5);

// Toplam
$pdf->SetX(120);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(40, 8, 'Toplam:', 0, 0, 'R');
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->SetFillColor(240, 240, 240);
$pdf->Cell(40, 8, number_format($gider['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($sirket['para_birimi'] ?? null), 1, 1, 'R', true);

$pdf->Ln(15);

// Düzenleyen Bilgisi
$kullanici_adi = $_SESSION['ad_soyad'] ?? 'Bilinmiyor';
$pdf->SetFont('DejaVu', '', 9);
$pdf->SetTextColor(100, 100, 100);
$pdf->Cell(0, 5, 'Bu makbuz ' . temizle($kullanici_adi) . ' tarafından düzenlenmiştir.', 0, 1, 'L');

$pdf->Output('I', 'KasaGiderMakbuzu_GDR-' . str_pad($gider['id'], 6, '0', STR_PAD_LEFT) . '.pdf');exit;
