let urunSayaci = 0;
let urunSecModal, yeniCariModal;
let faturaParaBirimi = (window.initialFaturaParaBirimi || 'TL'); // Global fatura para birimi değişkeni

document.addEventListener('DOMContentLoaded', function() {
    urunSecModal = new bootstrap.Modal(document.getElementById('urunSecModal'));
    yeniCariModal = new bootstrap.Modal(document.getElementById('yeniCariModal'));

    // Yeni cari ekleme
    const cariEkleBtn = document.getElementById('cariEkleBtn');
    if(cariEkleBtn) cariEkleBtn.addEventListener('click', yeniCariEkle);

    // Modal açıldığında focus sorununu düzeltmek için
    const urunSecModalEl = document.getElementById('urunSecModal');
    if(urunSecModalEl) {
        urunSecModalEl.addEventListener('shown.bs.modal', function () {
            document.getElementById('urunArama').focus();
        });
    }

    genelToplamGuncelle(); // Sayfa yüklendiğinde genel toplamı güncelle
});

async function satirGuncelle(element) {
    const satir = element.closest('tr');
    const miktar = parseFloat(satir.querySelector('.miktar').value.replace(',', '.')) || 0;
    const fiyat = parseFloat(satir.querySelector('.fiyat').value.replace(',', '.')) || 0;
    const kdvOrani = parseFloat(satir.querySelector('.kdv').value.replace(',', '.')) || 0;
    
    // Eğer değişiklik kur input'undan geldiyse, hidden kur değerini güncelle
    if (element.classList.contains('kur-input')) {
        const hiddenKurInput = satir.querySelector('.kur');
        if (hiddenKurInput) {
            const yeniKur = parseFloat(element.value.replace(',', '.')) || 1.0;
            hiddenKurInput.value = yeniKur;
        }
    }
    
    // Para birimlerini al
    const urunParaBirimi = satir.querySelector('input[name^="satis_para_birimi"]') ? 
        satir.querySelector('input[name^="satis_para_birimi"]').value : 'TL';
    
    // Döviz kuru hesapla (sadece çoklu para birimi aktifse)
    let kur = 1.0;
    const cokluParaBirimiAktif = document.getElementById('coklu_para_birimi_aktif') ? 
        document.getElementById('coklu_para_birimi_aktif').value === '1' : false;
        
    if (cokluParaBirimiAktif && urunParaBirimi !== faturaParaBirimi) {
        try {
            const kurInput = satir.querySelector('.kur');
            if (kurInput) {
                kur = parseFloat(kurInput.value) || 1.0;
            }
        } catch (error) {
            console.error('Döviz kuru alınırken hata oluştu:', error);
            kur = 1.0;
        }
    }
    
    // Tutarları hesapla
    const araToplam = miktar * fiyat;
    const kdvTutar = araToplam * (kdvOrani / 100);
    const satirToplamKDVli = araToplam + kdvTutar;
    
    // Fatura para birimine çevir
    const araToplamFatura = araToplam * kur;
    const kdvTutarFatura = kdvTutar * kur;
    const satirToplamKDVliFatura = satirToplamKDVli * kur;

    // Güncellemeleri yap
    const kdvTutarElement = satir.querySelector('.kdv-tutar');
    const satirToplamElement = satir.querySelector('.satir-toplam');
    
    // Global faturaParaBirimi değişkenini güncelle
    faturaParaBirimi = document.getElementById('fatura_para_birimi') ? 
        document.getElementById('fatura_para_birimi').value : (window.initialFaturaParaBirimi || 'TL');
    
    if (kdvTutarElement) {
        // Sadece sayısal değeri göster, para birimi gösterme
        kdvTutarElement.textContent = kdvTutarFatura.toFixed(2).replace('.', ',');
    }
    
    if (satirToplamElement) {
        // Sadece sayısal değeri göster, para birimi gösterme
        satirToplamElement.textContent = satirToplamKDVliFatura.toFixed(2).replace('.', ',');
    }
    
    // Gizli input alanlarını güncelle
    const kdvTutarInput = satir.querySelector('input[name^="kdv_tutari"]');
    if (kdvTutarInput) {
        kdvTutarInput.value = kdvTutarFatura.toFixed(2);
    }
    
    await genelToplamGuncelle();
}

function urunAdediGuncelle() {
    const urunSatirlari = document.querySelectorAll('#urunListesi .urun-satiri');
    let toplamUrun = 0;
    
    urunSatirlari.forEach(satir => {
        const miktarInput = satir.querySelector('.miktar');
        if (miktarInput) {
            const miktar = parseFloat(miktarInput.value.replace(',', '.')) || 0;
            toplamUrun += miktar;
        }
    });
    
    const toplamUrunElement = document.getElementById('toplamUrunAdedi');
    if (toplamUrunElement) {
        toplamUrunElement.textContent = `${toplamUrun.toFixed(2).replace(/\.?0+$/, '')} adet ürün eklendi`;
    }
}

function urunAdediGuncelle() {
    const urunSatirlari = document.querySelectorAll('#urunListesi .urun-satiri');
    let toplamUrun = 0;
    
    urunSatirlari.forEach(satir => {
        const miktarInput = satir.querySelector('.miktar');
        if (miktarInput) {
            const miktar = parseFloat(miktarInput.value.replace(',', '.')) || 0;
            toplamUrun += miktar;
        }
    });
    
    const toplamUrunElement = document.getElementById('toplamUrunAdedi');
    if (toplamUrunElement) {
        toplamUrunElement.textContent = `${toplamUrun.toFixed(2).replace(/\.?0+$/, '')} adet ürün eklendi`;
    }
}

async function genelToplamGuncelle() {
    let araToplam = 0;
    let toplamKdv = 0;
    const urunSatirlari = document.querySelectorAll('#urunListesi .urun-satiri');
    
    // Update product count
    urunAdediGuncelle();
    
    // Update product count
    urunAdediGuncelle();
    
    // Global faturaParaBirimi değişkenini güncelle
    faturaParaBirimi = document.getElementById('fatura_para_birimi') ? 
        document.getElementById('fatura_para_birimi').value : (window.initialFaturaParaBirimi || 'TL');

    for (const satir of urunSatirlari) {
        const miktarInput = satir.querySelector('.miktar');
        const fiyatInput = satir.querySelector('.fiyat');
        const kdvInput = satir.querySelector('.kdv');
        const kurInput = satir.querySelector('.kur');
        const urunParaBirimi = satir.querySelector('input[name^="satis_para_birimi"]') ? 
            satir.querySelector('input[name^="satis_para_birimi"]').value : 'TL';

        if (miktarInput && fiyatInput && kdvInput) {
            const miktar = parseFloat(miktarInput.value.replace(',', '.')) || 0;
            const fiyat = parseFloat(fiyatInput.value.replace(',', '.')) || 0;
            const kdvOrani = parseFloat(kdvInput.value.replace(',', '.')) || 0;
            let kur = 1.0;
            
            // Döviz kuru hesapla
            if (kurInput) {
                kur = parseFloat(kurInput.value) || 1.0;
            } else if (urunParaBirimi !== faturaParaBirimi) {
                try {
                    kur = await window.fetchKur(urunParaBirimi, faturaParaBirimi);
                    // Kur değerini güncelle
                    const newKurInput = document.createElement('input');
                    newKurInput.type = 'hidden';
                    newKurInput.className = 'kur';
                    newKurInput.name = 'kur[]';
                    newKurInput.value = kur;
                    satir.querySelector('td:has(.kur)').innerHTML = `${kur.toFixed(4)}`;
                    satir.querySelector('td:has(.kur)').appendChild(newKurInput);
                } catch (error) {
                    console.error('Döviz kuru alınırken hata oluştu:', error);
                    kur = 1.0;
                }
            }
            
            const satirAraToplam = miktar * fiyat * kur;
            araToplam += satirAraToplam;
            toplamKdv += (satirAraToplam * kdvOrani) / 100;
        }
    }

    const indirimInput = document.getElementById('indirim_tutari');
    const indirim = indirimInput ? (parseFloat(indirimInput.value.replace(',', '.')) || 0) : 0;
    const genelToplam = araToplam + toplamKdv - indirim;

    // Global faturaParaBirimi değişkenini güncelle
    faturaParaBirimi = document.getElementById('fatura_para_birimi') ? 
        document.getElementById('fatura_para_birimi').value : (window.initialFaturaParaBirimi || 'TL');
    
    // Toplamları güncelle
    const araToplamElement = document.getElementById('araToplam');
    const toplamKdvElement = document.getElementById('toplamKdv');
    const toplamTutarElement = document.getElementById('toplamTutar');
    
    // Para birimi etiketlerini güncelle
    const araToplamParaBirimi = document.getElementById('araToplamParaBirimi');
    const toplamKdvParaBirimi = document.getElementById('toplamKdvParaBirimi');
    const genelToplamParaBirimi = document.getElementById('genelToplamParaBirimi');
    
    if (araToplamElement) araToplamElement.textContent = araToplam.toFixed(2).replace('.', ',');
    if (toplamKdvElement) toplamKdvElement.textContent = toplamKdv.toFixed(2).replace('.', ',');
    if (toplamTutarElement) toplamTutarElement.textContent = genelToplam.toFixed(2).replace('.', ',');
    
    // Para birimi etiketlerini güncelle
    if (araToplamParaBirimi) araToplamParaBirimi.textContent = ' ' + faturaParaBirimi;
    if (toplamKdvParaBirimi) toplamKdvParaBirimi.textContent = ' ' + faturaParaBirimi;
    if (genelToplamParaBirimi) genelToplamParaBirimi.textContent = ' ' + faturaParaBirimi;
    
    // Gizli input alanlarını güncelle
    const araToplamInput = document.getElementById('ara_toplam');
    const toplamKdvInput = document.getElementById('toplam_kdv');
    const genelToplamInput = document.getElementById('genel_toplam');
    
    if (araToplamInput) araToplamInput.value = araToplam.toFixed(2);
    if (toplamKdvInput) toplamKdvInput.value = toplamKdv.toFixed(2);
    if (genelToplamInput) genelToplamInput.value = genelToplam.toFixed(2);
    
    return { araToplam, toplamKdv, genelToplam };
}

function urunSil(btn) {
    const tbody = document.getElementById('urunListesi');
    btn.closest('tr').remove();
    
    // Update product count
    urunAdediGuncelle();
    
    // Eğer hiç ürün kalmadıysa placeholder'ı geri göster
    if (document.querySelectorAll('#urunListesi .urun-satiri').length === 0) {
        const placeholderRow = document.getElementById('placeholder-row');
        if (placeholderRow) {
            placeholderRow.style.display = 'table-row';
        }
    }

    genelToplamGuncelle();
}

function yeniCariEkle() {
    // Bu fonksiyonun içeriği, satis_yeni.php'deki ile aynı kalabilir.
    // Gerekirse buraya eklenebilir.
}