let urunSayaci = 0;
let urunSecModal, yeniCariModal;

document.addEventListener('DOMContentLoaded', function() {
    urunSecModal = new bootstrap.Modal(document.getElementById('urunSecModal'));
    yeniCariModal = new bootstrap.Modal(document.getElementById('yeniCariModal'));

    // Ürün arama ve filtreleme
    const urunAramaInput = document.getElementById('urunArama');
    const tedarikciFiltre = document.getElementById('tedarikciFiltre');
    if(urunAramaInput) urunAramaInput.addEventListener('input', () => urunAra());
    if(tedarikciFiltre) tedarikciFiltre.addEventListener('change', () => urunAra());

    // Cari arama
    const cariAramaInput = document.getElementById('cari_arama');
    if(cariAramaInput) cariAramaInput.addEventListener('input', cariAra);

    // Yeni cari ekleme
    const cariEkleBtn = document.getElementById('cariEkleBtn');
    if(cariEkleBtn) cariEkleBtn.addEventListener('click', yeniCariEkle);
    
    // Modal açıldığında focus sorununu düzeltmek için
    const urunSecModalEl = document.getElementById('urunSecModal');
    if(urunSecModalEl) {
        urunSecModalEl.addEventListener('shown.bs.modal', function () {
            document.getElementById('urunArama').focus();
        });
    }

    genelToplamGuncelle(); // Sayfa yüklendiğinde genel toplamı güncelle
});

function urunAra() {
    const arama = document.getElementById('urunArama').value;
    const tedarikci_id = document.getElementById('tedarikciFiltre') ? document.getElementById('tedarikciFiltre').value : '';
    const urunSonuclari = document.getElementById('urunSonuclari');

    if (arama.length < 2 && !tedarikci_id) {
        urunSonuclari.innerHTML = '';
        return;
    }

    const formData = new FormData();
    formData.append('arama', arama);
    formData.append('tedarikci_id', tedarikci_id);

    fetch('../ajax/urun_ara_ajax.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        let html = '<div class="list-group">';
        if (data.success && data.urunler.length > 0) {
            data.urunler.forEach(urun => {
                const adi = urun.urun_adi.replace(/'/g, "\\'").replace(/"/g, "&quot;");
                
                // Sayfanın 'alis_yeni.php' olup olmadığını kontrol et
                const isPurchasePage = window.location.pathname.endsWith('alis_yeni.php');
                const fiyat = isPurchasePage ? (urun.alis_fiyati || 0) : (urun.satis_fiyati || 0);
const paraBirimi = isPurchasePage ? (urun.alis_para_birimi || 'TL') : (urun.satis_para_birimi || 'TL');

                if(isPurchasePage) {
    html += `<a href="#" class="list-group-item list-group-item-action" onclick="event.preventDefault(); urunSec(${urun.id}, '${adi}', ${fiyat}, ${urun.kdv_orani || 0}, '${paraBirimi}')">
        ${urun.urun_adi} <span class="float-end">${parseFloat(fiyat).toFixed(2)} ${paraBirimi}</span>
     </a>`;
} else {
    html += `<a href="#" class="list-group-item list-group-item-action" onclick="event.preventDefault(); urunSec(${urun.id}, '${adi}', ${fiyat}, ${urun.kdv_orani || 0}, '${paraBirimi}')">
        ${urun.urun_adi} <span class="float-end">${parseFloat(fiyat).toFixed(2)} ${paraBirimi}</span>
     </a>`;
}
            });
        } else {
            html += '<div class="list-group-item text-muted">Ürün bulunamadı.</div>';
        }
        html += '</div>';
        urunSonuclari.innerHTML = html;
    });
}

function urunSec(id, adi, fiyat, kdvOrani, paraBirimi = 'TL') {
    console.log('urunSec çağrıldı:', { id, adi, fiyat, kdvOrani, paraBirimi });
    // Satış sayfası mı kontrolü
    const isSalesPage = window.location.pathname.endsWith('satis_yeni.php');
    // Ürünün zaten ekli olup olmadığını kontrol et
    let isAdded = false;
    document.querySelectorAll('input[name="urun_id[]"]').forEach(input => {
        if (input.value == id) {
            isAdded = true;
            // Miktarı artır
            const existingRow = input.closest('tr');
            const miktarInput = existingRow.querySelector('.miktar');
            miktarInput.value = parseInt(miktarInput.value) + 1;
            satirGuncelle(miktarInput);

            // Mevcut satırı vurgula
            existingRow.classList.add('table-warning');
            setTimeout(() => {
                existingRow.classList.remove('table-warning');
            }, 1500);
        }
    });

    if (isAdded) {
        urunSecModal.hide();
        document.getElementById('urunArama').value = '';
        document.getElementById('urunSonuclari').innerHTML = '';
        return;
    }
    
    urunSayaci++;
    const tbody = document.getElementById('urunListesi');
    const placeholderRow = document.getElementById('placeholder-row');
    if (placeholderRow) {
        placeholderRow.style.display = 'none';
    }
    
    console.log('Satıra eklenecek paraBirimi:', paraBirimi);
    const newRow = tbody.insertRow();
    newRow.id = `urun_satir_${urunSayaci}`;
    newRow.classList.add('urun-satiri'); // Hesaplama için bir sınıf ekle
    // Satır eklemeden hemen sonra:
    newRow.innerHTML = `
        <td class="align-middle">${adi}<input type="hidden" name="urun_id[]" value="${id}"></td>
        <td><input type="text" class="form-control form-control-sm miktar text-end" name="miktar[]" value="1" oninput="satirGuncelle(this)" inputmode="decimal"></td>
        <td><input type="text" class="form-control form-control-sm fiyat text-end" name="birim_fiyat[]" value="${fiyat.toFixed(2).replace('.', ',')}" oninput="satirGuncelle(this)" inputmode="decimal"></td>
        <td class="align-middle fw-bold">${paraBirimi}<input type="hidden" name="satis_para_birimi[]" value="${paraBirimi}"></td>
        <td><input type="text" class="form-control form-control-sm kdv text-end" name="kdv_orani[]" value="${kdvOrani}" oninput="satirGuncelle(this)" inputmode="decimal"></td>
        <td class="align-middle text-end kdv-tutar">0,00</td>
        <td class="align-middle text-end fw-bold satir-toplam">0,00</td>
        <td class="align-middle text-center">
            <a href="#" class="btn btn-danger btn-sm btn-icon" onclick="event.preventDefault(); urunSil(this)" title="Sil">
                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-trash" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                   <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                   <path d="M4 7l16 0"></path>
                   <path d="M10 11l0 6"></path>
                   <path d="M14 11l0 6"></path>
                   <path d="M5 7l1 12a2 2 0 0 0 2 2h8a2 2 0 0 0 2 -2l1 -12"></path>
                   <path d="M9 7v-3a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v3"></path>
                </svg>
            </a>
        </td>
    `;
    console.log('Eklenen satır HTML:', newRow.innerHTML);
    satirGuncelle(newRow.querySelector('.miktar'));
    urunSecModal.hide();
    document.getElementById('urunArama').value = '';
    document.getElementById('urunSonuclari').innerHTML = '';
}

function satirGuncelle(element) {
    const satir = element.closest('tr');
    const miktar = parseFloat(satir.querySelector('.miktar').value.replace(',', '.')) || 0;
    const fiyat = parseFloat(satir.querySelector('.fiyat').value.replace(',', '.')) || 0;
    const kdvOrani = parseFloat(satir.querySelector('.kdv').value.replace(',', '.')) || 0;
    
    const araToplam = miktar * fiyat;
    const kdvTutar = araToplam * (kdvOrani / 100);
    const satirToplamKDVli = araToplam + kdvTutar;

   satir.querySelector('.kdv-tutar').textContent = kdvTutar.toFixed(2).replace('.', ',');
   satir.querySelector('.satir-toplam').textContent = satirToplamKDVli.toFixed(2).replace('.', ',');
    
    genelToplamGuncelle();
}

function genelToplamGuncelle() {
    let araToplam = 0;
    let toplamKdv = 0;
    const urunSatirlari = document.querySelectorAll('#urunListesi .urun-satiri');

    urunSatirlari.forEach(satir => {
        const miktarInput = satir.querySelector('.miktar');
        const fiyatInput = satir.querySelector('.fiyat');
        const kdvInput = satir.querySelector('.kdv');

        if (miktarInput && fiyatInput && kdvInput) {
            const miktar = parseFloat(miktarInput.value.replace(',', '.')) || 0;
            const fiyat = parseFloat(fiyatInput.value.replace(',', '.')) || 0;
            const kdvOrani = parseFloat(kdvInput.value.replace(',', '.')) || 0;
            
            const satirAraToplam = miktar * fiyat;
            araToplam += satirAraToplam;
            toplamKdv += satirAraToplam * (kdvOrani / 100);
        }
    });

    const indirimInput = document.getElementById('indirim_tutari');
    const indirim = indirimInput ? (parseFloat(indirimInput.value.replace(',', '.')) || 0) : 0;
    const genelToplam = araToplam + toplamKdv - indirim;

    document.getElementById('araToplam').textContent = araToplam.toFixed(2).replace('.', ',');
    document.getElementById('toplamKdv').textContent = toplamKdv.toFixed(2).replace('.', ',');
    document.getElementById('toplamTutar').textContent = genelToplam.toFixed(2).replace('.', ',');
}

function urunSil(btn) {
    const tbody = document.getElementById('urunListesi');
    btn.closest('tr').remove();
    
    // Eğer hiç ürün kalmadıysa placeholder'ı geri göster
    if (document.querySelectorAll('#urunListesi .urun-satiri').length === 0) {
        const placeholderRow = document.getElementById('placeholder-row');
        if (placeholderRow) {
            placeholderRow.style.display = 'table-row';
        }
    }

    genelToplamGuncelle();
}

function cariAra() {
    const arama = document.getElementById('cari_arama').value;
    const sonuclarDiv = document.getElementById('cariSonuclar');
    if (arama.length < 2) {
        sonuclarDiv.style.display = 'none';
        return;
    }
    fetch('../ajax/cari_ara_ajax.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'arama=' + encodeURIComponent(arama)
    })
    .then(response => response.json())
    .then(data => {
        let html = '';
        if (data.success && data.cariler.length > 0) {
            data.cariler.forEach(cari => {
                html += `<a href="#" class="autocomplete-suggestion" onclick="event.preventDefault(); cariSec(${cari.id}, '${cari.ad_soyad.replace(/'/g, "\\'")}')">${cari.ad_soyad}</a>`;
            });
        } else {
            html = '<div class="autocomplete-suggestion text-muted">Sonuç bulunamadı</div>';
        }
        sonuclarDiv.innerHTML = html;
        sonuclarDiv.style.display = 'block';
    });
}

function cariSec(id, ad) {
    document.getElementById('cari_id').value = id;
    document.getElementById('cari_arama').value = ad;
    document.getElementById('seciliCari').innerHTML = `<div class="alert alert-success mb-0">Seçilen: <strong>${ad}</strong></div>`;
    document.getElementById('cariSonuclar').style.display = 'none';
}

function yeniCariEkle() {
    // Bu fonksiyonun içeriği, satis_yeni.php'deki ile aynı kalabilir.
    // Gerekirse buraya eklenebilir.
}
