<?php
require_once __DIR__ . 
'/../includes/config.php';
require_once __DIR__ . 
'/../includes/ayar_fonksiyonlari.php';
yetkili_mi();

$sayfa_baslik = "Hesap Düzenle";

$hesap_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$hesap_id) {
    $_SESSION['hata'] = "Geçersiz hesap ID'si.";
    header('Location: hesaplar.php');
    exit();
}

$hesap = null;
try {
    $stmt = $db->prepare("SELECT * FROM hesaplar WHERE id = ?");
    $stmt->execute([$hesap_id]);
    $hesap = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$hesap) {
        $_SESSION['hata'] = "Hesap bulunamadı.";
        header('Location: hesaplar.php');
        exit();
    }
} catch (PDOException $e) {
    error_log("Hesap çekme hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Hesap bilgileri yüklenirken bir hata oluştu.";
    header('Location: hesaplar.php');
    exit();
}

// Desteklenen para birimleri (şimdilik sabit, daha sonra dinamikleşebilir)
$desteklenen_para_birimleri = ["TRY", "USD", "EUR", "GBP"];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = "Geçersiz form gönderimi!";
        header("Location: hesap_duzenle.php?id=" . $hesap_id);
        exit();
    }

    $hesap_adi = temizle($_POST['hesap_adi'] ?? '');
    $hesap_turu = temizle($_POST['hesap_turu'] ?? '');
    $para_birimi = temizle($_POST['para_birimi'] ?? '');
    $aciklama = temizle($_POST['aciklama'] ?? '');

    $hatalar = [];
    if (empty($hesap_adi)) $hatalar[] = "Hesap adı boş bırakılamaz.";
    if (empty($hesap_turu)) $hatalar[] = "Hesap türü boş bırakılamaz.";
    if (empty($para_birimi)) $hatalar[] = "Para birimi boş bırakılamaz.";

    if (empty($hatalar)) {
        try {
            $stmt = $db->prepare("UPDATE hesaplar SET hesap_adi = ?, hesap_turu = ?, para_birimi = ?, aciklama = ? WHERE id = ?");
            $stmt->execute([$hesap_adi, $hesap_turu, $para_birimi, $aciklama, $hesap_id]);

            $_SESSION['mesaj'] = "Hesap başarıyla güncellendi.";
            header("Location: hesaplar.php");
            exit();
        } catch (PDOException $e) {
            error_log("Hesap güncelleme hatası: " . $e->getMessage());
            $_SESSION['hata'] = "Hesap güncellenirken bir hata oluştu.";
            header("Location: hesap_duzenle.php?id=" . $hesap_id);
            exit();
        }
    } else {
        $_SESSION['form_hatalari_hesap_duzenle'] = $hatalar;
        $_SESSION['form_verileri_hesap_duzenle'] = $_POST;
        header("Location: hesap_duzenle.php?id=" . $hesap_id);
        exit();
    }
}

$csrf_token = csrf_token_olustur();
$form_hatalari = $_SESSION['form_hatalari_hesap_duzenle'] ?? [];
$form_verileri = $_SESSION['form_verileri_hesap_duzenle'] ?? $hesap;
unset($_SESSION['form_hatalari_hesap_duzenle'], $_SESSION['form_verileri_hesap_duzenle']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <h2><i class="bi bi-pencil-square"></i> <?= temizle($sayfa_baslik) ?></h2>
        <hr>

        <?php if (!empty($form_hatalari)): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong><i class="bi bi-exclamation-triangle-fill me-2"></i> Lütfen hataları düzeltin:</strong>
                <ul>
                    <?php foreach ($form_hatalari as $hata): ?>
                        <li><?= htmlspecialchars($hata) ?></li>
                    <?php endforeach; ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        <?php endif; ?>

        <form method="post">
            <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="mb-3">
                        <label for="hesap_adi" class="form-label">Hesap Adı <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="hesap_adi" name="hesap_adi" value="<?= htmlspecialchars($form_verileri['hesap_adi'] ?? '', ENT_QUOTES) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="hesap_turu" class="form-label">Hesap Türü <span class="text-danger">*</span></label>
                        <select class="form-select" id="hesap_turu" name="hesap_turu" required>
                            <option value="">-- Seçiniz --</option>
                            <option value="kasa" <?= (isset($form_verileri['hesap_turu']) && $form_verileri['hesap_turu'] == 'kasa') ? 'selected' : '' ?>>Kasa</option>
                            <option value="banka" <?= (isset($form_verileri['hesap_turu']) && $form_verileri['hesap_turu'] == 'banka') ? 'selected' : '' ?>>Banka</option>
                            <option value="kredi_karti" <?= (isset($form_verileri['hesap_turu']) && $form_verileri['hesap_turu'] == 'kredi_karti') ? 'selected' : '' ?>>Kredi Kartı</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="para_birimi" class="form-label">Para Birimi <span class="text-danger">*</span></label>
                        <select class="form-select" id="para_birimi" name="para_birimi" required>
                            <?php foreach ($desteklenen_para_birimleri as $pb): ?>
                                <option value="<?= $pb ?>" <?= (isset($form_verileri['para_birimi']) && $form_verileri['para_birimi'] == $pb) ? 'selected' : '' ?>><?= $pb ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label">Açıklama</label>
                        <textarea class="form-control" id="aciklama" name="aciklama" rows="3"><?= htmlspecialchars($form_verileri['aciklama'] ?? '', ENT_QUOTES) ?></textarea>
                    </div>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-save me-2"></i> Hesabı Güncelle
                    </button>
                    <a href="hesaplar.php" class="btn btn-secondary"><i class="bi bi-arrow-left me-2"></i> Geri Dön</a>
                </div>
            </div>
        </form>
    </div>

    <?php include __DIR__ . '/../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>


