<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

header('Content-Type: application/json');

$cari_id = filter_input(INPUT_GET, 'cari_id', FILTER_VALIDATE_INT);

if (!$cari_id) {
    echo json_encode([]);
    exit;
}

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
try {
    $stmt = $db->prepare("
        SELECT id, tur, tutar, vade_tarihi, aciklama, durum
        FROM borclar
        WHERE cari_id = ? AND durum != 'odendi' AND sirket_id = ?
        ORDER BY vade_tarihi ASC
    ");
    $stmt->execute([$cari_id, $aktif_sirket_id]);
    $borclar = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode($borclar);
} catch (PDOException $e) {
    error_log("Borç getirme hatası: " . $e->getMessage());
    echo json_encode([]);
}
?>
