<?php
require_once __DIR__ . '/../includes/config.php';
// yetkili_mi(); // Kullanıcı yetkilendirme kontrolü istemedi.

if (!isset($_GET['id']) || !($cari_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    $_SESSION['hata'] = "Geçersiz Cari ID.";
    header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'cariler.php'));
    exit();
}

// CSRF token check
if (!isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
    $_SESSION['hata'] = "Geçersiz güvenlik tokeni!";
    header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'cariler.php'));
    exit();
}

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

try {
    $db->beginTransaction();

    // 1. Cari'ye ait hesap hareketi olup olmadığını kontrol et (şirket bazında)
    $stmt_check_hareket = $db->prepare("SELECT COUNT(*) as hareket_sayisi FROM hesap_hareketleri WHERE cari_id = ? AND sirket_id = ?");
    $stmt_check_hareket->execute([$cari_id, $aktif_sirket_id]);
    $hareket_sayisi = (int)$stmt_check_hareket->fetchColumn();

    // 2. Cari bilgilerini al ve şirkete ait olduğunu doğrula
    $stmt_cari_info = $db->prepare("SELECT ad_soyad FROM cariler WHERE id = ? AND sirket_id = ?");
    $stmt_cari_info->execute([$cari_id, $aktif_sirket_id]);
    $cari_info = $stmt_cari_info->fetch(PDO::FETCH_ASSOC);
    $cari_ad_soyad = $cari_info ? htmlspecialchars($cari_info['ad_soyad'], ENT_QUOTES, 'UTF-8') : "Bilinmeyen Cari";

    if (!$cari_info) {
        throw new Exception("İşlem yapılacak cari bulunamadı veya bu şirkete ait değil.");
    }

    if ($hareket_sayisi > 0) {
        // Hesap hareketi varsa, cariyi pasif yap (aktif = 0)
        $stmt_pasiflestir = $db->prepare("UPDATE cariler SET aktif = 0 WHERE id = ? AND sirket_id = ?");
        if ($stmt_pasiflestir->execute([$cari_id, $aktif_sirket_id])) {
            $_SESSION['mesaj'] = "Cari '{$cari_ad_soyad}' (ID: {$cari_id}) ilişkili hesap hareketleri bulunduğu için pasifleştirildi.";
        } else {
            throw new Exception("Cari pasifleştirilirken bir hata oluştu.");
        }
    } else {
        // Hesap hareketi yoksa, cariyi sil
        $stmt_sil_cari = $db->prepare("DELETE FROM cariler WHERE id = ? AND sirket_id = ?");
        if ($stmt_sil_cari->execute([$cari_id, $aktif_sirket_id])) {
            if ($stmt_sil_cari->rowCount() > 0) {
                 $_SESSION['mesaj'] = "Cari '{$cari_ad_soyad}' (ID: {$cari_id}) başarıyla silindi.";
            } else {
                 // Bu durum, cari_id'nin başta bulunamamasıyla aynı kapıya çıkar ama yine de bir kontrol.
                 throw new Exception("Silinecek cari bulunamadı veya zaten silinmiş.");
            }
        } else {
            throw new Exception("Cari silinirken bir hata oluştu.");
        }
    }

    $db->commit();

} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    error_log("Cari silme/pasifleştirme hatası (Cari ID: {$cari_id}): " . $e->getMessage());
    $_SESSION['hata'] = "Cari işlemi sırasında bir hata oluştu: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
}

// Kullanıcıyı yönlendir
header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'cariler.php')); // Varsayılan olarak cariler listesine yönlendir
exit();
?>
