<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/language_functions.php';
require_once __DIR__ . '/exportexcel.php';

// Oturum kontrolü
yetkili_mi(['cari_yonetimi', 'cari_goruntuleme']);

// Gelen parametreleri al
$cari_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$filtre_baslangic = $_GET['baslangic'] ?? '';
$filtre_bitis = $_GET['bitis'] ?? '';

// Zaman aralığı kontrolü
if (empty($filtre_baslangic) || empty($filtre_bitis)) {
    $filtre_baslangic = date('Y-m-01');
    $filtre_bitis = date('Y-m-d');
}

// Değişkenleri başlat
$secili_cari = null;
$ekstre = [];
$baslangic_bakiye = 0.0;
$donem_ici_borc = 0.0;
$donem_ici_alacak = 0.0;

if ($cari_id) {
    try {
        $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

        // Cari bilgilerini al ve şirkete ait olduğunu doğrula
        $cari_sorgu = "SELECT * FROM cariler WHERE id = :id AND sirket_id = :sirket_id";
        $cari_stmt = $db->prepare($cari_sorgu);
        $cari_stmt->execute(['id' => $cari_id, 'sirket_id' => $aktif_sirket_id]);
        $secili_cari = $cari_stmt->fetch(PDO::FETCH_ASSOC);

        if ($secili_cari) {
            // Dönem Başı Bakiyeyi Hesapla
            $sql_devir_borc = "SELECT SUM(tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) FROM borclar WHERE cari_id = :cari_id AND tur = 'satis' AND tarih < :baslangic AND sirket_id = :sirket_id";
            $sql_devir_alacak = "SELECT SUM(tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) FROM borclar WHERE cari_id = :cari_id AND tur = 'alis' AND tarih < :baslangic AND sirket_id = :sirket_id";
            
            $sql_devir_tahsilat = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'giris' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
            $sql_devir_odeme = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'cikis' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
            
            $params = [
                'cari_id' => $cari_id,
                'baslangic' => $filtre_baslangic,
                'sirket_id' => $aktif_sirket_id
            ];
            
            // Execute each query and fetch the result directly
            $stmt = $db->prepare($sql_devir_borc);
            $stmt->execute($params);
            $devir_borc = (float)$stmt->fetchColumn();
            
            $stmt = $db->prepare($sql_devir_alacak);
            $stmt->execute($params);
            $devir_alacak = (float)$stmt->fetchColumn();
            
            $stmt = $db->prepare($sql_devir_tahsilat);
            $stmt->execute($params);
            $devir_tahsilat = (float)$stmt->fetchColumn();
            
            $stmt = $db->prepare($sql_devir_odeme);
            $stmt->execute($params);
            $devir_odeme = (float)$stmt->fetchColumn();
            
            // Bakiye = (devir_alacak - devir_odeme) - (devir_borc - devir_tahsilat)
            $baslangic_bakiye = ($devir_alacak - $devir_odeme) - ($devir_borc - $devir_tahsilat);
            
            // Dönem İçi İşlemleri Al
            // Add time to the end date to include all transactions on the end date
            $params_donem = [
                'cari_id' => $cari_id,
                'baslangic' => $filtre_baslangic,
                'bitis' => $filtre_bitis . ' 23:59:59', // Include all transactions on the end date
                'sirket_id' => $aktif_sirket_id
            ];
            
            // Satışlar
            $sql_satislar = "SELECT 'satis' as tur, tarih, 
                                   COALESCE(aciklama, 'Satış') as belge_no, 
                                   (COALESCE(tutar, 0) + COALESCE(toplam_kdv, 0) - COALESCE(indirim_tutari, 0)) as tutar, 
                                   'BORÇ' as yon, 
                                   COALESCE(aciklama, 'Satış İşlemi') as aciklama 
                            FROM borclar 
                            WHERE cari_id = :cari_id AND tur = 'satis' AND sirket_id = :sirket_id 
                            AND tarih BETWEEN :baslangic AND :bitis 
                            ORDER BY tarih, id";
            $stmt_satislar = $db->prepare($sql_satislar);
            $stmt_satislar->execute($params_donem);
            $satislar = $stmt_satislar->fetchAll(PDO::FETCH_ASSOC);
            
            // Alımlar
            $sql_alislar = "SELECT 'alis' as tur, tarih, 
                                  COALESCE(aciklama, 'Alış') as belge_no, 
                                  (COALESCE(tutar, 0) + COALESCE(toplam_kdv, 0) - COALESCE(indirim_tutari, 0)) as tutar, 
                                  'ALACAK' as yon, 
                                  COALESCE(aciklama, 'Alış İşlemi') as aciklama 
                           FROM borclar 
                           WHERE cari_id = :cari_id AND tur = 'alis' AND sirket_id = :sirket_id 
                           AND tarih BETWEEN :baslangic AND :bitis 
                           ORDER BY tarih, id";
            $stmt_alislar = $db->prepare($sql_alislar);
            $stmt_alislar->execute($params_donem);
            $alislar = $stmt_alislar->fetchAll(PDO::FETCH_ASSOC);
            
            // Tahsilatlar (Giriş işlemleri)
            $sql_tahsilat = "SELECT 'tahsilat' as tur, tarih, 
                                    COALESCE(aciklama, 'Tahsilat') as belge_no, 
                                    COALESCE(tutar, 0) as tutar, 
                                    'ALACAK' as yon, 
                                    COALESCE(aciklama, 'Tahsilat İşlemi') as aciklama 
                            FROM hesap_hareketleri 
                            WHERE cari_id = :cari_id AND tur = 'giris' AND sirket_id = :sirket_id 
                            AND tarih BETWEEN :baslangic AND :bitis 
                            ORDER BY tarih, id";
            $stmt_tahsilat = $db->prepare($sql_tahsilat);
            $stmt_tahsilat->execute($params_donem);
            $tahsilatlar = $stmt_tahsilat->fetchAll(PDO::FETCH_ASSOC);
            
            // Ödemeler (Çıkış işlemleri)
            $sql_odeme = "SELECT 'odeme' as tur, tarih, 
                                 COALESCE(aciklama, 'Ödeme') as belge_no, 
                                 COALESCE(tutar, 0) as tutar, 
                                 'BORÇ' as yon, 
                                 COALESCE(aciklama, 'Ödeme İşlemi') as aciklama 
                         FROM hesap_hareketleri 
                         WHERE cari_id = :cari_id AND tur = 'cikis' AND sirket_id = :sirket_id 
                         AND tarih BETWEEN :baslangic AND :bitis 
                         ORDER BY tarih, id";
            $stmt_odeme = $db->prepare($sql_odeme);
            $stmt_odeme->execute($params_donem);
            $odemeler = $stmt_odeme->fetchAll(PDO::FETCH_ASSOC);
            
            // Tüm hareketleri tek bir dizide birleştir
            $tum_hareketler = array_merge($satislar, $alislar, $tahsilatlar, $odemeler);
            
            // Tarihe göre sırala
            usort($tum_hareketler, function($a, $b) {
                $timeA = strtotime($a['tarih'] ?? '');
                $timeB = strtotime($b['tarih'] ?? '');
                return $timeA - $timeB;
            });
            
            // Bakiye hesaplamaları için değişkenler
            $bakiye = $baslangic_bakiye;
            $donem_ici_borc = 0;
            $donem_ici_alacak = 0;
            
            // Ekstre verisini oluştur
            $ekstre = [];
            
            // Dönem başı bakiyeyi ekle
            $ekstre[] = [
                'tarih' => $filtre_baslangic,
                'belge_no' => 'DÖNEM BAŞI BAKİYE',
                'aciklama' => 'Dönem başı bakiyeniz',
                'borc' => $bakiye >= 0 ? abs($bakiye) : 0,
                'alacak' => $bakiye < 0 ? abs($bakiye) : 0,
                'bakiye' => $bakiye,
                'is_bakiye' => true
            ];
            
            // Hareketleri işle
            foreach ($tum_hareketler as $hareket) {
                $tutar = (float)$hareket['tutar'];
                $is_borc = ($hareket['yon'] === 'BORÇ');
                
                if ($is_borc) {
                    $donem_ici_borc += $tutar;
                    $bakiye += $tutar;
                } else {
                    $donem_ici_alacak += $tutar;
                    $bakiye -= $tutar;
                }
                
                $ekstre[] = [
                    'tarih' => $hareket['tarih'],
                    'belge_no' => $hareket['belge_no'],
                    'aciklama' => $hareket['aciklama'] ?? '',
                    'borc' => $is_borc ? $tutar : 0,
                    'alacak' => $is_borc ? 0 : $tutar,
                    'bakiye' => $bakiye,
                    'is_bakiye' => false
                ];
            }
            
            // Excel için veriyi hazırla
            $excel_data = [];
            
            // Başlıklar
            $columns = [
                __('date', 'Tarih'),
                __('description', 'Açıklama'),
                __('debit', 'Borç'),
                __('credit', 'Alacak'),
                __('balance', 'Bakiye')
            ];
            
            // Verileri düzenle ve toplamları hesapla
            $toplam_borc = 0;
            $toplam_alacak = 0;
            
            foreach ($ekstre as $hareket) {
                $toplam_borc += $hareket['borc'];
                $toplam_alacak += $hareket['alacak'];
                
                $excel_data[] = [
                    date('d.m.Y', strtotime($hareket['tarih'])),
                    $hareket['aciklama'],
                    $hareket['borc'] > 0 ? number_format($hareket['borc'], 2, ',', '.') : '',
                    $hareket['alacak'] > 0 ? number_format($hareket['alacak'], 2, ',', '.') : '',
                    number_format($hareket['bakiye'], 2, ',', '.')
                ];
            }
            
            // Toplam satırını ekle
            $excel_data[] = [
                '', // Tarih boş
                __('period_totals', 'Dönem Toplamı'),
                number_format($toplam_borc, 2, ',', '.'),
                number_format($toplam_alacak, 2, ',', '.'),
                '' // Bakiye toplamı boş
            ];
            
            // Dosya adını oluştur
            $filename = __('account_statement', 'Cari Ekstre') . '_' . $secili_cari['ad_soyad'] . '_' . date('d.m.Y', strtotime($filtre_baslangic)) . '_' . date('d.m.Y', strtotime($filtre_bitis));
            
            // Excel'i dışa aktar
            exportExcel($filename, $columns, $excel_data, [3, 4, 5]); // 3,4,5 indeksli sütunlar sayısal değerler (0'dan başlayarak)
            exit;
            
        } else {
            die(__("specified_account_id_not_found_or_not_belongs_to_company"));
        }
        
    } catch (PDOException $e) {
        error_log("Cari Ekstre Excel Hatası (ID: {$cari_id}): " . $e->getMessage());
        error_log("Hata Detayı: " . $e->getTraceAsString());
        die("Veritabanı hatası oluştu: " . $e->getMessage() . "\nLütfen sistem yöneticinize başvurun.");
    }
} else {
    die(__("account_id_not_specified"));
}
?>
