<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi(['cari_yonetimi', 'cari_goruntuleme']);

$sayfa_baslik = __("account_statement");
$paraBirimi = getParaBirimiSembolu();

// Gelen parametreleri al
$cari_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$zaman_araligi = $_GET['zaman_araligi'] ?? '';
$filtre_baslangic = $_GET['baslangic'] ?? '';
$filtre_bitis = $_GET['bitis'] ?? '';

// Tarih Filtreleme Mantığı
if ($zaman_araligi === 'bu_ay') {
    $filtre_baslangic = date('Y-m-01');
    $filtre_bitis = date('Y-m-t');
} elseif ($zaman_araligi === 'gecen_ay') {
    $filtre_baslangic = date('Y-m-01', strtotime('first day of last month'));
    $filtre_bitis = date('Y-m-t', strtotime('last day of last month'));
} elseif (empty($filtre_baslangic) && empty($filtre_bitis)) {
    // Hiçbir tarih seçilmemişse (ilk yükleme), varsayılan olarak bu ayı göster
    $filtre_baslangic = date('Y-m-01');
    $filtre_bitis = date('Y-m-d');
}

// Değişkenleri başlat
$secili_cari = null;
$ekstre = [];
$baslangic_bakiye = 0.0;
$donem_ici_borc = 0.0;
$donem_ici_alacak = 0.0;
$cariler = [];

// Cari listesini her zaman yükle
try {
    $cariler_stmt = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE sirket_id = ? ORDER BY ad_soyad");
    $cariler_stmt->execute([$_SESSION['aktif_sirket_id'] ?? 0]);
    $cariler = $cariler_stmt->fetchAll();
} catch (PDOException $e) {
    error_log("Cari Listesi Yükleme Hatası: " . $e->getMessage());
    $_SESSION['hata'] = "Cariler yüklenirken bir hata oluştu.";
    $cariler = [];
}

if ($cari_id) {
    try {
        $aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;

        // Cari bilgilerini al ve şirkete ait olduğunu doğrula
        $stmt_cari = $db->prepare("SELECT * FROM cariler WHERE id = ? AND sirket_id = ?");
        $stmt_cari->execute([$cari_id, $aktif_sirket_id]);
        $secili_cari = $stmt_cari->fetch();

        if ($secili_cari) {
             $sayfa_baslik .= " - " . temizle($secili_cari['ad_soyad']);

             // 1. Dönem Başı Bakiyeyi Hesapla
             // Dönem başından ÖNCEKİ tüm işlemlerin net etkisi
             $sql_devir_borc = "SELECT SUM(tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) FROM borclar WHERE cari_id = :cari_id AND tur = 'satis' AND tarih < :baslangic AND sirket_id = :sirket_id";
             $stmt_devir_borc = $db->prepare($sql_devir_borc);
             $stmt_devir_borc->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
             $devir_borc = $stmt_devir_borc->fetchColumn() ?: 0.0;

             $sql_devir_alacak = "SELECT SUM(tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) FROM borclar WHERE cari_id = :cari_id AND tur = 'alis' AND tarih < :baslangic AND sirket_id = :sirket_id";
             $stmt_devir_alacak = $db->prepare($sql_devir_alacak);
             $stmt_devir_alacak->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
             $devir_alacak = $stmt_devir_alacak->fetchColumn() ?: 0.0;

             $sql_devir_tahsilat = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'giris' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
             $stmt_devir_tahsilat = $db->prepare($sql_devir_tahsilat);
             $stmt_devir_tahsilat->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
             $devir_tahsilat = $stmt_devir_tahsilat->fetchColumn() ?: 0.0; // Müşteriden alınan para (müşteri borcunu azaltır)

             $sql_devir_odeme = "SELECT SUM(tutar) FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'cikis' AND DATE(tarih) < :baslangic AND sirket_id = :sirket_id";
             $stmt_devir_odeme = $db->prepare($sql_devir_odeme);
             $stmt_devir_odeme->execute([':cari_id' => $cari_id, ':baslangic' => $filtre_baslangic, ':sirket_id' => $aktif_sirket_id]);
             $devir_odeme = $stmt_devir_odeme->fetchColumn() ?: 0.0; // Tedarikçiye yapılan ödeme (bizim borcumuzu azaltır)

             // Başlangıç Bakiyesi: (Bizim Borçlarımız + Müşteri Ödemeleri) - (Müşteri Borçları + Bizim Ödemelerimiz)
             // Bakiye = (Toplam Alacak Hareketleri) - (Toplam Borç Hareketleri)
             // Bakiye = (devir_alacak + devir_tahsilat) - (devir_borc + devir_odeme) YANLIŞ
             // Bakiye = Cari'nin alacağı - Cari'nin borcu
             // Bakiye = (Bizim Borcumuz[Alış] - Bizim Yaptığımız Ödeme) - (Müşteri Borcu[Satış] - Müşteriden Alınan Tahsilat)
             // Başlangıç Bakiyesi = (devir_alacak - devir_odeme) - (devir_borc - devir_tahsilat)
             $baslangic_bakiye = ($devir_alacak - $devir_odeme) - ($devir_borc - $devir_tahsilat);


             // 2. Dönem İçi Hareketleri Çek ve Birleştir
             $params_donem = [
                 ':cari_id' => $cari_id,
                 ':baslangic' => $filtre_baslangic,
                 ':bitis' => $filtre_bitis . ' 23:59:59', // Bitiş tarihinin sonunu al
                 ':sirket_id' => $aktif_sirket_id
             ];

            // Satışlar (Müşteriye borç yazılır)
            $stmt_satis = $db->prepare("SELECT id, tarih, aciklama, (tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) AS net_tutar, 'Satış' as islem_turu FROM borclar WHERE cari_id = :cari_id AND tur = 'satis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
            $stmt_satis->execute($params_donem);
            $satislar = $stmt_satis->fetchAll();

            // Alışlar (Müşteriye alacak yazılır)
            $stmt_alis = $db->prepare("SELECT id, tarih, aciklama, (tutar + IFNULL(toplam_kdv,0) - IFNULL(indirim_tutari,0)) AS net_tutar, 'Alış' as islem_turu FROM borclar WHERE cari_id = :cari_id AND tur = 'alis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
            $stmt_alis->execute($params_donem);
            $alislar = $stmt_alis->fetchAll();

            // Tahsilatlar (Müşteri borcunu azaltır, hesaba GİRİŞ)
            $stmt_tahsilat = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Tahsilat' as islem_turu FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'giris' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
            $stmt_tahsilat->execute($params_donem);
            $tahsilatlar = $stmt_tahsilat->fetchAll();

             // Ödemeler (Bizim borcumuzu azaltır, hesaptan ÇIKIŞ)
            $stmt_odeme = $db->prepare("SELECT id, tarih, aciklama, tutar, 'Ödeme' as islem_turu FROM hesap_hareketleri WHERE cari_id = :cari_id AND tur = 'cikis' AND sirket_id = :sirket_id AND tarih BETWEEN :baslangic AND :bitis ORDER BY tarih ASC, id ASC");
            $stmt_odeme->execute($params_donem);
            $odemeler = $stmt_odeme->fetchAll();

            // Tüm hareketleri tek bir dizide birleştir
            $tum_hareketler = array_merge($satislar, $alislar, $tahsilatlar, $odemeler);

            // Tarihe göre sırala
            usort($tum_hareketler, function($a, $b) {
                $tarih_a = strtotime($a['tarih']);
                $tarih_b = strtotime($b['tarih']);
                 if ($tarih_a == $tarih_b) {
                     // Aynı tarihte ID'ye göre sırala (veya işlem türüne göre öncelik verilebilir)
                    return $a['id'] <=> $b['id']; // PHP 7+ spaceship operator
                 }
                return $tarih_a <=> $tarih_b;
            });

             // Ekstreyi oluştur ve bakiyeyi hesapla
             $bakiye = $baslangic_bakiye;
             foreach($tum_hareketler as $hareket) {
                 $borc_tutari = 0.0;
                 $alacak_tutari = 0.0;

                 switch ($hareket['islem_turu']) {
                     case 'Satış':
                         $borc_tutari = $hareket['net_tutar'] ?? $hareket['tutar']; // İndirim ve KDV dahil net borç
                         $donem_ici_borc += $borc_tutari;
                         break;
                     case 'Alış':
                         $alacak_tutari = $hareket['net_tutar'] ?? $hareket['tutar']; // Net alacak
                          $donem_ici_alacak += $alacak_tutari;
                         break;
                     case 'Tahsilat':
                         $alacak_tutari = $hareket['tutar']; // Müşteri borcunu öder (alacak hareketi gibi)
                          $donem_ici_alacak += $alacak_tutari;
                         break;
                     case 'Ödeme':
                         $borc_tutari = $hareket['tutar']; // Biz borcumuzu öderiz (borç hareketi gibi)
                          $donem_ici_borc += $borc_tutari;
                         break;
                 }
                 // Bakiye = Önceki Bakiye + Alacak - Borç
                 $bakiye += ($alacak_tutari - $borc_tutari);

                 $ekstre[] = [
                     'tarih' => $hareket['tarih'],
                      'aciklama' => $hareket['aciklama'] . " (" . $hareket['islem_turu'] . " #" . $hareket['id'] . ")",
                     'borc' => $borc_tutari,
                     'alacak' => $alacak_tutari,
                     'bakiye' => $bakiye
                 ];
             }


        } else {
            $_SESSION['hata'] = __("specified_account_id_not_found_or_not_belongs_to_company");
        }

    } catch (PDOException $e) {
        error_log("Cari Ekstre Hatası (ID: {$cari_id}): " . $e->getMessage());
        $_SESSION['hata'] = __("database_error_while_creating_statement");
    }
} else {
     // ID yoksa, cari listesi zaten yukarıda yüklendi.
     $secili_cari = null;
     $ekstre = [];
     $baslangic_bakiye = 0;
     $donem_ici_borc = 0;
     $donem_ici_alacak = 0;
     $son_bakiye = 0;
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        @media print {
            .no-print { display: none; }
            .table { font-size: 10pt; }
            .card-header, .card-footer { background-color: #fff !important; border: none !important;}
            h2, h5 { text-align: center; }
        }
        .table th { background-color: #f8f9fa; }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="card shadow-sm no-print">
            <div class="card-body">
                 <h2 class="text-center mb-4"><i class="bi bi-person-lines-fill me-2"></i> <?= __("account_statement") ?></h2>
                <form method="GET" class="row g-3 align-items-end justify-content-center">
                    <div class="col-md-4">
                        <label for="id" class="form-label fw-bold"><?= __("account") ?></label>
                        <select id="id" name="id" class="form-select" required onchange="this.form.submit()">
                            <option value="">-- <?= __("please_select_an_account") ?> --</option>
                            <?php foreach($cariler as $cari): ?>
                            <option value="<?= $cari['id'] ?>" <?= ($cari_id == $cari['id']) ? 'selected' : '' ?>>
                                <?= temizle($cari['ad_soyad']) ?>
                            </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-5">
                        <label class="form-label fw-bold"><?= __("period_selection") ?></label>
                        <div class="input-group">
                            <input type="date" id="baslangic" name="baslangic" class="form-control" value="<?= htmlspecialchars($filtre_baslangic) ?>" title="<?= __("start_date") ?>">
                            <input type="date" id="bitis" name="bitis" class="form-control" value="<?= htmlspecialchars($filtre_bitis) ?>" title="<?= __("end_date") ?>">
                        </div>
                    </div>

                    <div class="col-md-2">
                         <label class="form-label fw-bold">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-lg w-100">
                            <i class="bi bi-search"></i> <?= __("get") ?>
                        </button>
                    </div>
                </form>

                <div class="d-flex justify-content-center flex-wrap gap-2 mt-3">
                    <a href="?id=<?= $cari_id ?>&zaman_araligi=bu_ay" class="btn btn-sm btn-outline-secondary"><?= __("this_month") ?></a>
                    <a href="?id=<?= $cari_id ?>&zaman_araligi=gecen_ay" class="btn btn-sm btn-outline-secondary"><?= __("last_month") ?></a>
                    <?php
                        // Son 6 ayı listele
                        $turkce_aylar = ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran', 'Temmuz', 'Ağustos', 'Eylül', 'Ekim', 'Kasım', 'Aralık'];
                        for ($i = 0; $i < 6; $i++) {
                            $date = strtotime("-$i months");
                            $ay_baslangic = date('Y-m-01', $date);
                            $ay_bitis = date('Y-m-t', $date);
                            $ay_index = date('n', $date) - 1;
                            $ay_adi_turkce = $turkce_aylar[$ay_index];
                            $yil = date('Y', $date);
                            echo "<a href='?id={$cari_id}&baslangic={$ay_baslangic}&bitis={$ay_bitis}' class='btn btn-sm btn-outline-info'>{$ay_adi_turkce} {$yil}</a>";
                        }
                    ?>
                </div>
            </div>
        </div>

        <?php if ($secili_cari): ?>
        <div class="card shadow-sm mt-4">
             <div class="card-header">
                 <div class="d-flex justify-content-between align-items-center">
                     <h5 class="mb-0"><?= temizle($secili_cari['ad_soyad']) ?> - <?= __("statement") ?> (<?= date('d.m.Y', strtotime($filtre_baslangic)) ?> - <?= date('d.m.Y', strtotime($filtre_bitis)) ?>)</h5>
                     <div class="d-flex">
                         <a href="cari_ekstre_excel.php?id=<?= $cari_id ?>&baslangic=<?= urlencode($filtre_baslangic) ?>&bitis=<?= urlencode($filtre_bitis) ?>" class="btn btn-sm btn-success me-2">
                             <i class="bi bi-file-excel"></i> <?= __("download_excel") ?>
                         </a>
                         <a href="javascript:void(0);" onclick="pdfIndir('<?= $cari_id ?>', '<?= $filtre_baslangic ?>', '<?= $filtre_bitis ?>')" class="btn btn-sm btn-outline-primary no-print me-2">
                             <i class="bi bi-file-pdf"></i> <?= __("download_pdf") ?>
                         </a>
                         <button class="btn btn-sm btn-outline-secondary no-print" onclick="window.print();">
                             <i class="bi bi-printer"></i> <?= __("print") ?>
                         </button>
                     </div>
                 </div>
             </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-sm mb-0">
                        <thead class="table-light text-center">
                            <tr>
                                <th style="width:15%;"><?= __("date") ?></th>
                                <th><?= __("description") ?></th>
                                <th style="width:15%;"><?= __("debit") ?> (+)</th>
                                <th style="width:15%;"><?= __("credit") ?> (-)</th>
                                <th style="width:15%;"><?= __("balance") ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="2" class="text-end fw-bold"><?= __("opening_balance") ?> (<?= date('d.m.Y', strtotime($filtre_baslangic)) ?> <?= __("before") ?>)</td>
                                <td class="text-end"><?php /* Devir Borç */ ?></td>
                                <td class="text-end"><?php /* Devir Alacak */ ?></td>
                                <td class="text-end fw-bold <?= $baslangic_bakiye >= 0 ? 'text-success' : 'text-danger' ?>">
                                    <?= number_format($baslangic_bakiye, 2, ',', '.') . ' ' . $paraBirimi ?>
                                     <span class="ms-1"><?= $baslangic_bakiye > 0 ? 'A' : ($baslangic_bakiye < 0 ? 'B' : '') ?></span>
                                </td>
                            </tr>
                            <?php if (empty($ekstre)): ?>
                                <tr>
                                    <td colspan="5" class="text-center text-muted py-3"><?= __("no_transactions_found_in_selected_period") ?></td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($ekstre as $hareket): ?>
                                    <tr>
                                        <td class="text-center"><?= date('d.m.Y', strtotime($hareket['tarih'])) ?></td>
                                        <td><?= temizle($hareket['aciklama']) ?></td>
                                        <td class="text-end text-danger"><?= $hareket['borc'] > 0 ? number_format($hareket['borc'], 2, ',', '.') . ' ' . $paraBirimi : '-' ?></td>
                                        <td class="text-end text-success"><?= $hareket['alacak'] > 0 ? number_format($hareket['alacak'], 2, ',', '.') . ' ' . $paraBirimi : '-' ?></td>
                                        <td class="text-end fw-bold <?= $hareket['bakiye'] >= 0 ? 'text-success' : 'text-danger' ?>">
                                            <?= number_format($hareket['bakiye'], 2, ',', '.') . ' ' . $paraBirimi ?>
                                             <span class="ms-1"><?= $hareket['bakiye'] > 0 ? 'A' : ($hareket['bakiye'] < 0 ? 'B' : '') ?></span>
                                             <?php // A: Alacaklı (Biz borçluyuz), B: Borçlu (Bize borçlu) ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                             <tr class="table-light">
                                 <td colspan="2" class="text-end fw-bold"><?= __("period_totals") ?></td>
                                 <td class="text-end fw-bold text-danger"><?= number_format($donem_ici_borc, 2, ',', '.') . ' ' . $paraBirimi ?></td>
                                 <td class="text-end fw-bold text-success"><?= number_format($donem_ici_alacak, 2, ',', '.') . ' ' . $paraBirimi ?></td>
                                 <td class="text-end"></td> <?php // Bakiye toplamı anlamsız ?>
                             </tr>
                             <tr class="table-secondary">
                                 <td colspan="4" class="text-end fw-bold"><?= __("closing_balance") ?> (<?= date('d.m.Y', strtotime($filtre_bitis)) ?>)</td>
                                 <td class="text-end fw-bold <?= $bakiye >= 0 ? 'text-success' : 'text-danger' ?>">
                                     <?= number_format($bakiye, 2, ',', '.') . ' ' . $paraBirimi ?>
                                      <span class="ms-1"><?= $bakiye > 0 ? 'A' : ($bakiye < 0 ? 'B' : '') ?></span>
                                 </td>
                             </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php elseif ($cari_id): ?>
             <div class="alert alert-warning mt-4"><?= __("selected_account_not_found_or_error_loading") ?></div>
         <?php elseif (!empty($cariler)): ?>
              <div class="alert alert-info mt-4 text-center"><?= __("please_select_an_account_to_view_statement") ?></div>
         <?php else: ?>
              <div class="alert alert-warning mt-4 text-center"><?= __("no_accounts_found_in_system") ?></div>
         <?php endif; ?>
    </div>
	   
	 <?php include __DIR__ . "/../includes/footer.php"; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function pdfIndir(cariId, baslangic, bitis) {
            // Yeni bir sekme aç ve PDF oluşturma işlemini başlat
            const url = `cari_ekstre_pdf.php?cari_id=${cariId}&baslangic=${baslangic}&bitis=${bitis}`;
            window.open(url, '_blank');
        }
    </script>
</body>
</html>
