<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/log_fonksiyonlari.php';
require_once __DIR__ . '/../includes/ayar_fonksiyonlari.php';
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php';
yetkili_mi();

global $db;

$sayfa_baslik = __('debit_customer');
$paraBirimi = getFirmaPara();

// Şirketin para birimi ayarlarını kontrol et
try {
    $stmt_sirket = $db->prepare("SELECT coklu_para_birimi, para_birimi FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$_SESSION['aktif_sirket_id']]);
    $sirket_ayarlari = $stmt_sirket->fetch(PDO::FETCH_ASSOC);
    $coklu_para_birimi_aktif = $sirket_ayarlari['coklu_para_birimi'] ?? 0;
    $sirket_para_birimi = $sirket_ayarlari['para_birimi'] ?? 'TL';
} catch (PDOException $e) {
    error_log("Şirket ayarları çekilemedi: " . $e->getMessage());
    $coklu_para_birimi_aktif = 0;
    $sirket_para_birimi = 'TL';
}

// Döviz kurlarını veritabanından çek
try {
    $stmt_doviz = $db->prepare("SELECT para_birimi, alis, satis, guncelleme_tarihi FROM doviz_kurlari ORDER BY id");
    $stmt_doviz->execute();
    $doviz_kurlari = $stmt_doviz->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    error_log('Döviz kurları çekilemedi: ' . $e->getMessage());
    $doviz_kurlari = [];
}

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = "Geçersiz form gönderimi!";
        header("Location: cari_borclandir.php");
        exit();
    }

    // Form verilerini al
    $cari_id = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);
    $kategori_id = filter_input(INPUT_POST, 'kategori_id', FILTER_VALIDATE_INT);
    $tarih = filter_input(INPUT_POST, 'tarih', FILTER_SANITIZE_SPECIAL_CHARS);
    $vade_tarihi = filter_input(INPUT_POST, 'vade_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
    $pesin_odendi = isset($_POST['pesin_odendi']) && $_POST['pesin_odendi'] == '1';
    $hesap_id = filter_input(INPUT_POST, 'hesap_id', FILTER_VALIDATE_INT);
    $odeme_tarihi = filter_input(INPUT_POST, 'odeme_tarihi', FILTER_SANITIZE_SPECIAL_CHARS);
    $fatura_para_birimi = temizle($_POST['fatura_para_birimi'] ?? 'TL');
    // Kalem kalem girişleri al
    $aciklamalar = $_POST['aciklama'] ?? [];
    $tutarlar = $_POST['tutar'] ?? [];
    $birlesik_aciklama = '';
    $toplam_tutar = 0;

    if (is_array($aciklamalar) && is_array($tutarlar)) {
        foreach ($tutarlar as $index => $tutar) {
            $tutar_float = filter_var(str_replace(',', '.', $tutar ?? '0'), FILTER_VALIDATE_FLOAT);
            $aciklama_satiri = temizle($aciklamalar[$index] ?? '');

            if ($tutar_float > 0) {
                $toplam_tutar += $tutar_float;
                // Açıklamayı, satır tutarıyla birlikte birleştir (sadece tutar, para birimi yok)
                $birlesik_aciklama .= $aciklama_satiri . " (" . number_format($tutar_float, 2, ',', '.') . ")\n";
            }
        }
    }
    $birlesik_aciklama = trim($birlesik_aciklama);
    $toplam_kdv = 0; // Stoksuz işlemlerde KDV hesaplaması yapılmaz

    $hatalar = [];
    if (empty($cari_id)) $hatalar[] = __("select_customer_required");
    if (empty($kategori_id)) $hatalar[] = __("select_category_required");
    if (empty($tarih) || !preg_match("/^\d{4}-\d{2}-\d{2}$/", $tarih)) $hatalar[] = __("valid_date_required");
    if ($toplam_tutar <= 0) $hatalar[] = __("amount_greater_than_zero");
    if ($pesin_odendi && empty($hesap_id)) $hatalar[] = __("account_required_for_cash");
    $vade_tarihi = empty($vade_tarihi) ? null : $vade_tarihi;

    if (empty($hatalar)) {
        try {
            $db->beginTransaction();

            $aktif_sirket_id = $_SESSION['aktif_sirket_id'];
            $odenen_tutar_db = $pesin_odendi ? $toplam_tutar : 0;

            // Cari borçlandırma işlemi, carinin bize borçlanmasıdır, bu nedenle 'satis' olarak kaydedilir.
            $fatura_para_birimi = ($fatura_para_birimi === 'TL') ? 'TRY' : $fatura_para_birimi;
            $stmt_borc = $db->prepare("INSERT INTO borclar
                (sirket_id, cari_id, tur, kategori_id, tutar, toplam_kdv, indirim_tutari, odenen_tutar, aciklama, tarih, vade_tarihi, stoklu_islem, olusturulma_tarihi, para_birimi)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, NOW(), ?)");
            $stmt_borc->execute([$aktif_sirket_id, $cari_id, 'satis', $kategori_id, $toplam_tutar, $toplam_kdv, 0, $odenen_tutar_db, $birlesik_aciklama, $tarih, $vade_tarihi, $fatura_para_birimi]);
            $borc_id = $db->lastInsertId();

            // Cari bakiyesini güncelle (carinin bize olan borcu artıyor)
            if (!cariBakiyeGuncelle($db, $cari_id, $toplam_tutar, 0.0)) {
                throw new Exception("Cari bakiyesi güncellenemedi.");
            }

            // Log kaydı
            sistem_log_ekle($db, 'ekle', 'borclar', $borc_id, null, null, "Cari borçlandırma (satış) işlemi yapıldı. Tutar: " . number_format($toplam_tutar, 2) . " " . $paraBirimi);

            if ($pesin_odendi) {
                // Peşin ödeme alındıysa, kasaya para girişi olur.
                $stmt_odeme = $db->prepare("INSERT INTO hesap_hareketleri
                    (sirket_id, hesap_id, cari_id, borc_id, tur, tutar, aciklama, tarih)
                    VALUES (?, ?, ?, ?, 'giris', ?, ?, ?)");
                $stmt_odeme->execute([$aktif_sirket_id, $hesap_id, $cari_id, $borc_id, $toplam_tutar, "Cari borçlandırma peşin tahsilatı", $odeme_tarihi]);

                // Peşin ödeme alındığında cari bakiyesini güncelle (ödeme işlemi için)
                // Carinin bize olan borcu azalıyor çünkü peşin ödeme aldık
                if (!cariBakiyeGuncelle($db, $cari_id, -$toplam_tutar, 0.0)) {
                    throw new Exception("Peşin ödeme sonrası cari bakiyesi güncellenemedi.");
                }
            }

            $db->commit();
            $_SESSION['basarili'] = __("debit_saved_success");
            header("Location: borc_detay.php?id=" . $borc_id);
            exit();

        } catch (Exception $e) {
            $db->rollBack();
            $_SESSION['hata'] = __("failed_to_save_debit") . ": " . $e->getMessage();
        }
    } else {
        $_SESSION['hata'] = implode("<br>", $hatalar);
    }
}

// CSRF token oluştur
$csrf_token = csrf_token_olustur();

// Kategorileri getir
$stmt_kategoriler = $db->prepare("SELECT id, kategori_adi FROM kategoriler WHERE sirket_id = ? AND tip = 'islem' ORDER BY kategori_adi");
$stmt_kategoriler->execute([$_SESSION['aktif_sirket_id']]);
$kategoriler = $stmt_kategoriler->fetchAll(PDO::FETCH_ASSOC);

// Carileri getir
$stmt_cariler = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE sirket_id = ? ORDER BY ad_soyad");
$stmt_cariler->execute([$_SESSION['aktif_sirket_id']]);
$cariler = $stmt_cariler->fetchAll(PDO::FETCH_ASSOC);

// URL'den cari_id parametresini al
$selected_cari_id = filter_input(INPUT_GET, 'cari_id', FILTER_VALIDATE_INT);
$selected_cari_adi = '';
if ($selected_cari_id) {
    $stmt_selected = $db->prepare("SELECT id, ad_soyad FROM cariler WHERE id = ? AND sirket_id = ?");
    $stmt_selected->execute([$selected_cari_id, $_SESSION['aktif_sirket_id']]);
    $selected_cari = $stmt_selected->fetch(PDO::FETCH_ASSOC);
    if ($selected_cari) {
        $selected_cari_adi = $selected_cari['ad_soyad'];
    }
}

// Hesapları getir
$stmt_hesaplar = $db->prepare("SELECT id, hesap_adi FROM hesaplar WHERE sirket_id = ? ORDER BY hesap_adi");
$stmt_hesaplar->execute([$_SESSION['aktif_sirket_id']]);
$hesaplar = $stmt_hesaplar->fetchAll(PDO::FETCH_ASSOC);

?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odjoo Yönetim - <?= temizle($sayfa_baslik) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        .hidden { display: none !important; }
        .toplam-alan { background: #fff3cd; border: 1px solid #ffeeba; border-radius: 0.375rem; }
        .is-invalid { border-color: #dc3545 !important; }
    </style>
</head>
<body>
    <?php include __DIR__ . '/../includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
            <div class="card shadow-sm">
                <div class="card-header bg-danger text-white">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-arrow-down-circle me-2"></i><?= $sayfa_baslik ?>
                    </h5>
                </div>
                <div class="card-body">
                    <form method="POST" id="cariBorclandirForm">
                        <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="cari_arama" class="form-label"><?= __('customer') ?> *</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="cari_arama" placeholder="<?= __('search') ?>..." autocomplete="off" value="<?= temizle($selected_cari_adi) ?>">
                                        <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#yeniCariModal"><i class="bi bi-plus-circle"></i></button>
                                    </div>
                                    <div id="cariSonuclar" class="list-group position-absolute w-100 shadow-sm" style="z-index: 1000; display: none; max-height: 200px; overflow-y: auto;"></div>
                                    <input type="hidden" id="cari_id" name="cari_id" required value="<?= $selected_cari_id ?>">
                                    <div id="seciliCari" class="form-text mt-2">
                                        <?php if ($selected_cari_adi): ?>
                                            <span class="badge bg-primary"><?= temizle($selected_cari_adi) ?> <i class="bi bi-check-circle-fill ms-1"></i></span>
                                        <?php else: ?>
                                            <span class="text-muted"><?= __('not_selected') ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="kategori_id" class="form-label"><?= __('category') ?> *</label>
                                    <select class="form-select" id="kategori_id" name="kategori_id" required>
                                        <option value=""><?= __('select_category') ?></option>
                                        <?php foreach ($kategoriler as $kategori): ?>
                                            <option value="<?= $kategori['id'] ?>"><?= temizle($kategori['kategori_adi']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tarih" class="form-label"><?= __('transaction_date') ?> *</label>
                                    <input type="date" class="form-control" id="tarih" name="tarih" value="<?= date('Y-m-d') ?>" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="vade_tarihi" class="form-label"><?= __('due_date') ?></label>
                                    <input type="date" class="form-control" id="vade_tarihi" name="vade_tarihi">
                                </div>
                            </div>
                        </div>

                        <!-- Dinamik Kalem Giriş Alanı -->
                        <div class="card shadow-sm mb-4">
                            <div class="card-header bg-light d-flex justify-content-between align-items-center">
                                <h5 class="mb-0"><i class="bi bi-journal-text me-2"></i><?= __('transaction_items') ?></h5>
                                <div class="d-flex align-items-center gap-2">
                                    <?php if ($coklu_para_birimi_aktif): ?>
                                        <label for="fatura_para_birimi" class="form-label mb-0 small"><?= __('invoice_currency') ?></label>
                                        <select class="form-select form-select-sm w-auto" id="fatura_para_birimi" name="fatura_para_birimi">
                                            <option value="TL"><?= __('turkish_lira') ?></option>
                                            <?php $___seen_pb = []; foreach ($doviz_kurlari as $kur): $pb = $kur['para_birimi']; if (in_array($pb, $___seen_pb)) continue; $___seen_pb[] = $pb; ?>
                                                <option value="<?= htmlspecialchars($pb) ?>" <?= ($sirket_para_birimi == $pb) ? 'selected' : '' ?>><?= htmlspecialchars($pb) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    <?php endif; ?>
                                    <button type="button" class="btn btn-sm btn-primary" id="kalemEkle"><i class="bi bi-plus-circle"></i> <?= __('add_item') ?></button>
                                </div>
                            </div>
                            <div class="card-body">
                                <div id="kalemRows">
                                    <div class="row kalem-row mb-2">
                                        <div class="col-md-7">
                                            <label class="form-label"><?= __('description') ?></label>
                                            <input type="text" class="form-control" name="aciklama[]" placeholder="<?= __('example') ?>: Danışmanlık hizmeti">
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label"><?= __('amount') ?> (<span class="para-birimi-etiketi"><?= $sirket_para_birimi ?></span>)</label>
                                            <input type="text" class="form-control tutar-input" name="tutar[]" placeholder="0,00" required>
                                        </div>
                                        <div class="col-md-1 d-flex align-items-end">
                                            <button type="button" class="btn btn-sm btn-danger kalemSil"><i class="bi bi-trash"></i> <?= __('remove') ?></button>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="row justify-content-end">
                                    <div class="col-md-5">
                                        <div class="toplam-alan p-3">
                                            <ul class="list-group">
                                                <li class="list-group-item d-flex justify-content-between align-items-center bg-light">
                                                    <strong><?= __('total') ?>:</strong> <strong id="genelToplam">0,00 <span class="para-birimi-etiketi"><?= $sirket_para_birimi ?></span></strong>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="pesin_odendi" name="pesin_odendi" value="1">
                                        <label class="form-check-label" for="pesin_odendi">
                                            <?= __('cash_payment') ?>
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3" id="hesap_secimi" style="display: none;">
                                    <label for="hesap_id" class="form-label"><?= __('payment_account') ?></label>
                                    <select class="form-select" id="hesap_id" name="hesap_id">
                                        <option value=""><?= __('select_account') ?></option>
                                        <?php foreach ($hesaplar as $hesap): ?>
                                            <option value="<?= $hesap['id'] ?>"><?= temizle($hesap['hesap_adi']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row" id="odeme_tarihi_secimi" style="display: none;">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="odeme_tarihi" class="form-label"><?= __('payment_date') ?></label>
                                    <input type="date" class="form-control" id="odeme_tarihi" name="odeme_tarihi" value="<?= date('Y-m-d') ?>">
                                </div>
                            </div>
                        </div>

                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="submit" class="btn btn-danger">
                                <i class="bi bi-save me-1"></i> <?= __('save_debit') ?>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const kalemRowsContainer = document.getElementById('kalemRows');
    const genelToplamElement = document.getElementById('genelToplam');
    const paraBirimi = "<?= $paraBirimi ?>";
    
    // Check if required elements exist
    if (!kalemRowsContainer || !genelToplamElement) {
        console.error('Required elements not found in the DOM');
        return;
    }

    function formatCurrency(value) {
        let val = parseFloat(value);
        if (isNaN(val)) val = 0;
        return val.toLocaleString('tr-TR', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
    }

    function getCurrentCurrency() {
        const faturaParaBirimi = document.getElementById('fatura_para_birimi')?.value || 'TL';
        return faturaParaBirimi === 'TRY' ? 'TL' : faturaParaBirimi; // Show TL instead of TRY
    }

    function updateCurrencyLabels() {
        const currentCurrency = getCurrentCurrency();
        // Update all currency labels
        document.querySelectorAll('.para-birimi-etiketi').forEach(etiket => {
            etiket.textContent = currentCurrency;
        });
        // Recalculate the total
        calculateTotal();
    }

    function calculateTotal() {
        let total = 0;
        kalemRowsContainer.querySelectorAll('.tutar-input').forEach(input => {
            let value = parseFloat(input.value.replace(/\./g, '').replace(',', '.')) || 0;
            total += value;
        });
        const displayCurrency = getCurrentCurrency();
        genelToplamElement.textContent = formatCurrency(total) + ' ' + displayCurrency;
    }

    function addRowListeners(row) {
        const tutarInput = row.querySelector('.tutar-input');
        const removeButton = row.querySelector('.kalemSil');
        
        if (tutarInput) {
            tutarInput.addEventListener('input', function(e) {
                let value = e.target.value.replace(/[^\d,]/g, '');
                e.target.value = value;
                calculateTotal();
            });
        }

        if (removeButton) {
            removeButton.addEventListener('click', function() {
                if (kalemRowsContainer && kalemRowsContainer.querySelectorAll('.kalem-row').length > 1) {
                    row.remove();
                    calculateTotal();
                } else {
                    alert('<?= addslashes(__('at_least_one_item_required')) ?>');
                }
            });
        }
    }

    const addKalemRowBtn = document.getElementById('kalemEkle');
    if (addKalemRowBtn && kalemRowsContainer) {
        addKalemRowBtn.addEventListener('click', function() {
            const firstRow = kalemRowsContainer.querySelector('.kalem-row');
            if (firstRow) {
                const newRow = firstRow.cloneNode(true);
                newRow.querySelectorAll('input').forEach(input => input.value = '');
                
                // Yeni satırda para birimi etiketini güncel para birimi ile güncelle
                const currentParaBirimi = document.getElementById('fatura_para_birimi')?.value || 'TL';
                const label = newRow.querySelector('.form-label');
                if (label && label.textContent.includes('Tutar (')) {
                    label.textContent = 'Tutar (' + currentParaBirimi + ')';
                }
                
                kalemRowsContainer.appendChild(newRow);
                addRowListeners(newRow);
                calculateTotal();
            }
        });
    }

    // Add event listener for currency change
    const faturaParaBirimiSelect = document.getElementById('fatura_para_birimi');
    if (faturaParaBirimiSelect) {
        faturaParaBirimiSelect.addEventListener('change', updateCurrencyLabels);
    }

    // Add event listeners to existing rows
    document.querySelectorAll('.kalem-row').forEach(row => {
        addRowListeners(row);
    });

    calculateTotal(); // Sayfa yüklendiğinde toplamı hesapla

    // Peşin ödeme kontrolü
    const pesinOdendiCheckbox = document.getElementById('pesin_odendi');
    const hesapSecimi = document.getElementById('hesap_secimi');
    const odemeTarihiSecimi = document.getElementById('odeme_tarihi_secimi');
    const hesapIdSelect = document.getElementById('hesap_id');
    const odemeTarihiInput = document.getElementById('odeme_tarihi');

    if (pesinOdendiCheckbox && hesapSecimi && odemeTarihiSecimi) {
        pesinOdendiCheckbox.addEventListener('change', function() {
            if (this.checked) {
                hesapSecimi.style.display = 'block';
                odemeTarihiSecimi.style.display = 'block';
                if (hesapIdSelect) hesapIdSelect.setAttribute('required', 'required');
                if (odemeTarihiInput) odemeTarihiInput.setAttribute('required', 'required');
            } else {
                hesapSecimi.style.display = 'none';
                odemeTarihiSecimi.style.display = 'none';
                if (hesapIdSelect) hesapIdSelect.removeAttribute('required');
                if (odemeTarihiInput) odemeTarihiInput.removeAttribute('required');
            }
        });
    }

    // Global cariSec fonksiyonu
    window.cariSec = function(id, adi) {
        document.getElementById('cari_id').value = id;
        document.getElementById('cari_arama').value = adi;
        document.getElementById('seciliCari').innerHTML = `<span class="badge bg-primary">${adi} <i class="bi bi-check-circle-fill ms-1"></i></span>`;
        document.getElementById('cariSonuclar').style.display = 'none';
    };

    // Cari arama fonksiyonları
    function cariAramaBaslat() {
        const cariArama = document.getElementById('cari_arama');
        const cariSonuclar = document.getElementById('cariSonuclar');
        if (!cariArama || !cariSonuclar) return;

        cariArama.addEventListener('input', function() {
            const arama = this.value.trim();
            if (arama.length >= 2) {
                fetch("../ajax/cari_ara_ajax.php", {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: 'arama=' + encodeURIComponent(arama)
                })
                .then(response => response.json())
                .then(data => {
                    let html = '';
                    if (data.success && data.cariler.length > 0) {
                        data.cariler.forEach(cari => {
                            const adi = cari.ad_soyad.replace(/'/g, "\\'").replace(/"/g, "&quot;");
                            html += `<a href="#" class="list-group-item list-group-item-action" onclick="event.preventDefault(); cariSec(${cari.id}, '${adi}')">${cari.ad_soyad}</a>`;
                        });
                    } else {
                        html = '<div class="list-group-item text-muted"><?= __('no_results_found') ?></div>';
                    }
                    cariSonuclar.innerHTML = html;
                    cariSonuclar.style.display = 'block';
                });
            } else {
                cariSonuclar.style.display = 'none';
            }
        });

        document.addEventListener('click', function(e) {
            if (!cariArama.contains(e.target) && !cariSonuclar.contains(e.target)) {
                cariSonuclar.style.display = 'none';
            }
        });
    }

    // Cari arama fonksiyonunu başlat
    cariAramaBaslat();
    
    // Cari ekleme işlemini AJAX ile yap
    $(function(){
        const cariEkleBtn = $('#cariEkleBtn');
        if (cariEkleBtn.length === 0) {
            console.warn('Cari ekle butonu bulunamadı');
            return;
        }
        
        cariEkleBtn.off('click').on('click', function() {
            var form = $('#yeniCariForm');
            var btn = $(this);
            btn.prop('disabled', true).html('<span class="spinner-border spinner-border-sm"></span> <?= __('saving') ?>...');
            $.ajax({
                url: '../ajax/cari_ekle_ajax.php',
                method: 'POST',
                data: form.serialize(),
                dataType: 'json',
                success: function(data) {
                    if(data.success) {
                        $('#cariEkleMessage').removeClass('d-none alert-danger').addClass('alert-success').text(data.message);
                        setTimeout(function(){
                            $('#yeniCariModal').modal('hide');
                            form[0].reset();
                            $('#cariEkleMessage').addClass('d-none');
                            // Sayfada cari arama varsa otomatik ekle
                            if ($('#cari_arama').length) {
                                $('#cari_id').val(data.id);
                                $('#cari_arama').val(data.ad_soyad);
                                $('#seciliCari').html(`<span class="badge bg-primary">${data.ad_soyad} <i class="bi bi-check-circle-fill ms-1"></i></span>`);
                                $('#cariSonuclar').hide();
                            }
                        }, 1000);
                    } else {
                        $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text(data.message);
                    }
                },
                error: function() {
                    $('#cariEkleMessage').removeClass('d-none alert-success').addClass('alert-danger').text('Bir hata oluştu.');
                },
                complete: function() {
                    btn.prop('disabled', false).html('Cari Ekle');
                }
            });
        });
    });
});
</script>

    <?php include __DIR__ . '/../includes/cari_ekle_modal.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
    <?php include __DIR__ . '/../includes/footer.php'; ?>
</body>
</html> 