<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

if(!isset($_GET['id']) || !($borc_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    $_SESSION['hata'] = "Geçersiz İşlem ID.";
     header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'index.php')); // Önceki sayfaya dön
    exit();
}

if (!isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
     $_SESSION['hata'] = "Geçersiz güvenlik tokeni!";
     header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'index.php'));
     exit();
}


try {
    $db->beginTransaction();

    // 1. Silinecek borcun (işlemin) bilgilerini al (cari_id, tutar, tur)
    $stmt = $db->prepare("SELECT cari_id, tutar, tur FROM borclar WHERE id = ?");
    $stmt->execute([$borc_id]);
    $borc = $stmt->fetch();

    if(!$borc) {
        throw new Exception("Silinecek işlem bulunamadı!");
    }

    // 2. İlgili hesap hareketlerini bul ve sil (Bu işlemle ilişkili ödemeler/tahsilatlar varsa)
    // DİKKAT: Bu adım, eğer ödeme/tahsilat yapıldıysa ve silinirse tutarsızlığa yol açar.
    // Genellikle sadece işlemin kendisi silinir, ödemeler kalır (veya manuel düzeltme gerekir).
    // Şimdilik ilişkili hesap hareketlerini silmeyelim, sadece işlemi silelim ve cari bakiyeyi düzeltelim.
    /*
    $stmt_hareket_sil = $db->prepare("DELETE FROM hesap_hareketleri WHERE borc_id = ?");
    $stmt_hareket_sil->execute([$borc_id]);
    */

     // 3. Cari bakiyesini DÜZELT (Ters işlem)
     $borc_degisim = 0.0;
     $alacak_degisim = 0.0;
     if ($borc['tur'] == 'satis') { // Satış siliniyorsa, müşterinin borcu azalır
         $borc_degisim = -$borc['tutar'];
     } elseif ($borc['tur'] == 'alis') { // Alış siliniyorsa, bizim borcumuz (tedarikçinin alacağı) azalır
         $alacak_degisim = -$borc['tutar'];
     }

     if (!cariBakiyeGuncelle($db, $borc['cari_id'], $borc_degisim, $alacak_degisim)) {
         throw new Exception("Cari bakiyesi güncellenirken hata oluştu.");
     }

    // 4. Borç (işlem) kaydını sil
    $stmt_sil = $db->prepare("DELETE FROM borclar WHERE id = ?");
    if(!$stmt_sil->execute([$borc_id])) {
         throw new Exception("İşlem kaydı silinirken hata oluştu.");
    }

    $db->commit();
    $_SESSION['mesaj'] = "İşlem (#{$borc_id}) başarıyla silindi ve cari bakiye güncellendi.";

} catch(Exception $e) {
    $db->rollBack();
    error_log("İşlem silme hatası (ID: {$borc_id}): " . $e->getMessage());
    $_SESSION['hata'] = "Silme işlemi sırasında bir hata oluştu: " . $e->getMessage();
}

// Kullanıcıyı geldiği sayfaya veya ana sayfaya yönlendir
header("Location: " . ($_SERVER['HTTP_REFERER'] ?? 'index.php'));
exit();
?>
