<?php
require_once __DIR__ . '/../includes/config.php';
yetkili_mi();

// tFPDF kütüphanesini dahil et
require_once __DIR__ . '/tfpdf/tfpdf.php';

// --- Veritabanı İşlemleri Başlangıç ---

// İşlem (Borç) ID'sini al ve doğrula
if (!isset($_GET['id']) || !($borc_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT))) {
    die("Geçersiz İşlem ID.");
}

$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? 0;
$borc = null;
$ilgili_hareketler = [];
$sirket_bilgileri = null;

try {
    // Şirket Bilgileri
    $stmt_sirket = $db->prepare("SELECT * FROM sirketler WHERE id = ?");
    $stmt_sirket->execute([$aktif_sirket_id]);
    $sirket_bilgileri = $stmt_sirket->fetch(PDO::FETCH_ASSOC);

    // Ana İşlem Bilgisi
    $stmt_borc = $db->prepare("SELECT b.*, c.ad_soyad as cari_ad_soyad, c.adres as cari_adres, c.telefon as cari_telefon FROM borclar b JOIN cariler c ON b.cari_id = c.id WHERE b.id = ? AND b.sirket_id = ?");
    $stmt_borc->execute([$borc_id, $aktif_sirket_id]);
    $borc = $stmt_borc->fetch(PDO::FETCH_ASSOC);

    if (!$borc) {
        die("İşlem bulunamadı veya bu şirkete ait değil.");
    }

    // Ödeme Hareketleri
    $stmt_hareketler = $db->prepare("SELECT hh.*, h.hesap_adi FROM hesap_hareketleri hh JOIN hesaplar h ON hh.hesap_id = h.id WHERE hh.borc_id = ? AND hh.sirket_id = ? ORDER BY hh.tarih ASC");
    $stmt_hareketler->execute([$borc_id, $aktif_sirket_id]);
    $ilgili_hareketler = $stmt_hareketler->fetchAll(PDO::FETCH_ASSOC);

    // Ödenen tutarı hesapla
    $odenen_tutar = 0;
    foreach($ilgili_hareketler as $hareket) {
        $odenen_tutar += $hareket['tutar'];
    }
    $kalan_tutar = ($borc['tutar'] - $borc['indirim_tutari']) - $odenen_tutar;

} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// --- Veritabanı İşlemleri Bitiş ---


// --- PDF Sınıfı ve Oluşturma Başlangıç ---

class PDF_Invoice extends tFPDF
{
    public $sirket_bilgileri;

    // Sayfa başlığı (Header)
    function Header()
    {
        if (!empty($this->sirket_bilgileri)) {
            $this->SetFont('DejaVu', 'B', 16);
            $this->Cell(0, 10, $this->sirket_bilgileri['sirket_adi'], 0, 1, 'C');
            $this->SetFont('DejaVu', '', 9);
            $this->Cell(0, 5, 'Fatura Detayı', 0, 1, 'C');
            $this->Ln(5);
        }
    }

    // Sayfa altlığı (Footer)
    function Footer()
    {
        if (!empty($this->sirket_bilgileri)) {
            $this->SetY(-20); // Alttan 2 cm yukarıda başla
            $this->SetDrawColor(150, 150, 150);
            $this->Cell(0, 5, '', 'T', 1, 'C'); // Üst çizgi
            $this->SetFont('DejaVu', '', 8);

            $adres = $this->sirket_bilgileri['adres'] ?? '';
            $telefon = $this->sirket_bilgileri['telefon'] ?? '';
            $email = $this->sirket_bilgileri['email'] ?? '';

            $footer_text = trim("$adres | Tel: $telefon | E-posta: $email", ' |');
            $this->Cell(0, 5, $footer_text, 0, 1, 'C');
            $this->Cell(0, 5, 'Sayfa ' . $this->PageNo() . '/{nb}', 0, 0, 'C');
        }
    }
}

// PDF nesnesini oluştur
$pdf = new PDF_Invoice();
$pdf->sirket_bilgileri = $sirket_bilgileri;

// Türkçe karakterler için font ekle
$pdf->AddFont('DejaVu', '', 'DejaVuSans.ttf', true);
$pdf->AddFont('DejaVu', 'B', 'DejaVuSans-Bold.ttf', true);

$pdf->AliasNbPages(); // Toplam sayfa sayısını hesaplamak için
$pdf->AddPage();

// Ana Başlık
$pdf->SetFont('DejaVu', 'B', 20);
$pdf->Cell(0, 10, strtoupper($borc['tur'] == 'satis' ? 'SATIŞ FATURASI' : 'ALIŞ FATURASI'), 0, 1, 'C');
$pdf->Ln(5);

// Şirket ve Cari Bilgileri
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(95, 7, 'SATICI BİLGİLERİ', 0, 0);
$pdf->Cell(95, 7, 'ALICI BİLGİLERİ', 0, 1);

$pdf->SetFont('DejaVu', '', 10);
$satici = $borc['tur'] == 'satis' ? $sirket_bilgileri : ['ad_soyad' => $borc['cari_ad_soyad'], 'adres' => $borc['cari_adres'], 'telefon' => $borc['cari_telefon']];
$alici = $borc['tur'] == 'satis' ? ['ad_soyad' => $borc['cari_ad_soyad'], 'adres' => $borc['cari_adres'], 'telefon' => $borc['cari_telefon']] : $sirket_bilgileri;

$pdf->Cell(95, 6, $satici['sirket_adi'] ?? $satici['ad_soyad'], 0, 0);
$pdf->Cell(95, 6, $alici['sirket_adi'] ?? $alici['ad_soyad'], 0, 1);
$pdf->Cell(95, 6, $satici['adres'] ?? '', 0, 0);
$pdf->Cell(95, 6, $alici['adres'] ?? '', 0, 1);
$pdf->Cell(95, 6, $satici['telefon'] ?? '', 0, 0);
$pdf->Cell(95, 6, $alici['telefon'] ?? '', 0, 1);
$pdf->Cell(95, 6, $satici['email'] ?? '', 0, 0);
$pdf->Cell(95, 6, $alici['email'] ?? '', 0, 1);
$pdf->Ln(10);

// Fatura Detayları
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'Fatura No:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(55, 7, $borc['id'], 1, 0);
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'İşlem Tarihi:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(55, 7, date('d.m.Y', strtotime($borc['tarih'])), 1, 1);

$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(40, 7, 'Vade Tarihi:', 1, 0);
$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(55, 7, $borc['vade_tarihi'] ? date('d.m.Y', strtotime($borc['vade_tarihi'])) : '-', 1, 1);
$pdf->Ln(10);

// Fatura Kalemleri
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(0, 10, 'FATURA KALEMLERİ', 0, 1);
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(130, 7, 'Açıklama', 1, 0, 'C');
$pdf->Cell(60, 7, 'Tutar', 1, 1, 'C');

$pdf->SetFont('DejaVu', '', 10);
$pdf->Cell(130, 7, $borc['aciklama'] ?: 'Genel ' . ($borc['tur'] == 'satis' ? 'Satış' : 'Alış') . ' İşlemi', 1, 0);
$pdf->Cell(60, 7, number_format($borc['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->Ln(10);

// Toplamlar
$pdf->SetFont('DejaVu', 'B', 10);
$pdf->Cell(130, 7, 'Ara Toplam', 0, 0, 'R');
$pdf->Cell(60, 7, number_format($borc['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->Cell(130, 7, 'İndirim', 0, 0, 'R');
$pdf->Cell(60, 7, number_format($borc['indirim_tutari'], 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(130, 8, 'GENEL TOPLAM', 0, 0, 'R');
$pdf->Cell(60, 8, number_format($borc['tutar'] - $borc['indirim_tutari'], 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->Ln(5);
$pdf->Cell(130, 7, 'Ödenen Tutar', 0, 0, 'R');
$pdf->Cell(60, 7, number_format($odenen_tutar, 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->SetFont('DejaVu', 'B', 12);
$pdf->Cell(130, 8, 'KALAN TUTAR', 0, 0, 'R');
$pdf->Cell(60, 8, number_format($kalan_tutar, 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
$pdf->Ln(10);

// Ödeme Hareketleri
if (!empty($ilgili_hareketler)) {
    $pdf->SetFont('DejaVu', 'B', 12);
    $pdf->Cell(0, 10, 'ÖDEME GEÇMİŞİ', 0, 1);
    $pdf->SetFont('DejaVu', 'B', 10);
    $pdf->Cell(40, 7, 'Tarih', 1, 0, 'C');
    $pdf->Cell(90, 7, 'Hesap', 1, 0, 'C');
    $pdf->Cell(60, 7, 'Tutar', 1, 1, 'C');

    $pdf->SetFont('DejaVu', '', 10);
    foreach ($ilgili_hareketler as $hareket) {
        $pdf->Cell(40, 7, date('d.m.Y', strtotime($hareket['tarih'])), 1, 0);
        $pdf->Cell(90, 7, $hareket['hesap_adi'], 1, 0);
        $pdf->Cell(60, 7, number_format($hareket['tutar'], 2, ',', '.') . ' ' . getParaBirimiSembolu($borc['para_birimi'] ?? null), 1, 1, 'R');
    }
}

$pdf->Output('I', 'fatura-' . $borc_id . '.pdf');

// --- PDF Sınıfı ve Oluşturma Bitiş ---
?>
