<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar (config, yetki, yardımcı fonksiyonlar, log fonksiyonları)
// zaten ana ayarlar.php'de yapılmış olacaktır.
// Bu yüzden burada ek require_once gerekmez.

$yetki_seviyesi_messages = [];
$yetki_seviyesi_errors = [];
$edit_group = null; // Düzenlenecek grup bilgisi

// Yönetilebilir Yetkiler (yetki_kontrol.php'den türetilmiştir, kullanıcı dostu isimlerle)
// Bu liste, yetki_gruplari tablosundaki "yetkiler" JSON'una karşılık gelen anahtarları içermelidir.
$available_permissions = [
    'stok_yonetimi' => __('stock_management'),
    'stok_goruntuleme' => __('stock_viewing'),
    'satis_islemleri' => __('sales_operations'),
    'alis_islemleri' => __('purchase_operations'),
    'teklif_yonetimi' => __('quote_management'),
    'cari_yonetimi' => __('customer_management'),
    'cari_goruntuleme' => __('customer_viewing'),
    'hesap_yonetimi' => __('account_management'),
    'raporlar' => __('view_reports'),
    'faturalar' => __('view_invoices'),
    'kullanici_yonetimi' => __('user_management'),
    'log_goruntuleme' => __('view_logs'),
    'genel_ayarlar' => __('access_general_settings'),
    'admin_yetkiler' => __('all_admin_privileges')
];


// Yetki Grubu Ekleme/Düzenleme İşlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['yetki_grubu_ekle']) || isset($_POST['yetki_grubu_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $grup_adi = temizle($_POST['grup_adi']);
        $aciklama = temizle($_POST['aciklama']);
        $aktif = isset($_POST['aktif']) ? 1 : 0;
        $selected_yetkiler = [];

        foreach ($available_permissions as $key => $value) {
            if (isset($_POST['yetki_' . $key])) {
                $selected_yetkiler[$key] = true;
            }
        }
        $yetkiler_json = json_encode($selected_yetkiler, JSON_UNESCAPED_UNICODE);

        if (empty($grup_adi)) {
            $_SESSION['hata'] = __("group_name_cannot_be_empty");
        } else {
            try {
                $db->beginTransaction();

                if (isset($_POST['yetki_grubu_ekle'])) {
                    // Ekleme işlemi
                    $stmt_check = $db->prepare("SELECT COUNT(*) FROM yetki_gruplari WHERE grup_adi = ?");
                    $stmt_check->execute([$grup_adi]);
                    if ($stmt_check->fetchColumn() > 0) {
                        throw new Exception(__("group_name_already_exists"));
                    }

                    $stmt = $db->prepare("INSERT INTO yetki_gruplari (grup_adi, aciklama, yetkiler, aktif) VALUES (?, ?, ?, ?)");
                    $stmt->execute([$grup_adi, $aciklama, $yetkiler_json, $aktif]);
                    $eklenen_grup_id = $db->lastInsertId();

                    // Loglama: Yetki Grubu Ekleme
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'yetki_gruplari',
                        $eklenen_grup_id,
                        null,
                        ['grup_adi' => $grup_adi, 'aciklama' => $aciklama, 'yetkiler' => $selected_yetkiler, 'aktif' => $aktif],
                        'Yeni yetki grubu eklendi: ' . $grup_adi
                    );
                    $_SESSION['mesaj'] = __("permission_group_added_successfully");

                } elseif (isset($_POST['yetki_grubu_guncelle'])) {
                    // Düzenleme işlemi
                    $group_id = (int)$_POST['group_id'];
                    $stmt_old = $db->prepare("SELECT * FROM yetki_gruplari WHERE id = ?");
                    $stmt_old->execute([$group_id]);
                    $old_group_data = $stmt_old->fetch(PDO::FETCH_ASSOC);

                    if (!$old_group_data) {
                        throw new Exception(__("group_to_edit_not_found"));
                    }

                    $stmt_check = $db->prepare("SELECT COUNT(*) FROM yetki_gruplari WHERE grup_adi = ? AND id != ?");
                    $stmt_check->execute([$grup_adi, $group_id]);
                    if ($stmt_check->fetchColumn() > 0) {
                        throw new Exception(__("group_name_already_used"));
                    }

                    $stmt = $db->prepare("UPDATE yetki_gruplari SET grup_adi = ?, aciklama = ?, yetkiler = ?, aktif = ? WHERE id = ?");
                    $stmt->execute([$grup_adi, $aciklama, $yetkiler_json, $aktif, $group_id]);

                    // Loglama: Yetki Grubu Güncelleme
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'yetki_gruplari',
                        $group_id,
                        $old_group_data,
                        ['grup_adi' => $grup_adi, 'aciklama' => $aciklama, 'yetkiler' => $selected_yetkiler, 'aktif' => $aktif],
                        'Yetki grubu güncellendi: ' . $grup_adi
                    );
                    $_SESSION['mesaj'] = __("permission_group_updated_successfully");
                }

                $db->commit();

            } catch (Exception $e) {
                $db->rollBack();
                error_log("Yetki grubu işlemi hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
}

// Yetki Grubu Silme İşlemi
if (isset($_GET['sil'])) {
    if (!csrf_token_dogrula($_GET['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $id = (int)$_GET['sil'];
        
        try {
            // Silinecek grubun bilgilerini al
            $stmt_grup_info = $db->prepare("SELECT * FROM yetki_gruplari WHERE id = ?");
            $stmt_grup_info->execute([$id]);
            $silinecek_grup_bilgisi = $stmt_grup_info->fetch(PDO::FETCH_ASSOC);

            if (!$silinecek_grup_bilgisi) {
                throw new Exception("Yetki grubu bulunamadı.");
            }

            // Grup kullanımda mı kontrol et (kullanicilar.yetki_seviyesi veya yetkiler'de)
            // Enum yetki seviyeleri ile çakışan grupları silmeyi engelle
            $enum_yetki_seviyeleri = ['admin', 'yonetici', 'kullanici', 'misafir'];
            if (in_array(strtolower($silinecek_grup_bilgisi['grup_adi']), $enum_yetki_seviyeleri)) {
                 throw new Exception("Sistem tarafından kullanılan varsayılan yetki seviyesi grupları silinemez.");
            }
            
            // Eğer herhangi bir kullanıcının yetki_seviyesi bu grupla eşleşiyorsa silmeyi engelle
            $stmt_kullanici_kontrol = $db->prepare("SELECT COUNT(*) FROM kullanicilar WHERE yetki_seviyesi = ?");
            $stmt_kullanici_kontrol->execute([strtolower($silinecek_grup_bilgisi['grup_adi'])]);
            if ($stmt_kullanici_kontrol->fetchColumn() > 0) {
                 throw new Exception("Bu yetki grubunu kullanan kullanıcılar olduğu için silinemez.");
            }


            $db->beginTransaction();

            $stmt = $db->prepare("DELETE FROM yetki_gruplari WHERE id = ?");
            $stmt->execute([$id]);

            // Loglama: Yetki Grubu Silme
            $log_id = sistem_log_ekle(
                $db,
                'sil',
                'yetki_gruplari',
                $id,
                $silinecek_grup_bilgisi,
                null,
                'Yetki grubu silindi: ' . $silinecek_grup_bilgisi['grup_adi']
            );

            // Silinen kaydı geri alma tablosuna ekle
            if ($log_id) {
                silinen_kayit_ekle($db, $log_id, 'yetki_gruplari', $id, $silinecek_grup_bilgisi);
            }
            
            $db->commit();
            $_SESSION['mesaj'] = "Yetki grubu başarıyla silindi.";
        } catch (Exception $e) {
            $db->rollBack();
            error_log("Yetki grubu silme hatası: " . $e->getMessage());
            $_SESSION['hata'] = $e->getMessage();
        }
    }
    // header("Location: ?section=yetki_seviyeleri");
    // exit();
}

// Düzenleme formu için grup bilgilerini çek
if (isset($_GET['duzenle'])) {
    $edit_group_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT * FROM yetki_gruplari WHERE id = ?");
        $stmt->execute([$edit_group_id]);
        $edit_group = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($edit_group) {
            $edit_group['yetkiler'] = json_decode($edit_group['yetkiler'], true);
        } else {
            $_SESSION['hata'] = "Düzenlenecek yetki grubu bulunamadı.";
            // header("Location: ?section=yetki_seviyeleri");
            // exit();
        }
    } catch (PDOException $e) {
        error_log("Yetki grubu düzenleme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_group_info");
        // header("Location: ?section=yetki_seviyeleri");
        // exit();
    }
}


// Yetki Gruplarını Listele
$yetki_gruplari = [];
try {
    $stmt = $db->query("SELECT * FROM yetki_gruplari ORDER BY grup_adi");
    $yetki_gruplari = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Yetki grupları listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_permission_groups");
}

// CSRF token ana sayfadan geliyor, burada kullanıma hazır.
?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <?= $_SESSION['mesaj'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['mesaj']); ?>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= $_SESSION['hata'] ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    <?php unset($_SESSION['hata']); ?>
<?php endif; ?>

    <div class="card-header">
	<h3 class="mb-4"><i class="bi bi-tags-fill me-2"></i><?= __("permission_levels_management") ?></h3>
    </div>
    <div class="card-body">
        <div class="card mb-4">
            <div class="card-header bg-<?= $edit_group ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0">
                    <i class="bi bi-<?= $edit_group ? 'pencil' : 'plus-circle' ?> me-2"></i> 
                    <?= $edit_group ? __('edit_permission_group') . ': ' . temizle($edit_group['grup_adi']) : __('add_new_permission_group') ?>
                </h5>
            </div>
            <div class="card-body">
                <form method="post" action="?section=yetki_seviyeleri">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($edit_group): ?>
                        <input type="hidden" name="group_id" value="<?= $edit_group['id'] ?>">
                    <?php endif; ?>

                    <div class="mb-3">
                        <label for="grup_adi" class="form-label"><?= __("group_name") ?></label>
                        <input type="text" class="form-control" id="grup_adi" name="grup_adi" 
                               value="<?= temizle($edit_group['grup_adi'] ?? '') ?>" required>
                    </div>
                    <div class="mb-3">
                        <label for="aciklama" class="form-label"><?= __("description") ?></label>
                        <textarea class="form-control" id="aciklama" name="aciklama" rows="2"><?= temizle($edit_group['aciklama'] ?? '') ?></textarea>
                    </div>

                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" id="aktif" name="aktif" value="1" 
                               <?= ($edit_group['aktif'] ?? 1) ? 'checked' : '' ?>>
                        <label class="form-check-label" for="aktif"><?= __("active") ?></label>
                    </div>

                    <h6 class="mt-4 mb-3"><?= __("group_permissions") ?></h6>
                    <div class="row">
                        <?php foreach ($available_permissions as $key => $description): ?>
                        <div class="col-md-6 col-lg-6 mb-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="yetki_<?= $key ?>" id="yetki_<?= $key ?>" 
                                       value="1" <?= ($edit_group && isset($edit_group['yetkiler'][$key]) && $edit_group['yetkiler'][$key]) ? 'checked' : '' ?>>
                                <label class="bi bi-tags me-2 form-check-label" for="yetki_<?= $key ?>">
                                    <?= temizle($description) ?>
                                </label>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>

                    <hr>
                    <?php if ($edit_group): ?>
                        <button type="submit" name="yetki_grubu_guncelle" class="btn btn-warning">
                            <i class="bi bi-pencil me-2"></i> <?= __("update_group") ?>
                        </button>
                        <a href="?section=yetki_seviyeleri" class="btn btn-secondary ms-2">
                            <i class="bi bi-x-circle me-2"></i> <?= __("cancel") ?>
                        </a>
                    <?php else: ?>
                        <button type="submit" name="yetki_grubu_ekle" class="btn btn-success">
                            <i class="bi bi-plus-circle me-2"></i> <?= __("add_group") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0"><i class="bi bi-list-ul me-2"></i> <?= __("existing_permission_groups") ?></h5>
            </div>
            <div class="card-body p-0">
                <?php if (!empty($yetki_gruplari)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <th><?= __("group_name") ?></th>
                                    <th><?= __("description") ?></th>
                                    <th><?= __("permissions") ?></th>
                                    <th><?= __("status") ?></th>
                                    <th style="width: 150px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($yetki_gruplari as $grup): ?>
                                    <tr>
                                        <td><?= temizle($grup['grup_adi']) ?></td>
                                        <td><?= temizle($grup['aciklama']) ?></td>
                                        <td>
                                            <?php 
                                            $yetkiler_arr = json_decode($grup['yetkiler'], true);
                                            if (!empty($yetkiler_arr)): ?>
                                                <?php foreach ($yetkiler_arr as $yetki_key => $is_enabled): ?>
                                                    <?php if ($is_enabled && isset($available_permissions[$yetki_key])): ?>
                                                        <span class="badge bg-primary me-1 mb-1"><?= temizle($available_permissions[$yetki_key]) ?></span>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <span class="text-muted"><?= __("no_permissions_defined") ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?= $grup['aktif'] ? '<span class="badge bg-success">'.__("active").'</span>' : '<span class="badge bg-danger">'.__("passive").'</span>' ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="?section=yetki_seviyeleri&duzenle=<?= $grup['id'] ?>" 
                                                   class="btn btn-outline-primary" 
                                                   title="<?= __("edit") ?>">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                                <a href="?section=yetki_seviyeleri&sil=<?= $grup['id'] ?>&csrf_token=<?= $csrf_token ?>" 
                                                   class="btn btn-outline-danger" 
                                                   title="<?= __("delete") ?>" 
                                                   onclick="return confirm('<?= addslashes(__("confirm_delete_group")) ?>')">
                                                    <i class="bi bi-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info m-3" role="alert">
                        <?= __("no_permission_groups_added") ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
