<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/yetki_kontrol.php';
yetki_kontrol_ve_yonlendir('ayarlar', 'sil');

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Gerekli parametreleri ve güvenlik tokenını kontrol et
$raf_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$raf_id || !isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
    $_SESSION['hata'] = __("invalid_request_or_token");
    header("Location: ../ayarlar.php?section=raflar");
    exit();
}

try {
    // 1. Rafın varlığını ve şirkete ait olduğunu doğrula
    $stmt_check_owner = $db->prepare("SELECT COUNT(*) FROM raflar WHERE id = ? AND sirket_id = ?");
    $stmt_check_owner->execute([$raf_id, $aktif_sirket_id]);
    if ($stmt_check_owner->fetchColumn() == 0) {
        throw new Exception(__("shelf_not_found"));
    }

    // 2. Bu rafın herhangi bir ürün tarafından kullanılıp kullanılmadığını kontrol et
    $stmt_check_usage = $db->prepare("SELECT COUNT(*) FROM urun_depo_raf WHERE raf_id = ? AND sirket_id = ?");
    $stmt_check_usage->execute([$raf_id, $aktif_sirket_id]);
    if ($stmt_check_usage->fetchColumn() > 0) {
        throw new Exception(__("shelf_in_use"));
    }
    
    // 3. Hiçbir yerde kullanılmıyorsa sil
    // Önce raf bilgilerini al (geri alma için)
    $stmt_raf = $db->prepare("SELECT * FROM raflar WHERE id = ? AND sirket_id = ?");
    $stmt_raf->execute([$raf_id, $aktif_sirket_id]);
    $raf = $stmt_raf->fetch(PDO::FETCH_ASSOC);
    
    // Rafı sil
    $stmt_delete = $db->prepare("DELETE FROM raflar WHERE id = ? AND sirket_id = ?");
    $stmt_delete->execute([$raf_id, $aktif_sirket_id]);

    if ($stmt_delete->rowCount() > 0) {
        // Silinen kaydı logla ve geri alma için sakla
        $log_id = sistem_log_ekle($db, 'sil', 'raflar', $raf_id, $raf, null, __('shelf_deleted_successfully') . ': ' . $raf['raf_adi']);
        if ($log_id) {
            silinen_kayit_ekle($db, $log_id, 'raflar', $raf_id, $raf);
        }
        $_SESSION['mesaj'] = __("shelf_deleted_successfully");
    } else {
        throw new Exception(__("shelf_not_found"));
    }

} catch (Exception $e) {
    error_log("Raf silme hatası: " . $e->getMessage());
    $_SESSION['hata'] = $e->getMessage();
}

// Sonuç ne olursa olsun ana sayfaya geri dön
header("Location: ../ayarlar.php?section=raflar");
exit();
?>
