<?php
/**
 * KDV Hesaplama Ayarları
 * 
 * Kullanıcı fiyatları KDV dahil mi yoksa KDV hariç mi girecek?
 * 
 * @package Odjoo
 * @version 2.0.0
 */

require_once __DIR__ . '/../../includes/config.php';
yetkili_mi();

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];
$sayfa_baslik = "KDV Hesaplama Ayarları";

// Mevcut ayarı al
$stmt = $db->prepare("SELECT ayar_degeri FROM ayarlar 
                      WHERE ayar_adi = 'kdv_hesaplama_tipi' 
                      AND sirket_id = ?");
$stmt->execute([$aktif_sirket_id]);
$mevcut_tip = $stmt->fetchColumn() ?: 'kdv_haric';

// Form gönderimi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
        header("Location: kdv_ayarlari.php");
        exit();
    }
    
    $yeni_tip = $_POST['kdv_hesaplama_tipi'] ?? 'kdv_haric';
    
    if (!in_array($yeni_tip, ['kdv_haric', 'kdv_dahil'])) {
        $_SESSION['hata'] = "Geçersiz KDV modu.";
        header("Location: kdv_ayarlari.php");
        exit();
    }
    
    try {
        // Güncelle veya ekle
        $stmt = $db->prepare("INSERT INTO ayarlar 
            (ayar_adi, ayar_degeri, sirket_id, aciklama) 
            VALUES ('kdv_hesaplama_tipi', ?, ?, 'KDV hesaplama modu')
            ON DUPLICATE KEY UPDATE ayar_degeri = ?");
        $stmt->execute([$yeni_tip, $aktif_sirket_id, $yeni_tip]);
        
        // Log ekle
        require_once __DIR__ . '/../../functions/log_fonksiyonlari.php';
        sistem_log_ekle(
            $db, 
            'Ayar Değişikliği', 
            'ayarlar', 
            null, 
            $aktif_sirket_id, 
            ['eski' => $mevcut_tip, 'yeni' => $yeni_tip],
            "KDV hesaplama modu değiştirildi: {$mevcut_tip} → {$yeni_tip}"
        );
        
        $_SESSION['mesaj'] = "KDV ayarları başarıyla güncellendi.";
        header("Location: kdv_ayarlari.php");
        exit();
    } catch (PDOException $e) {
        $_SESSION['hata'] = "Ayar kaydedilemedi: " . $e->getMessage();
        header("Location: kdv_ayarlari.php");
        exit();
    }
}

include __DIR__ . '/../../includes/navbar.php';
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="bi bi-calculator"></i> <?= __('vat_calculation_settings') ?>
                        </h4>
                        <a href="../ayarlar.php" class="btn btn-light btn-sm">
                            <i class="bi bi-arrow-left"></i> <?= __('back') ?>
                        </a>
                    </div>
                </div>
                
                <div class="card-body p-4">
                    <?php if (isset($_SESSION['mesaj'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="bi bi-check-circle-fill me-2"></i>
                            <?= $_SESSION['mesaj'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['mesaj']); ?>
                    <?php endif; ?>
                    
                    <?php if (isset($_SESSION['hata'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="bi bi-exclamation-triangle-fill me-2"></i>
                            <?= $_SESSION['hata'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['hata']); ?>
                    <?php endif; ?>
                    
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle me-2"></i> 
                        <strong>Önemli:</strong> Bu ayar tüm yeni fiyat girişlerinizi etkiler. 
                        Değiştirdikten sonra eski faturalar etkilenmez.
                    </div>
                    
                    <form method="POST" class="mt-4">
                        <input type="hidden" name="csrf_token" value="<?= csrf_token_olustur() ?>">
                        
                        <div class="mb-4">
                            <h5 class="mb-3">KDV Hesaplama Modu Seçin:</h5>
                            
                            <!-- KDV Hariç Seçeneği -->
                            <div class="form-check mb-4 p-4 border rounded <?= $mevcut_tip === 'kdv_haric' ? 'border-primary bg-light' : '' ?>">
                                <input class="form-check-input" type="radio" name="kdv_hesaplama_tipi" 
                                       id="kdv_haric" value="kdv_haric" 
                                       <?= $mevcut_tip === 'kdv_haric' ? 'checked' : '' ?>
                                       style="width: 20px; height: 20px;">
                                <label class="form-check-label w-100 ms-2" for="kdv_haric" style="cursor: pointer;">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-grow-1">
                                            <h5 class="mb-2">
                                                <i class="bi bi-plus-circle text-primary me-2"></i>
                                                Fiyatları KDV Hariç Gireceğim
                                            </h5>
                                            <p class="text-muted mb-2">
                                                Girdiğiniz fiyata KDV eklenir. Bu en yaygın kullanılan yöntemdir.
                                            </p>
                                            <div class="bg-white p-3 rounded border">
                                                <strong>Örnek:</strong><br>
                                                <span class="text-primary">100,00 TL</span> (girdiğiniz fiyat) 
                                                + <span class="text-success">20,00 TL</span> (%20 KDV) 
                                                = <strong>120,00 TL</strong> (müşteriye yansıyan)
                                            </div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                            
                            <!-- KDV Dahil Seçeneği -->
                            <div class="form-check mb-4 p-4 border rounded <?= $mevcut_tip === 'kdv_dahil' ? 'border-primary bg-light' : '' ?>">
                                <input class="form-check-input" type="radio" name="kdv_hesaplama_tipi" 
                                       id="kdv_dahil" value="kdv_dahil"
                                       <?= $mevcut_tip === 'kdv_dahil' ? 'checked' : '' ?>
                                       style="width: 20px; height: 20px;">
                                <label class="form-check-label w-100 ms-2" for="kdv_dahil" style="cursor: pointer;">
                                    <div class="d-flex align-items-start">
                                        <div class="flex-grow-1">
                                            <h5 class="mb-2">
                                                <i class="bi bi-check-circle text-success me-2"></i>
                                                Fiyatları KDV Dahil Gireceğim
                                            </h5>
                                            <p class="text-muted mb-2">
                                                Girdiğiniz fiyatın içinden KDV hesaplanır. Perakende satış için uygundur.
                                            </p>
                                            <div class="bg-white p-3 rounded border">
                                                <strong>Örnek:</strong><br>
                                                <span class="text-primary">120,00 TL</span> (girdiğiniz fiyat - KDV dahil) 
                                                = <span class="text-success">100,00 TL</span> (net) 
                                                + <span class="text-info">20,00 TL</span> (%20 KDV)
                                            </div>
                                        </div>
                                    </div>
                                </label>
                            </div>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Not:</strong> Sistem her iki modda da KDV'yi satır bazlı hesaplar ve 
                            e-Fatura uyumlu telafi algoritması uygular. Hesaplama hassasiyeti garantilidir.
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="bi bi-check-circle me-2"></i> Ayarları Kaydet
                            </button>
                            <a href="../ayarlar.php" class="btn btn-outline-secondary">
                                <i class="bi bi-x-circle me-2"></i> İptal
                            </a>
                        </div>
                    </form>
                </div>
                
                <div class="card-footer bg-light">
                    <small class="text-muted">
                        <i class="bi bi-shield-check me-1"></i>
                        <strong>Güvenlik:</strong> Tüm hesaplamalar integer arithmetic ile yapılır. 
                        Float hatası riski sıfırdır.
                    </small>
                </div>
            </div>
            
            <!-- Teknik Bilgi Kartı -->
            <div class="card shadow-sm mt-4">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0">
                        <i class="bi bi-gear"></i> Teknik Detaylar
                    </h5>
                </div>
                <div class="card-body">
                    <h6>Sistem Özellikleri:</h6>
                    <ul class="list-unstyled">
                        <li><i class="bi bi-check-circle text-success me-2"></i> Kuruş hassasiyetli hesaplama (integer arithmetic)</li>
                        <li><i class="bi bi-check-circle text-success me-2"></i> Basis point KDV oranları (örn: %20 = 2000 bp)</li>
                        <li><i class="bi bi-check-circle text-success me-2"></i> Satır bazlı KDV hesaplama</li>
                        <li><i class="bi bi-check-circle text-success me-2"></i> Telafi algoritması (e-Fatura uyumlu)</li>
                        <li><i class="bi bi-check-circle text-success me-2"></i> Dinamik KDV oranı desteği</li>
                        <li><i class="bi bi-check-circle text-success me-2"></i> İndirim dağıtım algoritması</li>
                    </ul>
                    
                    <hr>
                    
                    <h6>Mevcut Ayar:</h6>
                    <div class="alert alert-<?= $mevcut_tip === 'kdv_haric' ? 'primary' : 'success' ?> mb-0">
                        <strong>
                            <?php if ($mevcut_tip === 'kdv_haric'): ?>
                                <i class="bi bi-plus-circle me-2"></i>KDV Hariç Mod Aktif
                            <?php else: ?>
                                <i class="bi bi-check-circle me-2"></i>KDV Dahil Mod Aktif
                            <?php endif; ?>
                        </strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
