<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar ve yetkilendirme zaten yapılmıştır.
$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Log fonksiyonlarını dahil et
require_once __DIR__ . '/../../functions/log_fonksiyonlari.php';

// Aktif kategori tipini belirle (URL'den al, varsayılan 'islem')
$aktif_tip = $_GET['tip'] ?? 'islem';
if (!in_array($aktif_tip, ['islem', 'urun'])) {
    $aktif_tip = 'islem';
}

// Düzenlenecek kategori bilgileri
$duzenlenecek_kategori = [
    'id' => '',
    'kategori_adi' => ''
];

// Kategori düzenleme için verileri çek
if (isset($_GET['duzenle'])) {
    $kategori_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT id, kategori_adi FROM kategoriler WHERE id = ? AND sirket_id = ? AND tip = ?");
        $stmt->execute([$kategori_id, $aktif_sirket_id, $aktif_tip]);
        $duzenlenecek_kategori = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$duzenlenecek_kategori) {
            $_SESSION['hata'] = __("category_not_found");
            header("Location: ayarlar.php?section=kategoriler&tip=" . $aktif_tip);
            exit();
        }
    } catch (PDOException $e) {
        error_log("Kategori getirme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_category");
    }
}

// Kategori ekleme veya güncelleme
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['kategori_ekle']) || isset($_POST['kategori_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $kategori_adi = trim(temizle($_POST['kategori_adi']));
        $tip = temizle($_POST['tip']);
        $kategori_id = isset($_POST['kategori_id']) ? (int)$_POST['kategori_id'] : null;

        if (empty($kategori_adi)) {
            $_SESSION['hata'] = __("category_name_required");
        } elseif (!in_array($tip, ['islem', 'urun'])) {
            $_SESSION['hata'] = __("invalid_category_type");
        } else {
            try {
                if (isset($_POST['kategori_guncelle']) && $kategori_id) {
                    // Kategori güncelleme
                    // Yeni adın başka bir kategoride kullanılıp kullanılmadığını kontrol et
                    $stmt_check = $db->prepare("SELECT id FROM kategoriler WHERE kategori_adi = ? AND sirket_id = ? AND tip = ? AND id != ?");
                    $stmt_check->execute([$kategori_adi, $aktif_sirket_id, $tip, $kategori_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("category_name_already_exists"));
                    }

                    $stmt_update = $db->prepare("UPDATE kategoriler SET kategori_adi = ? WHERE id = ? AND sirket_id = ? AND tip = ?");
                    $stmt_update->execute([$kategori_adi, $kategori_id, $aktif_sirket_id, $tip]);
                    
                    // Log ekle
                    sistem_log_ekle(
                        $db,
                        'guncelle',
                        'kategoriler',
                        $kategori_id,
                        ['kategori_adi' => $duzenlenecek_kategori['kategori_adi']],
                        ['kategori_adi' => $kategori_adi],
                        __('category_updated_log', ['category' => $kategori_adi]),
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("category_updated_successfully");
                } else {
                    // Kategori ekleme
                    // Şirket ve tip bazında kategori adı kontrolü
                    $stmt_check = $db->prepare("SELECT id FROM kategoriler WHERE kategori_adi = ? AND sirket_id = ? AND tip = ?");
                    $stmt_check->execute([$kategori_adi, $aktif_sirket_id, $tip]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("category_name_exists_for_type"));
                    }

                    $stmt = $db->prepare("INSERT INTO kategoriler (sirket_id, kategori_adi, tip) VALUES (?, ?, ?)");
                    $stmt->execute([$aktif_sirket_id, $kategori_adi, $tip]);
                    
                    // Log ekle
                    $yeni_kategori_id = $db->lastInsertId();
                    sistem_log_ekle(
                        $db,
                        'ekle',
                        'kategoriler',
                        $yeni_kategori_id,
                        null,
                        ['kategori_adi' => $kategori_adi, 'tip' => $tip],
                        __('category_added_log', ['category' => $kategori_adi]),
                        $kullanici_id
                    );
                    
                    $_SESSION['mesaj'] = __("category_added_successfully");
                }
            } catch (Exception $e) {
                error_log("Kategori işlem hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    // Kullanıcıyı doğru sekmede tutmak için yönlendir
    header("Location: ?section=kategoriler&tip=" . $aktif_tip);
    exit();
}

// Kategorileri getir (sadece aktif şirkete ve tipe ait olanları)
$kategoriler = [];
try {
    $stmt = $db->prepare("SELECT id, kategori_adi FROM kategoriler WHERE sirket_id = ? AND tip = ? ORDER BY kategori_adi");
    $stmt->execute([$aktif_sirket_id, $aktif_tip]);
    $kategoriler = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Kategori listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_categories");
}

?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj']; unset($_SESSION['mesaj']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<h3 class="mb-4"><i class="bi bi-tags-fill me-2"></i><?= __("category_management") ?></h3>

<!-- Sekmeler (Tabs) -->
<ul class="nav nav-tabs mb-3">
    <li class="nav-item">
        <a class="nav-link <?= ($aktif_tip == 'islem') ? 'active' : '' ?>" href="?section=kategoriler&tip=islem">
            <i class="bi bi-receipt me-1"></i> <?= __("transaction_categories") ?>
        </a>
    </li>
    <li class="nav-item">
        <a class="nav-link <?= ($aktif_tip == 'urun') ? 'active' : '' ?>" href="?section=kategoriler&tip=urun">
            <i class="bi bi-box-seam me-1"></i> <?= __("product_categories") ?>
        </a>
    </li>
</ul>

<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-<?= $duzenlenecek_kategori['id'] ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0"><i class="bi <?= $duzenlenecek_kategori['id'] ? 'bi-pencil-square' : 'bi-plus-circle' ?> me-2"></i><?= $duzenlenecek_kategori['id'] ? __('edit_category') : (($aktif_tip == 'urun') ? __('add_new_product_category') : __('add_new_transaction_category')) ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="ayarlar.php?section=kategoriler&tip=<?= $aktif_tip ?>">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <input type="hidden" name="tip" value="<?= $aktif_tip ?>">
                    <?php if ($duzenlenecek_kategori['id']): ?>
                        <input type="hidden" name="kategori_id" value="<?= $duzenlenecek_kategori['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="kategori_adi" class="form-label"><?= __("category_name") ?></label>
                        <input type="text" class="form-control" id="kategori_adi" name="kategori_adi" value="<?= htmlspecialchars($duzenlenecek_kategori['kategori_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <?php if ($duzenlenecek_kategori['id']): ?>
                        <div class="d-flex justify-content-center gap-2">
                            <button type="submit" name="kategori_guncelle" class="btn btn-warning flex-fill">
                                <i class="bi bi-check-circle me-1"></i> <?= __("update") ?>
                            </button>
                            <a href="?section=kategoriler&tip=<?= $aktif_tip ?>" class="btn btn-secondary flex-fill">
                                <i class="bi bi-x-circle me-1"></i> <?= __("cancel") ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <button type="submit" name="kategori_ekle" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i> <?= __("save_category") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card shadow-sm">
             <div class="card-header"><h5 class="mb-0"><i class="bi bi-list-ul me-2"></i><?= ($aktif_tip == 'urun') ? __('existing_product_categories') : __('existing_transaction_categories'); ?></h5></div>
            <div class="card-body p-0">
                <?php if (!empty($kategoriler)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?= __("category_name") ?></th>
                                    <th class="text-end" style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($kategoriler as $kategori): ?>
                                <tr>
                                    <td><?= temizle($kategori['kategori_adi']) ?></td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="?section=kategoriler&tip=<?= $aktif_tip ?>&duzenle=<?= $kategori['id'] ?>" class="btn btn-outline-warning" title="<?= __("edit_category") ?>">
                                                <i class="bi bi-pencil"></i> <?= __("edit") ?>
                                            </a>
                                            <a href="ayarlar/kategori_sil.php?id=<?= $kategori['id'] ?>&csrf_token=<?= $csrf_token ?>&tip=<?= $aktif_tip ?>" class="btn btn-outline-danger" title="<?= __("delete_category") ?>" onclick="return confirm('<?= __("confirm_delete_category") ?>')">
                                                <i class="bi bi-trash"></i> <?= __("delete") ?>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-light m-3 text-center" role="alert">
                       <?= ($aktif_tip == 'urun') ? __('no_product_categories_found') : __('no_transaction_categories_found') ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
