<?php
require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/yetki_kontrol.php';
yetki_kontrol_ve_yonlendir('ayarlar', 'sil');

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];
$tip = $_GET['tip'] ?? 'islem'; // Aktif tipi al

// Gerekli parametreleri ve güvenlik tokenını kontrol et
$kategori_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$kategori_id || !isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
    $_SESSION['hata'] = "Geçersiz istek veya güvenlik tokenı.";
    header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
    exit();
}

try {
    // 1. Kategorinin varlığını ve şirkete ait olduğunu doğrula
    $stmt_check_owner = $db->prepare("SELECT COUNT(*) FROM kategoriler WHERE id = ? AND sirket_id = ?");
    $stmt_check_owner->execute([$kategori_id, $aktif_sirket_id]);
    if ($stmt_check_owner->fetchColumn() == 0) {
        throw new Exception("Kategori bulunamadı veya bu şirkete ait değil.");
    }

    // 2. Bu kategorinin herhangi bir işlem tarafından kullanılıp kullanılmadığını kontrol et
    // Not: Bu kontrol, uygulamanızdaki diğer tablolara göre genişletilmelidir.
    $stmt_check_usage_urunler = $db->prepare("SELECT COUNT(*) FROM urunler WHERE kategori_id = ? AND sirket_id = ?");
    $stmt_check_usage_urunler->execute([$kategori_id, $aktif_sirket_id]);
    if ($stmt_check_usage_urunler->fetchColumn() > 0) {
        throw new Exception("Bu kategori, bir veya daha fazla ürün tarafından kullanıldığı için silinemez.");
    }

    $stmt_check_usage_borclar = $db->prepare("SELECT COUNT(*) FROM borclar WHERE kategori_id = ? AND sirket_id = ?");
    $stmt_check_usage_borclar->execute([$kategori_id, $aktif_sirket_id]);
    if ($stmt_check_usage_borclar->fetchColumn() > 0) {
        throw new Exception("Bu kategori, bir veya daha fazla borç/alacak kaydı tarafından kullanıldığı için silinemez.");
    }
    
    // 3. Hiçbir yerde kullanılmıyorsa sil
    // Önce kategori bilgilerini al (geri alma için)
    $stmt_kategori = $db->prepare("SELECT * FROM kategoriler WHERE id = ? AND sirket_id = ?");
    $stmt_kategori->execute([$kategori_id, $aktif_sirket_id]);
    $kategori = $stmt_kategori->fetch(PDO::FETCH_ASSOC);
    
    // Kategoriyi sil
    $stmt_delete = $db->prepare("DELETE FROM kategoriler WHERE id = ? AND sirket_id = ?");
    $stmt_delete->execute([$kategori_id, $aktif_sirket_id]);

    if ($stmt_delete->rowCount() > 0) {
        // Silinen kaydı logla ve geri alma için sakla
        $log_id = sistem_log_ekle($db, 'sil', 'kategoriler', $kategori_id, $kategori, null, 'Kategori silindi: ' . $kategori['kategori_adi']);
        if ($log_id) {
            silinen_kayit_ekle($db, $log_id, 'kategoriler', $kategori_id, $kategori);
        }
        $_SESSION['mesaj'] = "Kategori başarıyla silindi.";
    } else {
        throw new Exception("Kategori silinemedi veya zaten silinmiş.");
    }

} catch (Exception $e) {
    error_log("Kategori silme hatası: " . $e->getMessage());
    $_SESSION['hata'] = $e->getMessage();
}

// Sonuç ne olursa olsun ana sayfaya geri dön
header("Location: ../ayarlar.php?section=kategoriler&tip=" . $tip);
exit();
?> 
