<?php
require_once __DIR__ . '/../../includes/config.php';
yetkili_mi(); // Tüm yetkili kullanıcılar kendi ayarlarını yapabilir

$sayfa_baslik = __("security_settings");
$kullanici_id = $_SESSION['kullanici_id'];

// Form gönderildiğinde
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_form_submission");
    } else {
        try {
            $db->beginTransaction();

            $ekran_kilidi_aktif = isset($_POST['ekran_kilidi_aktif']) ? 1 : 0;
            $ekran_kilidi_sure = filter_input(INPUT_POST, 'ekran_kilidi_sure', FILTER_VALIDATE_INT);
            $yeni_sifre = $_POST['yeni_sifre'];
            $yeni_sifre_tekrar = $_POST['yeni_sifre_tekrar'];

            if ($ekran_kilidi_sure === false || $ekran_kilidi_sure < 1) {
                throw new Exception(__("screen_lock_time_minutes"));
            }

            // Şifre güncelleme mantığı
            if (!empty($yeni_sifre)) {
                if ($yeni_sifre !== $yeni_sifre_tekrar) {
                    throw new Exception(__("new_passwords_dont_match"));
                }
                if (strlen($yeni_sifre) < 4) {
                    throw new Exception(__("screen_lock_password_min_length"));
                }
                $hashed_sifre = password_hash($yeni_sifre, PASSWORD_DEFAULT);
                $stmt = $db->prepare("UPDATE kullanicilar SET ekran_kilidi_sifre = ? WHERE id = ?");
                $stmt->execute([$hashed_sifre, $kullanici_id]);
            }

            // Diğer ayarları güncelle
            $stmt = $db->prepare("UPDATE kullanicilar SET ekran_kilidi_aktif = ?, ekran_kilidi_sure = ? WHERE id = ?");
            $stmt->execute([$ekran_kilidi_aktif, $ekran_kilidi_sure, $kullanici_id]);

            $db->commit();
            $_SESSION['mesaj'] = __("security_settings_updated");
           

        } catch (Exception $e) {
            $db->rollBack();
            $_SESSION['hata'] = __("an_error_occurred") . ": " . $e->getMessage();
        }
    }
}

// Mevcut kullanıcı ayarlarını çek
$stmt_kullanici = $db->prepare("SELECT ekran_kilidi_aktif, ekran_kilidi_sure, ekran_kilidi_sifre FROM kullanicilar WHERE id = ?");
$stmt_kullanici->execute([$kullanici_id]);
$kullanici_ayarlari = $stmt_kullanici->fetch(PDO::FETCH_ASSOC);

$csrf_token = csrf_token_olustur();
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= temizle($sayfa_baslik) ?> - <?= __("management") ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
</head>
<body>
    
    <div class="container mt-4">
        <h2><i class="bi bi-shield-check"></i> <?= temizle($sayfa_baslik) ?></h2>
        <hr>

        <?php if (isset($_SESSION['mesaj'])): ?>
            <div class="alert alert-success"><?= $_SESSION['mesaj'] ?></div>
            <?php unset($_SESSION['mesaj']); ?>
        <?php endif; ?>
        <?php if (isset($_SESSION['hata'])): ?>
            <div class="alert alert-danger"><?= $_SESSION['hata'] ?></div>
            <?php unset($_SESSION['hata']); ?>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    
                    <div class="form-check form-switch mb-3">
                        <input class="form-check-input" type="checkbox" role="switch" id="ekran_kilidi_aktif" name="ekran_kilidi_aktif" value="1" <?= $kullanici_ayarlari['ekran_kilidi_aktif'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="ekran_kilidi_aktif"><?= __("enable_auto_screen_lock") ?></label>
                    </div>

                    <div class="mb-3">
                        <label for="ekran_kilidi_sure" class="form-label"><?= __("idle_timeout_minutes") ?></label>
                        <input type="number" class="form-control" id="ekran_kilidi_sure" name="ekran_kilidi_sure" value="<?= temizle($kullanici_ayarlari['ekran_kilidi_sure']) ?>" min="1" required>
                        <small class="form-text text-muted"><?= __("screen_will_lock_after") ?></small>
                    </div>

                    <hr>
                    <h5><?= __("screen_lock_password") ?></h5>
                    <?php if (empty($kullanici_ayarlari['ekran_kilidi_sifre'])): ?>
                        <div class="alert alert-warning"><?= __("no_screen_lock_password_set") ?></div>
                    <?php endif; ?>

                    <div class="mb-3">
                        <label for="yeni_sifre" class="form-label"><?= __("new_password") ?></label>
                        <input type="password" class="form-control" id="yeni_sifre" name="yeni_sifre" placeholder="<?= __("enter_new_password") ?>">
                    </div>
                    <div class="mb-3">
                        <label for="yeni_sifre_tekrar" class="form-label"><?= __("new_password_repeat") ?></label>
                        <input type="password" class="form-control" id="yeni_sifre_tekrar" name="yeni_sifre_tekrar" placeholder="<?= __("re_enter_new_password") ?>">
                    </div>

                    <div class="text-end">
                        <button type="submit" class="btn btn-primary"><i class="bi bi-save"></i> <?= __("save_settings") ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
