<?php
// Bu dosya, ana ayarlar.php tarafından include edildiği için,
// temel include'lar ve yetkilendirme zaten yapılmıştır.

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];
// CSRF token'ı ana ayarlar.php sayfasından geliyor.

// Düzenlenecek grup bilgileri
$duzenlenecek_grup = [
    'id' => '',
    'grup_adi' => ''
];

// Grup düzenleme için verileri çek
if (isset($_GET['duzenle'])) {
    $grup_id = (int)$_GET['duzenle'];
    try {
        $stmt = $db->prepare("SELECT id, grup_adi FROM cari_gruplari WHERE id = ? AND sirket_id = ?");
        $stmt->execute([$grup_id, $aktif_sirket_id]);
        $duzenlenecek_grup = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$duzenlenecek_grup) {
            $_SESSION['hata'] = __("group_not_found");
            header("Location: ayarlar.php?section=cari_gruplari");
            exit();
        }
    } catch (PDOException $e) {
        error_log("Grup getirme hatası: " . $e->getMessage());
        $_SESSION['hata'] = __("error_loading_group");
    }
}

// Cari Grubu Ekleme/Güncelleme İşlemi
if ($_SERVER['REQUEST_METHOD'] == 'POST' && (isset($_POST['grup_ekle']) || isset($_POST['grup_guncelle']))) {
    if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
        $_SESSION['hata'] = __("invalid_security_token");
    } else {
        $grup_adi = trim(temizle($_POST['grup_adi']));
        $grup_id = isset($_POST['grup_id']) ? (int)$_POST['grup_id'] : null;

        if (empty($grup_adi)) {
            $_SESSION['hata'] = __("group_name_required");
        } else {
            try {
                if (isset($_POST['grup_guncelle']) && $grup_id) {
                    // Grup güncelleme
                    // Yeni adın başka bir grupta kullanılıp kullanılmadığını kontrol et
                    $stmt_check = $db->prepare("SELECT id FROM cari_gruplari WHERE grup_adi = ? AND sirket_id = ? AND id != ?");
                    $stmt_check->execute([$grup_adi, $aktif_sirket_id, $grup_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("group_name_already_exists"));
                    }

                    $stmt_update = $db->prepare("UPDATE cari_gruplari SET grup_adi = ? WHERE id = ? AND sirket_id = ?");
                    $stmt_update->execute([$grup_adi, $grup_id, $aktif_sirket_id]);
                    
                    $_SESSION['mesaj'] = __("customer_group_updated_successfully");
                } else {
                    // Grup ekleme
                    // Aynı isimde grup var mı kontrol et (aynı şirket için)
                    $stmt_check = $db->prepare("SELECT id FROM cari_gruplari WHERE grup_adi = ? AND sirket_id = ?");
                    $stmt_check->execute([$grup_adi, $aktif_sirket_id]);
                    if ($stmt_check->fetch()) {
                        throw new Exception(__("group_name_already_exists"));
                    }

                    $stmt = $db->prepare("INSERT INTO cari_gruplari (sirket_id, grup_adi) VALUES (?, ?)");
                    $stmt->execute([$aktif_sirket_id, $grup_adi]);
                    $_SESSION['mesaj'] = __("customer_group_added_successfully");
                }
            } catch (Exception $e) {
                error_log("Cari grubu işlem hatası: " . $e->getMessage());
                $_SESSION['hata'] = $e->getMessage();
            }
        }
    }
    // Sayfanın yeniden yüklenerek mesajların gösterilmesini sağla
    header("Location: ayarlar.php?section=cari_gruplari");
    exit();
}

// Cari Gruplarını Listeleme
try {
    $stmt = $db->prepare("SELECT * FROM cari_gruplari WHERE sirket_id = ? ORDER BY grup_adi");
    $stmt->execute([$aktif_sirket_id]);
    $cari_gruplari = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Cari grupları listeleme hatası: " . $e->getMessage());
    $_SESSION['hata'] = __("error_loading_customer_groups");
    $cari_gruplari = [];
}
?>

<?php if (isset($_SESSION['mesaj'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert"><?= $_SESSION['mesaj']; unset($_SESSION['mesaj']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>
<?php if (isset($_SESSION['hata'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert"><?= $_SESSION['hata']; unset($_SESSION['hata']); ?><button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>
<?php endif; ?>

<h3 class="mb-4"><i class="bi bi-collection-fill me-2"></i> <?= __("customer_group_management") ?></h3>
<div class="row">
    <div class="col-md-4">
        <div class="card shadow-sm mb-3">
            <div class="card-header bg-<?= $duzenlenecek_grup['id'] ? 'warning' : 'success' ?> text-white">
                <h5 class="mb-0"><i class="bi <?= $duzenlenecek_grup['id'] ? 'bi-pencil-square' : 'bi-plus-circle' ?> me-2"></i><?= $duzenlenecek_grup['id'] ? __('edit_group') : __('add_new_group') ?></h5>
            </div>
            <div class="card-body">
                <form method="post" action="ayarlar.php?section=cari_gruplari">
                    <input type="hidden" name="csrf_token" value="<?= $csrf_token ?>">
                    <?php if ($duzenlenecek_grup['id']): ?>
                        <input type="hidden" name="grup_id" value="<?= $duzenlenecek_grup['id'] ?>">
                    <?php endif; ?>
                    <div class="mb-3">
                        <label for="grup_adi" class="form-label"><?= __("group_name") ?></label>
                        <input type="text" class="form-control" id="grup_adi" name="grup_adi" value="<?= htmlspecialchars($duzenlenecek_grup['grup_adi'], ENT_QUOTES) ?>" required>
                    </div>
                    <?php if ($duzenlenecek_grup['id']): ?>
                        <div class="d-flex justify-content-center gap-2">
                            <button type="submit" name="grup_guncelle" class="btn btn-warning flex-fill">
                                <i class="bi bi-check-circle me-1"></i> <?= __("update") ?>
                            </button>
                            <a href="?section=cari_gruplari" class="btn btn-secondary flex-fill">
                                <i class="bi bi-x-circle me-1"></i> <?= __("cancel") ?>
                            </a>
                        </div>
                    <?php else: ?>
                        <button type="submit" name="grup_ekle" class="btn btn-success w-100">
                            <i class="bi bi-save me-1"></i> <?= __("save_group") ?>
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <div class="card shadow-sm">
            <div class="card-header"><h5 class="mb-0"><i class="bi bi-list-ul me-2"></i><?= __("existing_groups") ?></h5></div>
            <div class="card-body p-0">
                <?php if (!empty($cari_gruplari)): ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-hover mb-0">
                            <thead>
                                <tr>
                                    <th><?= __("group_name") ?></th>
                                    <th class="text-end" style="width: 200px;"><?= __("actions") ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($cari_gruplari as $grup): ?>
                                <tr>
                                    <td><?= temizle($grup['grup_adi']) ?></td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <a href="?section=cari_gruplari&duzenle=<?= $grup['id'] ?>" class="btn btn-outline-warning" title="<?= __("edit_group") ?>">
                                                <i class="bi bi-pencil"></i> <?= __("edit") ?>
                                            </a>
                                            <a href="ayarlar/cari_grup_sil.php?id=<?= $grup['id'] ?>&csrf_token=<?= $csrf_token ?>" class="btn btn-outline-danger" title="<?= __("delete_group") ?>" onclick="return confirm('<?= __("confirm_delete_group") ?>')">
                                                <i class="bi bi-trash"></i> <?= __("delete") ?>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-light m-3 text-center" role="alert">
                        <?= __("no_customer_groups_found") ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div> 
