<?php
require_once __DIR__ . '/../../includes/config.php';
yetkili_mi();

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Gerekli parametreleri ve güvenlik tokenını kontrol et
$grup_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$grup_id || !isset($_GET['csrf_token']) || !csrf_token_dogrula($_GET['csrf_token'])) {
    $_SESSION['hata'] = "Geçersiz istek veya güvenlik tokenı.";
    header("Location: " . BASE_URL . "/views/ayarlar.php?section=cari_gruplari");
    exit();
}

try {
    // 1. Grubun varlığını ve şirkete ait olduğunu doğrula
    $stmt_check_owner = $db->prepare("SELECT COUNT(*) FROM cari_gruplari WHERE id = ? AND sirket_id = ?");
    $stmt_check_owner->execute([$grup_id, $aktif_sirket_id]);
    if ($stmt_check_owner->fetchColumn() == 0) {
        throw new Exception("Cari grubu bulunamadı veya bu şirkete ait değil.");
    }

    // 2. Bu grubun herhangi bir cari tarafından kullanılıp kullanılmadığını kontrol et
    $stmt_check_usage = $db->prepare("SELECT COUNT(*) FROM cariler WHERE grup_id = ? AND sirket_id = ?");
    $stmt_check_usage->execute([$grup_id, $aktif_sirket_id]);
    if ($stmt_check_usage->fetchColumn() > 0) {
        throw new Exception("Bu grup, bir veya daha fazla cari tarafından kullanıldığı için silinemez. Lütfen önce ilgili carilerin grubunu değiştirin.");
    }
    
    // 3. Hiçbir cari tarafından kullanılmıyorsa sil
    $stmt_delete = $db->prepare("DELETE FROM cari_gruplari WHERE id = ? AND sirket_id = ?");
    $stmt_delete->execute([$grup_id, $aktif_sirket_id]);

    if ($stmt_delete->rowCount() > 0) {
        $_SESSION['mesaj'] = "Cari grubu başarıyla silindi.";
    } else {
        // Bu genellikle yukarıdaki kontrol nedeniyle olmaz ama bir güvenlik katmanıdır.
        throw new Exception("Grup silinemedi veya zaten silinmiş.");
    }

} catch (Exception $e) {
    error_log("Cari grubu silme hatası: " . $e->getMessage());
    $_SESSION['hata'] = $e->getMessage();
}

// Sonuç ne olursa olsun ana sayfaya geri dön
header("Location: " . BASE_URL . "/ayarlar.php?section=cari_gruplari");
exit();
?> 
