<?php
/**
 * German Language File
 * Deutsche Sprachdatei
 */

return [
    // General / Allgemein
    'welcome' => 'Willkommen',
    'dashboard' => 'Dashboard',
    'profile' => 'Profil',
    'settings' => 'Einstellungen',
    'logout' => 'Abmelden',
    'login' => 'Anmelden',
    'save' => 'Speichern',
    'cancel' => 'Abbrechen',
    'edit' => 'Bearbeiten',
    'delete' => 'Löschen',
    'add' => 'Hinzufügen',
    'search' => 'Suchen',
    
    // Header / Hauptmenü
    'operations' => 'Operationen',
    'inventory' => 'Lager',
    'reports' => 'Berichte',
    'management' => 'Verwaltung',
    'switch_company' => 'Firma wechseln',
    'select_company' => 'Firma auswählen',
    'language' => 'Sprache',
    
    // Footer / Fußzeile
    'all_rights_reserved' => 'Alle Rechte vorbehalten',
    'developer' => 'Entwickler',
    
    // Navigation / Menü
    'sales_invoices' => 'Verkaufsrechnungen',
    'purchase_invoices' => 'Einkaufsrechnungen',
    'new_purchase_invoice' => 'Neue Einkaufsrechnung',
    'sales_invoice' => 'Verkaufsrechnung',
    'purchase_invoice' => 'Einkaufsrechnung',
    'invoice' => 'Rechnung',
    'invoice_number' => 'Rechnungsnummer',
    'view_related_invoice' => 'Zugehörige Rechnung anzeigen',
    'invoice_date' => 'Rechnungsdatum',
    'due_date' => 'Fälligkeitsdatum',
    'payment_status' => 'Zahlungsstatus',
    'paid' => 'Bezahlt',
    'partially_paid' => 'Teilweise bezahlt',
    'unpaid' => 'Unbezahlt',
    'customer' => 'Kunde',
    'supplier' => 'Lieferant',
    'company_info' => 'Firmeninformationen',
    'tax_office' => 'Finanzamt',
    'tax_number' => 'Steuernummer',
    'address' => 'Adresse',
    'phone' => 'Telefon',
    'description_items' => 'Beschreibungspositionen',
    'no_description_items' => 'Keine Beschreibungspositionen',
    'product_name' => 'Produktname',
    'quantity' => 'Menge',
    'unit_price' => 'Einzelpreis',
    'vat_amount' => 'MwSt-Betrag',
    'amount' => 'Betrag',
    'subtotal' => 'Zwischensumme',
    'total_vat' => 'Gesamt MwSt',
    'discount' => 'Rabatt',
    'total_amount' => 'Gesamtbetrag',
    'paid_amount' => 'Bezahlter Betrag',
    'remaining_amount' => 'Verbleibender Betrag',
    'print' => 'Drucken',
    'download_pdf' => 'PDF herunterladen',
    'download_excel' => 'Excel herunterladen',
    'generated_by' => 'Erstellt mit Begeb Creative Verwaltungssystem',
    'error_invalid_invoice_id' => 'Ungültige Rechnungs-ID',
    'error_invoice_not_found' => 'Rechnung nicht gefunden oder keine Berechtigung',
    'error_database' => 'Datenbankfehler aufgetreten',
    'error_invalid_token' => 'Ungültiges Sicherheitstoken',
    'error_invalid_status' => 'Ungültiger Zahlungsstatus',
    'success_payment_status_updated' => 'Zahlungsstatus aktualisiert',
    'from_date' => 'Von Datum',
    'to_date' => 'Bis Datum',
    'product_service' => 'Produkt/Service',
    'product_currency' => 'Produktwährung',
    'exchange_rate' => 'Wechselkurs',
    'vat_rate' => 'MwSt (%)',
    'total' => 'Gesamt',
    'add_product' => 'Produkt hinzufügen',
    'select_product' => 'Produkt auswählen',
    'search_product_placeholder' => 'Nach Produktname oder Bestandscode suchen...',
    'stock_code' => 'Bestandscode',
    'price' => 'Preis',
    'grand_total' => 'Gesamtsumme',
    'description' => 'Beschreibung',
    'edit_invoice' => 'Rechnung bearbeiten',
    'back_to_invoice' => 'Zurück zur Rechnungsübersicht',
    'invalid_invoice_id' => 'Ungültige Rechnungs-ID',
    'database_error' => 'Datenbankfehler: Daten konnten nicht geladen werden',
    'customer_required' => 'Kundenauswahl ist erforderlich',
    'actions' => 'Aktionen',
    'overdue' => 'Überfällig',
    'search_placeholder' => 'Rechnungsnr., Kundename oder Beschreibung...',
    'clear_filters' => 'Filter zurücksetzen',
    'all' => 'Alle',
    'offers' => 'Angebote',
    'offer_list' => 'Angebotsliste',
    'new_offer' => 'Neues Angebot',
    'offer_without_stock' => 'Angebot ohne Bestand',
    'customers' => 'Kunden',
    'cash_receipt' => 'Kassenbeleg',
    'exchange_rates' => 'Wechselkurse',
    'batch_operations' => 'Stapelverarbeitung',
    'reminder' => 'Erinnerung',
    'backup_operations' => 'Sicherungen',
    
    // Sales Page / Verkaufsseite
    'sale_transaction' => 'Verkaufstransaktion',
    'invoice_products' => 'Rechnungspositionen',
    'add_product' => 'Produkt hinzufügen',
    'supplier' => 'Lieferant',
    'category' => 'Kategorie',
    'transaction_date' => 'Transaktionsdatum',
    'description' => 'Beschreibung',
    'product_name' => 'Produktname',
    'quantity' => 'Menge',
    'unit_price' => 'Einzelpreis',
    'rate' => 'Kurs',
    'current_rate' => 'Aktueller Kurs',
    'vat_rate' => 'MwSt (%)',
    'vat_amount' => 'MwSt-Betrag',
    'total' => 'Gesamt',
    'delete' => 'Löschen',
    'subtotal' => 'Zwischensumme',
    'total_vat' => 'Gesamt MwSt',
    'discount' => 'Rabatt',
    'grand_total' => 'Gesamtsumme',
    'payment_transactions' => 'Zahlungstransaktionen',
    'payment_made_in_cash' => 'Zahlung erfolgte bar',
    'payment_account' => 'Zahlungskonto',
    'select_account' => '-- Konto auswählen --',
    'payment_date' => 'Zahlungsdatum',
    'save_sale' => 'Verkauf speichern',
    'select_products' => 'Produkte auswählen',
    'select_supplier' => 'Kein Lieferant ausgewählt',
    'select_category' => '-- Kategorie auswählen --',
    'invoice_currency' => 'Rechnungswährung',
    'all_suppliers' => 'Alle Lieferanten',
    'search_product_barcode' => 'Produktname oder Barcode eingeben...',
    'saving' => 'Wird gespeichert...',
    'loading_products' => 'Produkte werden geladen...',
    'no_products_found' => 'Keine Produkte gefunden',
    'select' => 'Auswählen',
    'selected' => 'Ausgewählt',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'purchase_transaction' => 'Einkaufstransaktion',
    'supplier_required' => 'Lieferantenauswahl ist erforderlich',
    'category_required' => 'Kategorieauswahl ist erforderlich',
    'valid_date_required' => 'Bitte geben Sie ein gültiges Transaktionsdatum ein',
    'at_least_one_product_required' => 'Mindestens ein Produkt ist für den Einkauf erforderlich',
    'discount_cannot_exceed_total' => 'Rabattbetrag darf nicht höher sein als die Rechnungssumme',
    'account_required_for_cash_payment' => 'Für Barzahlung ist eine Kontoauswahl erforderlich',
    'purchase_saved_successfully' => 'Einkauf erfolgreich gespeichert',
    'credit_customer' => 'Kunde gutschreiben',
    'transaction_items' => 'Transaktionspositionen',
    'add_item' => 'Position hinzufügen',
    'remove' => 'Entfernen',
    'cash_payment' => 'Barzahlung',
    'save_credit' => 'Gutschrift speichern',
    'valid_date_required' => 'Bitte geben Sie ein gültiges Transaktionsdatum ein.',
    'amount_required' => 'Betrag ist erforderlich.',
    'amount_greater_than_zero' => 'Der Betrag muss größer als 0 sein.',
    'account_required_for_cash' => 'Für Barzahlung ist eine Kontoauswahl erforderlich.',
    'credit_saved_success' => 'Kundenkreditierung erfolgreich gespeichert.',
    'error_occurred' => 'Ein Fehler ist aufgetreten:',
    'failed_to_save_credit' => 'Beim Speichern der Kundenkreditierung ist ein Fehler aufgetreten.',
    'select_customer' => 'Kunde auswählen',
    'no_customer_selected' => 'Kein Kunde ausgewählt',
    'no_results_found' => 'Keine Ergebnisse gefunden',
    'at_least_one_item_required' => 'Mindestens ein Posten ist erforderlich',
    'debit_customer' => 'Kunde belasten',
    'debit_saved_success' => 'Kundenbelastung erfolgreich gespeichert.',
    'failed_to_save_debit' => 'Beim Speichern der Kundenbelastung ist ein Fehler aufgetreten.',
    'save_debit' => 'Speichern',
    'receive_payment' => 'Zahlung erhalten (Eingang)',
    'payment_received' => 'Zahlung erhalten',
    'payment_info' => 'Zahlungsinformationen',
    'payment_saved' => 'Zahlung erfolgreich gespeichert.',
    'payment_failed' => 'Fehler beim Speichern der Zahlung.',
    'payment_amount_required' => 'Zahlungsbetrag ist erforderlich.',
    'valid_payment_amount' => 'Bitte geben Sie einen gültigen Zahlungsbetrag ein (größer als 0).',
    'payment_date_required' => 'Zahlungsdatum ist erforderlich.',
    'account_selection_required' => 'Kontoauswahl ist erforderlich.',
    'customer_selection_required' => 'Kundenauswahl ist erforderlich.',
    'save_payment' => 'Zahlung speichern',
    'payment_description' => 'Zahlungsbeschreibung',
    'payment_date' => 'Zahlungsdatum',
    'payment_account' => 'Zahlungskonto',
    'select_account' => 'Konto auswählen',
    'payment_received_success' => 'Zahlung erfolgreich erhalten.',
    'payment_made_success' => 'Zahlung erfolgreich getätigt.',
    'make_payment' => 'Zahlung tätigen',
    'payment_made' => 'Zahlung getätigt',
    'payment_information' => 'Zahlungsinformationen',
    'payment_recipient' => 'Zahlungsempfänger (Lieferant)',
    'payment_recipient_required' => 'Zahlungsempfänger (Lieferant) ist erforderlich.',
    'insufficient_funds' => 'Unzureichende Mittel! (Verfügbar: {amount} {currency})',
    'save_payment_btn' => 'Zahlung speichern',
    'add_transfer' => 'Überweisung',
    'transfer' => 'Überweisung',
    'from_account' => 'Von Konto',
    'to_account' => 'An Konto',
    'transfer_amount' => 'Überweisungsbetrag',
    'transfer_date' => 'Überweisungsdatum',
    'transfer_description' => 'Überweisungsbeschreibung',
    'exchange_rate' => 'Wechselkurs',
    'use_manual_rate' => 'Manuellen Kurs verwenden',
    'amount_in_target_currency' => 'Betrag in Zielwährung',
    'same_account_transfer_error' => 'Überweisung zwischen denselben Konten ist nicht möglich!',
    'invalid_amount_error' => 'Bitte geben Sie einen gültigen Betrag ein!',
    'select_source_account' => 'Quellkonto auswählen',
    'select_target_account' => 'Zielkonto auswählen',
    'add_expense' => 'Kassenausgabe',
    'expense' => 'Ausgabe',
    'expense_type' => 'Ausgabentyp',
    'expense_date' => 'Ausgabedatum',
    'expense_amount' => 'Ausgabebetrag',
    'expense_description' => 'Ausgabenbeschreibung',
    'select_expense_type' => 'Ausgabentyp auswählen',
    'select_payment_method' => 'Zahlungsmethode auswählen',
    'expense_added_success' => 'Ausgabe erfolgreich hinzugefügt',
    'transfer_added_success' => 'Überweisung erfolgreich hinzugefügt',
    'source_account' => 'Quellkonto',
    'target_account' => 'Zielkonto',
    'transfer_amount_placeholder' => 'Überweisungsbetrag eingeben',
    'exchange_rate_placeholder' => 'Wechselkurs wird automatisch berechnet',
    'automatic_exchange_rate_info' => 'Der Wechselkurs wird automatisch basierend auf dem aktuellen Kurs berechnet',
    'fill_required_fields' => 'Bitte füllen Sie alle erforderlichen Felder aus',
    'selected_account_not_found' => 'Ausgewähltes Konto nicht gefunden!',
    'insufficient_balance' => 'Unzureichender Kontostand!',
    'select_cash_register' => 'Kasse auswählen',
    'save_expense' => 'Ausgabe speichern',
    'expense_added_successfully' => 'Ausgabe erfolgreich gespeichert!',
    'invalid_security_token' => 'Ungültiges Sicherheitstoken!',
    'save' => 'Speichern',
    'failed_to_save_purchase' => 'Beim Speichern des Einkaufs ist ein Fehler aufgetreten.',
    'select_supplier' => 'Lieferant auswählen',
    'no_supplier_selected' => 'Kein Lieferant ausgewählt',
    'save_purchase' => 'Einkauf speichern',
    'add_product' => 'Produkt hinzufügen',
    'user' => 'Benutzer',
    'filter' => 'Filtern',
    'export' => 'Exportieren',
    'import' => 'Importieren',
    'back' => 'Zurück',
    'next' => 'Weiter',
    'previous' => 'Zurück',
    'close' => 'Schließen',
    'confirm' => 'Bestätigen',
    'yes' => 'Ja',
    'no' => 'Nein',
    'ok' => 'OK',
    'error' => 'Fehler',
    'success' => 'Erfolg',
    'warning' => 'Warnung',
    'info' => 'Info',
    'loading' => 'Wird geladen...',
    'please_wait' => 'Bitte warten...',
    
    // Dashboard / Übersicht
    'welcome_user' => 'Willkommen, :name!',
    'active_company' => 'Aktives Unternehmen: :company',
    'current_time' => 'Aktuelle Uhrzeit',
    'total_customers' => 'Gesamtkunden',
    'customer_receivables' => 'Kundenforderungen',
    'supplier_debts' => 'Lieferantenverbindlichkeiten',
    'net_balance' => 'Netto-Saldo',
    'total_sales' => 'Gesamtumsatz',
    'total_purchases' => 'Gesamteinkäufe',
    'profit_loss' => 'Gewinn/Verlust',
    'monthly_income_expense_chart' => 'Monatliche Einnahmen- und Ausgabenübersicht',
    'income' => 'Einnahmen',
    'expense' => 'Ausgaben',
    'account_balances' => 'Kontostände',
    'recent_account_movements' => 'Letzte Kontobewegungen',
    'upcoming_due_receivables' => 'Fällige/Überfällige Forderungen',
    'upcoming_due_payments' => 'Fällige/Überfällige Zahlungen',
    'recent_logins' => 'Letzte Anmeldungen',
    'most_sold_products' => 'Meistverkaufte Produkte',
    'detailed_sales_report' => 'Detaillierter Verkaufsbericht',
    'view_all_movements' => 'Alle Bewegungen anzeigen',
    
    // Quotes / Angebote
    'quotes' => 'Angebote',
    'quote' => 'Angebot',
    'new_quote' => 'Neues Angebot',
    'quote_without_stock' => 'Angebot ohne Bestand',
    'quote_date' => 'Angebotsdatum',
    'quote_number' => 'Angebotsnummer',
    'quote_status' => 'Angebotsstatus',
    'convert_to_invoice' => 'In Rechnung umwandeln',
    'confirm_convert_to_invoice' => 'Möchten Sie dieses Angebot wirklich in eine Rechnung umwandeln?',
    'confirm_cancel_quote' => 'Möchten Sie dieses Angebot wirklich stornieren?',
    'confirm_delete_quote' => 'Möchten Sie dieses Angebot wirklich löschen?',
    'no_quotes_found' => 'Keine Angebote gefunden.',
    'quote_created' => 'Angebot erfolgreich erstellt.',
    'quote_updated' => 'Angebot erfolgreich aktualisiert.',
    'edit_quote' => 'Angebot ohne Bestand bearbeiten',
    'error_loading_quote' => 'Fehler beim Laden des Angebots!',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'quote_date_required' => 'Angebotsdatum ist erforderlich.',
    'at_least_one_item_required' => 'Mindestens ein Posten ist erforderlich.',
    'quote_updated_success' => 'Angebot ohne Bestand #%s erfolgreich aktualisiert.',
    'error_updating_quote' => 'Fehler beim Aktualisieren des Angebots',
    'quote_list' => 'Angebotsliste',
    'general_information_about_quote' => 'Allgemeine Informationen zum Angebot...',
    'transaction_items' => 'Transaktionsposten',
    'add_item' => 'Posten hinzufügen',
    'e_g_consulting_services_project_management' => 'Z.B. Beratungsdienstleistungen, Projektmanagement',
    'total_information' => 'Gesamtinformationen',
    'update_quote' => 'Angebot aktualisieren',
    'new_quote' => 'Neues Angebot erstellen',
    'quote_information' => 'Angebotsinformationen',
    'quote_created_success' => 'Angebot #%s erfolgreich erstellt.',
    'error_creating_quote' => 'Fehler beim Erstellen des Angebots',
    'select_customer' => 'Kunde auswählen...',
    'add_new_customer' => 'Neuen Kunden hinzufügen',
    'valid_until' => 'Gültig bis',
    'products' => 'Produkte',
    'invoice_currency' => 'Rechnungswährung',
    'product_name' => 'Produktname',
    'quantity' => 'Menge',
    'unit_price' => 'Einzelpreis',
    'product_currency' => 'Produktwährung',
    'exchange_rate' => 'Wechselkurs',
    'vat' => 'MwSt',
    'vat_amount' => 'MwSt-Betrag',
    'total' => 'Gesamt',
    'subtotal' => 'Zwischensumme',
    'total_vat' => 'Gesamt MwSt',
    'discount' => 'Rabatt',
    'grand_total' => 'Gesamtbetrag',
    'save_quote' => 'Angebot speichern',
    'select_product' => 'Produkt auswählen',
    'search_product' => 'Produkt suchen...',
    'all_suppliers' => 'Alle Lieferanten',
    'no_products_found' => 'Keine Produkte gefunden',
    'select' => 'Auswählen',
    'remove' => 'Entfernen',
    'no_customer_selected' => 'Kein Kunde ausgewählt',
    'search_customer' => 'Kunde suchen',
    'customer' => 'Kunde',
    'error' => 'Fehler',
    'please_correct_errors' => 'Bitte beheben Sie die folgenden Fehler',
    'quote_without_stock_created' => 'Angebot ohne Bestand #%s erfolgreich erstellt.',
    'quote_without_stock' => 'Angebot ohne Bestand erstellen',
    'customer_required' => 'Kundenauswahl ist erforderlich.',
    'quote_date_required' => 'Angebotsdatum ist erforderlich.',
    'at_least_one_item_required' => 'Mindestens ein Posten ist erforderlich.',
    'general_description' => 'Allgemeine Beschreibung',
    'transaction_items' => 'Transaktionsposten',
    'add_item' => 'Posten hinzufügen',
    'description' => 'Beschreibung',
    'amount' => 'Betrag',
    'save_quote' => 'Angebot ohne Bestand speichern',
    'at_least_one_item' => 'Mindestens ein Posten ist erforderlich.',
    'customer_not_found' => 'Kunde nicht gefunden',
    'search_customer' => 'Kunde suchen...',
    'valid_until' => 'Gültig bis',
    'select' => 'Auswählen',
    'remove' => 'Entfernen',
    'no_customer_selected' => 'Kein Kunde ausgewählt',
    'e_g_consulting_services_project_management' => 'Z.B. Beratungsdienstleistungen, Projektmanagement',
    'grand_total' => 'Gesamtbetrag',
    'error_creating_quote' => 'Fehler beim Erstellen des Angebots',
    'quote_list' => 'Angebotsliste',
    'quote_deleted' => 'Angebot erfolgreich gelöscht.',
    'quote_converted' => 'Angebot in Rechnung umgewandelt.',
    'quote_cancelled' => 'Angebot storniert.',
    'beklemede' => 'Ausstehend',
    'onaylandı' => 'Bestätigt',
    'reddedildi' => 'Abgelehnt',
    'faturalastirildi' => 'In Rechnung gestellt',
    
    // Quote View Page / Angebotsansicht
    'invalid_quote_id' => 'Ungültige Angebots-ID.',
    'company_info_not_found' => 'Firmeninformationen nicht gefunden!',
    'quote_not_found' => 'Angebot nicht gefunden.',
    'quote_details' => 'Angebotsdetails',
    'download_pdf' => 'PDF herunterladen',
    'print' => 'Drucken',
    'back_to_quotes' => 'Zurück zur Angebotsliste',
    'company_logo' => 'Firmenlogo',
    'customer' => 'Kunde',
    'address_not_specified' => 'Keine Adresse angegeben',
    'no_phone' => 'Keine Telefonnummer',
    'quote_information' => 'Angebotsinformationen',
    'valid_until' => 'Gültig bis',
    'description' => 'Beschreibung',
    'amount' => 'Betrag',
    'product_service_name' => 'Produkt-/Dienstleistungsname',
    'quantity' => 'Menge',
    'unit_price_original' => 'Einzelpreis (Originalwährung)',
    'vat' => 'MwSt',
    'amount_quote_currency' => 'Betrag (Angebotswährung)',
    'no_quote_items' => 'Keine Angebotspositionen vorhanden.',
    'subtotal' => 'Zwischensumme',
    'total_vat' => 'Gesamt MwSt',
    'discount' => 'Rabatt',
    'grand_total' => 'Gesamtbetrag',
    'notes' => 'Hinweise',
    'price_currency_note' => 'Produktpreise werden in ihren Originalwährungen angezeigt, Beträge und Summen in der Angebotswährung (:currency).',
    'generated_by_odjoo' => 'Dieses Angebot wurde mit dem Begeb Creative Verwaltungssystem erstellt. | :website',
    'page_x_of_y' => 'Seite :current von :total',
    'quote_not_found_or_not_belongs' => 'Angebot nicht gefunden oder gehört nicht zu diesem Unternehmen.',
    'phone' => 'Tel.',
    'unit_price' => 'Einzelpreis',
    'quote_info' => 'Sehr geehrte(r) :name - Der Betrag dieses Angebots beträgt :amount.',
    'quote_info_with_days' => 'Sehr geehrte(r) :name - Der Betrag dieses Angebots beträgt :amount. Dieses Angebot ist :days Tage gültig.',
    
    // Quick Actions / Schnellzugriff
    'add_stock' => 'Bestand hinzufügen',
    'create_invoice' => 'Rechnung erstellen',
    'add_customer' => 'Kunde hinzufügen',
    'backup' => 'Sicherung erstellen',
    
    // Account Types / Kontotypen
    'bank' => 'Bank',
    'cash' => 'Kasse',
    'credit_card' => 'Kreditkarte',
    
    // Movement Types / Bewegungstypen
    'income_movement' => 'Eingang',
    'expense_movement' => 'Ausgang',
    'transfer_movement' => 'Überweisung',
    
    // Due Status / Fälligkeitsstatus
    'due_today' => 'Heute fällig',
    'days_remaining' => 'Noch :days Tage',
    'days_overdue' => ':days Tage überfällig',
    
    // System Messages / Systemmeldungen
    'no_company_assigned' => 'Sie wurden noch keinem Unternehmen zugewiesen!',
    'create_company_message' => 'Um das System nutzen zu können, müssen Sie ein neues Unternehmen erstellen.',
    'create_company' => 'Unternehmen erstellen',
    'system_info' => 'Begeb Creative v2.0 - Bitte erstellen Sie regelmäßig Sicherungen. Für Support kontaktieren Sie: :email',
    'no_data_available' => 'Keine Daten verfügbar.',
    'no_accounts_added' => 'Keine Konten hinzugefügt.',
    'no_movements_recorded' => 'Keine Kontobewegungen aufgezeichnet.',
    'no_due_receivables' => 'Keine fälligen oder überfälligen Forderungen vorhanden.',
    'no_due_payments' => 'Keine fälligen oder überfälligen Zahlungen vorhanden.',
    
    // Profile Settings / Profileinstellungen
    'profile_management' => 'Profilverwaltung',
    'general_information' => 'Allgemeine Informationen',
    'change_password' => 'Passwort ändern',
    'full_name' => 'Vollständiger Name',
    'username' => 'Benutzername',
    'old_password' => 'Altes Passwort',
    'new_password' => 'Neues Passwort',
    'confirm_new_password' => 'Neues Passwort bestätigen',
    'password_min_length' => 'Ihr Passwort muss mindestens 6 Zeichen lang sein.',
    'update_information' => 'Informationen aktualisieren',
    'change_password_button' => 'Passwort ändern',
    'language_settings' => 'Spracheinstellungen',
    'select_language' => 'Sprache auswählen',
    'language_updated' => 'Spracheinstellung erfolgreich aktualisiert!',
    
    // Validation Messages / Validierungsmeldungen
    'name_username_required' => 'Vollständiger Name und Benutzername dürfen nicht leer sein!',
    'username_already_exists' => 'Dieser Benutzername ist bereits vergeben. Bitte wählen Sie einen anderen.',
    'update_error' => 'Fehler beim Aktualisieren der Informationen: :error',
    'old_password_incorrect' => 'Das eingegebene alte Passwort ist falsch!',
    'passwords_not_match' => 'Die neuen Passwörter stimmen nicht überein!',
    'password_too_short' => 'Das neue Passwort muss mindestens 6 Zeichen lang sein!',
    'password_update_error' => 'Fehler beim Ändern des Passworts: :error',
    'information_updated' => 'Ihre Informationen wurden erfolgreich aktualisiert!',
    'password_changed' => 'Ihr Passwort wurde erfolgreich geändert!',
    
    // Currency / Währung
    'currency_symbol' => '€',
    'amount' => 'Betrag',
    'balance' => 'Saldo',
    'total' => 'Gesamt',
    
    // Time / Zeit
    'date' => 'Datum',
    'time' => 'Uhrzeit',
    'created_at' => 'Erstellt am',
    'updated_at' => 'Aktualisiert am',
    'last_login' => 'Letzte Anmeldung',
    
    // Status / Status
    'active' => 'Aktiv',
    'inactive' => 'Inaktiv',
    'pending' => 'Ausstehend',
    'completed' => 'Abgeschlossen',
    'cancelled' => 'Storniert',
    
    // Navigation / Navigation
    'home' => 'Startseite',
    'customers' => 'Kunden',
    'products' => 'Produkte',
    'invoices' => 'Rechnungen',
    'reports' => 'Berichte',
    'backups' => 'Sicherungen',
    'seller_info' => 'Verkäuferinformationen',
    'buyer_info' => 'Käuferinformationen',
    'page' => 'Seite',
    'vat' => 'MwSt',
    'grand_total' => 'Gesamtbetrag',
    'users' => 'Benutzer',
    'companies' => 'Unternehmen',
    
    // Common Actions / Allgemeine Aktionen
    'view' => 'Anzeigen',
    'print' => 'Drucken',
    'download' => 'Herunterladen',
    'upload' => 'Hochladen',
    'refresh' => 'Aktualisieren',
    'reset' => 'Zurücksetzen',
    'clear' => 'Löschen',
    'select_all' => 'Alle auswählen',
    'deselect_all' => 'Auswahl aufheben',
    
    // Months / Monate
    'january' => 'Januar',
    'february' => 'Februar',
    'march' => 'März',
    'april' => 'April',
    'may' => 'Mai',
    'june' => 'Juni',
    'july' => 'Juli',
    'august' => 'August',
    'september' => 'September',
    'october' => 'Oktober',
    'november' => 'November',
    'december' => 'Dezember',
    
    // Product Management / Produktverwaltung
    'product_management' => 'Produktverwaltung',
    'stock_purchase_value' => 'Einkaufswert des Bestands',
    'total_value_in_tl' => 'Gesamtwert in Euro',
    'stock_sales_value' => 'Verkaufswert des Bestands',
    'product_variety' => 'Produktvielfalt',
    'total_stock' => 'Gesamtbestand',
    'search_product' => 'Produkt suchen',
    'product_name_or_barcode' => 'Produktname oder Barcode...',
    'all_categories' => 'Alle Kategorien',
    'no_products_yet' => 'Noch keine Produkte vorhanden.',
    'no_products_matching_criteria' => 'Keine Produkte entsprechen den Suchkriterien.',
    'add_first_product' => 'Erstes Produkt hinzufügen',
    'add_new_product' => 'Neues Produkt hinzufügen',
    'image' => 'Bild',
    'stock' => 'Lager',
    'total_value' => 'Gesamtwert',
    'stock_detail_analysis' => 'Detaillierte Bestandsanalyse',
    'product_details_stock_analysis' => 'Produktdetails, Bestandsbewegungen und Finanzanalyse',
    'product_list' => 'Produktliste',
    'all_movements' => 'Alle Bewegungen',
    'current_stock' => 'Aktueller Bestand',
    'current_quantity' => 'Aktuelle Menge',
    'total_entry' => 'Gesamteingang',
    'all_time' => 'Gesamtzeitraum',
    'total_exit' => 'Gesamtausgang',
    'profit_loss' => 'Gewinn/Verlust',
    'purchase_prices' => 'Einkaufspreise',
    'purchase_price' => 'Einkaufspreis',
    'purchase_price_2' => 'Einkaufspreis 2',
    'average_cost' => 'Durchschnittskosten',
    'sales_prices' => 'Verkaufspreise',
    'sale_price' => 'Verkaufspreis',
    'sale_price_2' => 'Verkaufspreis 2',
    'profit_margin' => 'Gewinnspanne',
    'stock_status' => 'Lagerstatus',
    'critical_stock' => 'Mindestbestand',
    'stock_value' => 'Lagerwert',
    'filter_options' => 'Filteroptionen',
    'filter_description' => 'Bestandsbewegungen nach bestimmten Kriterien filtern',
    'customer_supplier' => 'Kunde/Lieferant',
    'all' => 'Alle',
    'movement_type' => 'Bewegungstyp',
    'entry' => 'Eingang',
    'exit' => 'Ausgang',
    'inventory' => 'Inventur',
    'transfer' => 'Umbuchung',
    'start_date' => 'Anfangsdatum',
    'end_date' => 'Enddatum',
    'filter' => 'Filtern',
    'date' => 'Datum',
    'amount' => 'Menge',
    'unit_price' => 'Stückpreis',
    'total_amount' => 'Gesamtbetrag',
    'invoice_info' => 'Rechnungsinformation',
    'description' => 'Beschreibung',
    'user' => 'Benutzer',
    'no_movements_found' => 'Keine Bestandsbewegungen gefunden, die den Kriterien entsprechen.',
    'unknown' => 'Unbekannt',
    'in_currency' => 'in',
    'stock_movement_summary' => 'Bestandsbewegungsübersicht',
    'last_30_days' => 'Letzte 30 Tage',
    'this_month' => 'Diesen Monat',
    'stock_movements' => 'Bestandsbewegungen',
    'product_list' => 'Produktliste',
    'error_loading_product_list' => 'Fehler beim Laden der Produktliste.',
    'error_loading_stock_movements' => 'Datenbankfehler beim Laden der Bestandsbewegungen.',
    'no_stock_movements_yet' => 'Noch keine Bestandsbewegungen vorhanden.',
    'product_name_detail' => 'Produktname / Details',
    'transaction_type' => 'Transaktionstyp',
    'entry' => 'Eingang',
    'exit' => 'Ausgang',
    'current' => 'Aktuell',
    'info' => 'Info',
    'add_product' => 'Produkt hinzufügen',
    'product_information' => 'Produktinformationen',
    'piece' => 'Stück',
    'kilogram' => 'Kilogramm',
    'gram' => 'Gramm',
    'liter' => 'Liter',
    'meter' => 'Meter',
    'package' => 'Paket',
    'box' => 'Karton',
    'barcode' => 'Barcode',
    'read' => 'Lesen',
    'barcode_reader_help' => 'Sie können mit einem Barcodescanner scannen oder manuell eingeben.',
    'select_category' => '-- Kategorie auswählen --',
    'purchase_price' => 'Einkaufspreis',
    'currency' => 'Währung',
    'selling_price' => 'Verkaufspreis',
    'vat_rate' => 'Mehrwertsteuersatz (%)',
    'vat_free' => 'MwSt-frei',
    'critical_stock_quantity' => 'Mindestbestandsmenge',
    'warning_below_quantity' => 'Warnung bei Unterschreitung dieser Menge.',
    'current_stock_initial' => 'Aktueller Bestand (Anfangsbestand)',
    'initial_stock_help' => 'Der anfängliche Lagerbestand des Produkts bei der Erfassung.',
    'product_images' => 'Produktbilder',
    'upload_image' => 'Bild hochladen',
    'multiple_images_help' => 'Sie können mehrere Bilder auswählen. Unterstützte Formate: JPG, PNG.',
    'save_product' => 'Produkt speichern',
    'product_added_successfully' => 'Produkt erfolgreich hinzugefügt.',
    'error_adding_product' => 'Fehler beim Hinzufügen des Produkts.',
    'product_name_required' => 'Produktname ist erforderlich.',
    'valid_purchase_price_required' => 'Bitte geben Sie einen gültigen Einkaufspreis ein.',
    'valid_selling_price_required' => 'Bitte geben Sie einen gültigen Verkaufspreis ein.',
    'vat_rate_range' => 'Der MwSt-Satz muss zwischen 0 und 100 liegen.',
    'valid_critical_stock_required' => 'Bitte geben Sie eine gültige Mindestbestandsmenge ein.',
    'barcode_already_used' => 'Dieser Barcode wird in diesem Unternehmen bereits verwendet.',
    'please_correct_errors' => 'Bitte korrigieren Sie die Fehler',
    'delete_product' => 'Produkt löschen',
    'attention' => 'Achtung!',
    'delete_warning' => 'Sie sind dabei, dieses Produkt zu löschen. Diese Aktion kann nicht rückgängig gemacht werden!',
    'when_product_deleted' => 'Wenn das Produkt gelöscht wird:',
    'removed_from_list' => 'Wird aus der Produktliste entfernt',
    'cannot_use_new_transactions' => 'Kann nicht für neue Verkaufs-/Einkaufsvorgänge verwendet werden',
    'existing_records_preserved' => 'Bestehende Rechnungen und Bestandsbewegungen bleiben erhalten',
    'usage_status' => 'Nutzungsstatus',
    'product_to_delete' => 'Zu löschendes Produkt',
    'uncategorized' => 'Nicht kategorisiert',
    'created_date' => 'Erstellungsdatum',
    'delete_confirmation' => 'Löschbestätigung',
    'type_yes_to_confirm' => 'Bitte geben Sie <strong>"JA"</strong> ein, um das Löschen zu bestätigen:',
    'type_yes_placeholder' => 'JA eingeben...',
    'product_deleted_successfully' => 'Produkt erfolgreich gelöscht.',
    'must_type_yes' => 'Sie müssen "JA" eingeben, um fortzufahren.',
    'invalid_product_id' => 'Ungültige Produkt-ID.',
    'product_not_found_or_not_belongs' => 'Produkt nicht gefunden oder gehört nicht zu diesem Unternehmen.',
    'error_loading_product' => 'Fehler beim Laden der Produktinformationen.',
    'product_used_in_invoices' => 'Dieses Produkt wird in :count Rechnungspositionen verwendet.',
    'product_has_stock_movements' => 'Es gibt :count Bestandsbewegungen für dieses Produkt.',
    'product_used_in_quotes' => 'Dieses Produkt wird in :count Angebotspositionen verwendet.',
    'error_deleting_product' => 'Fehler beim Löschen des Produkts.',
    'invalid_request_method' => 'Ungültige Anforderungsmethode.',
    'min_2_chars_or_select_supplier' => 'Bitte geben Sie mindestens 2 Zeichen ein oder wählen Sie einen Lieferanten aus.',
    'search_error' => 'Fehler bei der Suche',
    
    // Stock Reports / Bestandsberichte
    'detailed_stock_reports' => 'Detaillierte Bestandsberichte',
    'report_filters' => 'Berichtsfilter',
    'report_type' => 'Berichtstyp',
    'movement_details' => 'Bewegungsdetails',
    'product_summary' => 'Produktübersicht',
    'customer_supplier_summary' => 'Kunden-/Lieferantenübersicht',
    'stock_movements' => 'Bestandsbewegungen',
    'product' => 'Produkt',
    'all_products' => 'Alle Produkte',
    'customer_supplier' => 'Kunde/Lieferant',
    'all' => 'Alle',
    'entry_purchase' => 'Eingang (Einkauf)',
    'exit_sale' => 'Ausgang (Verkauf)',
    'inventory_count' => 'Inventur',
    'get_report' => 'Bericht abrufen',
    'reset' => 'Zurücksetzen',
    'stock_movement_details' => 'Bestandsbewegungsdetails',
    'product_summary_report' => 'Produktübersichtsbericht',
    'no_data_found' => 'Keine Daten gefunden, die den ausgewählten Kriterien entsprechen.',
    'date_range' => 'Zeitraum',
    'start_date' => 'Anfangsdatum',
    'end_date' => 'Enddatum',
    'transaction_type' => 'Transaktionstyp',
    'all_transactions' => 'Alle Transaktionen',
    'entry' => 'Eingang',
    'exit' => 'Ausgang',
    'date' => 'Datum',
    'total_amount' => 'Gesamtbetrag',
    'unit_price' => 'Stückpreis',
    'description' => 'Beschreibung',
    'process_type' => 'Prozessart',
    'product_name' => 'Produktname',
    'total_entry' => 'Gesamteingang',
    'total_exit' => 'Gesamtausgang',
    'net_quantity' => 'Nettomenge',
    'entry_amount' => 'Eingangsbetrag',
    'exit_amount' => 'Ausgangsbetrag',
    'net_amount' => 'Nettobetrag',
    'transaction_count' => 'Anzahl Transaktionen',
    'current_stock' => 'Aktueller Bestand',
    'customer_name' => 'Kundenname',
    'total_purchase_quantity' => 'Gesamtmenge Einkauf',
    'total_sales_quantity' => 'Gesamtmenge Verkauf',
    'total_purchase_amount' => 'Gesamtbetrag Einkauf',
    'total_sales_amount' => 'Gesamtbetrag Verkauf',
    'different_products' => 'Verschiedene Produkte',
    'total_transactions' => 'Gesamttransaktionen',
    'total_entry_quantity' => 'Gesamteingangsmenge',
    'total_exit_quantity' => 'Gesamtausgangsmenge',
    'purchase_prices' => 'Einkaufspreise',
    'purchase_price' => 'Einkaufspreis 1',
    'purchase_price_2' => 'Einkaufspreis 2',
    'average_cost' => 'Durchschnittskosten',
    'sales_prices' => 'Verkaufspreise',
    'sale_price' => 'Verkaufspreis 1',
    'sale_price_2' => 'Verkaufspreis 2',
    'profit_margin' => 'Gewinnspanne',
    'stock_status' => 'Lagerstatus',
    'filter_options' => 'Filteroptionen',
    'filter_description' => 'Bestandsbewegungen nach bestimmten Kriterien filtern',
    'last_30_days' => 'Letzte 30 Tage',
    'this_month' => 'Diesen Monat',
    'critical_stock' => 'Mindestbestand',
    'stock_value' => 'Lagerwert',
    'profit_margin_1' => 'Gewinnspanne 1',
    'start' => 'Anfang',
    'end' => 'Ende',
    'current_quantity' => 'Aktuelle Menge',
    'all_time' => 'Gesamtzeitraum',
    'stock_detail' => 'Bestandsdetails',
    'all_movements' => 'Alle Bewegungen',
    'customer_supplier' => 'Kunde/Lieferant',
    'profit_margin' => 'Gewinnspanne',
    'average_exit_price' => 'Durchschnittlicher Ausgangspreis',
    'average_entry_price' => 'Durchschnittlicher Eingangspreis',
    'stock_turnover_rate' => 'Lagerumschlagshäufigkeit',
    'performance_analysis' => 'Leistungsanalyse',
    'movement_type' => 'Bewegungsart',
    'invoice_info' => 'Rechnungsinformationen',
    'financial_summary' => 'Finanzübersicht',
    'total_purchase_amount' => 'Gesamtbetrag Einkauf',
    'total_sales_amount' => 'Gesamtbetrag Verkauf',
    'current_stock_value' => 'Aktueller Lagerwert',
    'total_profit_loss' => 'Gesamtgewinn/-verlust',
    'product_management' => 'Produktverwaltung',
    'add_new_product' => 'Neues Produkt hinzufügen',
    'product_variety' => 'Produktvielfalt',
    'total_stock' => 'Gesamtbestand',
    'stock_purchase_value' => 'Einkaufswert des Bestands',
    'stock_sale_value' => 'Verkaufswert des Bestands',
    'total_value_in_tl' => 'Gesamtwert in Euro',
    'product_search' => 'Produktsuche',
    'product_search_placeholder' => 'Produktname oder Barcode...',
    'category' => 'Kategorie',
    'all_categories' => 'Alle Kategorien',
    'search' => 'Suchen',
    'product_list' => 'Produktliste',
    'no_products_added' => 'Noch keine Produkte hinzugefügt.',
    'no_products_found' => 'Keine Produkte gefunden, die den Suchkriterien entsprechen.',
    'add_first_product' => 'Erstes Produkt hinzufügen',
    'image' => 'Bild',
    'product_name' => 'Produktname',
    'barcode' => 'Barcode',
    'unit' => 'Einheit',
    'purchase_price' => 'Einkaufspreis',
    'sale_price' => 'Verkaufspreis',
    'vat' => 'MwSt',
    'vat_free' => 'Ohne MwSt',
    'stock' => 'Lager',
    'critical_stock_level' => 'Mindestbestand',
    'total_value' => 'Gesamtwert',
    'actions' => 'Aktionen',
    'edit' => 'Bearbeiten',
    'stock_detail_analysis' => 'Detaillierte Bestandsanalyse',
    'stock_movements' => 'Bestandsbewegungen',
    // Product Edit Page
    'edit_product' => 'Produkt bearbeiten',
    'invalid_product_id' => 'Ungültige Produkt-ID.',
    'product_not_found' => 'Produkt nicht gefunden oder gehört nicht zu diesem Unternehmen.',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'product_name_required' => 'Produktname ist erforderlich.',
    'valid_purchase_price' => 'Bitte geben Sie einen gültigen Einkaufspreis ein.',
    'valid_sale_price' => 'Bitte geben Sie einen gültigen Verkaufspreis ein.',
    'valid_vat_rate' => 'Der MwSt-Satz muss zwischen 0 und 100 liegen.',
    'barcode_in_use' => 'Dieser Barcode wird bereits von einem anderen Produkt verwendet.',
    'product_updated' => 'Produktinformationen erfolgreich aktualisiert.',
    'product_update_error' => 'Fehler beim Aktualisieren des Produkts.',
    'image_upload_error' => 'Fehler beim Hochladen des Produktbildes.',
    'image_uploaded' => 'Neues Bild erfolgreich hinzugefügt.',
    'product_list' => 'Produktliste',
    'delete' => 'Löschen',
    'delete_confirm' => 'Sind Sie sicher, dass Sie dieses Produkt und alle damit verbundenen Bestandsdatensätze dauerhaft löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden.',
    'product_info' => 'Produktinformationen',
    'product_name' => 'Produktname',
    'unit' => 'Einheit',
    'piece' => 'Stück',
    'kg' => 'Kilogramm',
    'gram' => 'Gramm',
    'liter' => 'Liter',
    'meter' => 'Meter',
    'package' => 'Packung',
    'box' => 'Karton',
    'purchase_price' => 'Einkaufspreis',
    'sale_price' => 'Verkaufspreis',
    'vat_rate' => 'Mehrwertsteuersatz',
    'barcode' => 'Barcode',
    'category' => 'Kategorie',
    'select_category' => 'Kategorie auswählen',
    'critical_stock' => 'Mindestbestand',
    'initial_stock' => 'Anfangsbestand',
    'description' => 'Beschreibung',
    'save_changes' => 'Änderungen speichern',
    'product_images' => 'Produktbilder',
    'set_as_default' => 'Als Standard festlegen',
    'delete_image' => 'Bild löschen',
    'add_image' => 'Bild hinzufügen',
    'drag_drop_image' => 'Bild hierher ziehen und ablegen oder klicken',
    'or' => 'oder',
    'browse' => 'Durchsuchen',
    'upload' => 'Hochladen',
    'please_fix_errors' => 'Bitte beheben Sie folgende Fehler:',
    'product_information' => 'Produktinformationen',
    'product_images' => 'Produktbilder',
    'upload_selected' => 'Ausgewählte hochladen',
    'initial_stock_note' => 'Dies ist nur der Anfangsbestandswert und kann nicht bearbeitet werden',
    'stock_movements' => 'Bestandsbewegungen',
    'update_information' => 'Informationen aktualisieren',
    'low_stock_warning' => 'Warnung bei Unterschreitung dieser Menge',
    'critical_stock_amount' => 'Mindestbestandsmenge',
    'add_product' => 'Produkt hinzufügen',
    'barcode_scan' => 'Scannen',
    'barcode_scan_help' => 'Mit Barcodescanner scannen oder manuell eingeben',
    'vat_free' => 'Ohne MwSt',
    'vat_included' => 'Inkl. MwSt',
    'upload_image' => 'Bild hochladen',
    'multiple_images_help' => 'Mehrere Bilder können ausgewählt werden. Unterstützte Formate: JPG, PNG',
    'save_product' => 'Produkt speichern',
    'cancel' => 'Abbrechen',
    'back_to_products' => 'Zurück zur Produktliste',
    'product_added_success' => 'Produkt erfolgreich hinzugefügt',
    'error_adding_product' => 'Fehler beim Hinzufügen des Produkts',
    'invalid_form_submission' => 'Ungültige Formularübermittlung',
    'barcode_already_exists' => 'Dieser Barcode wird bereits verwendet',
    'invalid_price' => 'Ungültiger Preiswert',
    'invalid_stock_value' => 'Ungültiger Bestandswert',
    'invalid_vat_rate' => 'Ungültiger MwSt-Satz (muss zwischen 0 und 100 liegen)',
    
    // Account Transactions / Kontobewegungen
    'transaction_id' => 'Transaktions-Nr.',
    'transaction_type' => 'Transaktionstyp',
    'entry' => 'Eingang',
    'exit' => 'Ausgang',
    'transfer' => 'Überweisung',
    'entry_collection' => 'Eingang (Zahlungseingang usw.)',
    'exit_payment' => 'Ausgang (Zahlungsausgang usw.)',
    'all_accounts' => 'Alle Konten',
    'all_customers' => 'Alle Kunden',
    'all_types' => 'Alle Typen',
    'apply_filter' => 'Filter anwenden',
    'clear_filter' => 'Filter zurücksetzen',
    'no_transactions_found' => 'Keine Kontobewegungen gefunden, die den ausgewählten Kriterien entsprechen.',
    'target' => 'Ziel',
    'debt_id' => 'Schulden-ID',
    'invoice' => 'Rechnung',
    'download_receipt' => 'Beleg herunterladen',
    'view_details' => 'Details anzeigen',
    'edit' => 'Bearbeiten',
    'delete' => 'Löschen',
    'multiple' => 'Mehrfach',
    'confirm_delete_transaction' => 'Sind Sie sicher, dass Sie diese Kontobewegung löschen möchten?',
    'transaction_deleted_successfully' => 'Kontobewegung erfolgreich gelöscht.',
    'error_deleting_transaction' => 'Fehler beim Löschen der Kontobewegung. Bitte versuchen Sie es erneut.',
    'transaction_updated_successfully' => 'Kontobewegung erfolgreich aktualisiert.',
    'error_updating_transaction' => 'Fehler beim Aktualisieren der Kontobewegung. Bitte versuchen Sie es erneut.',
    'details_not_loaded' => 'Details konnten nicht geladen werden',
    'unknown_error' => 'Unbekannter Fehler',
    
    // Account Statement / Kontoauszug
    'account_statement' => 'Kontoauszug',
    'statement' => 'Auszug',
    'please_select_an_account' => 'Bitte wählen Sie ein Konto aus',
    'period_selection' => 'Zeitraumauswahl',
    'start_date' => 'Anfangsdatum',
    'end_date' => 'Enddatum',
    'get' => 'Abrufen',
    'this_month' => 'Diesen Monat',
    'last_month' => 'Letzter Monat',
    'download_pdf' => 'PDF herunterladen',
    'print' => 'Drucken',
    'date' => 'Datum',
    'description' => 'Beschreibung',
    'debit' => 'Soll',
    'credit' => 'Haben',
    'balance' => 'Saldo',
    'opening_balance' => 'Anfangssaldo',
    'before' => 'vorher',
    'no_transactions_found_in_selected_period' => 'Keine Transaktionen im ausgewählten Zeitraum gefunden.',
    'period_totals' => 'Zeitraumsummen',
    'closing_balance' => 'Schlusssaldo',
    'selected_account_not_found_or_error_loading' => 'Das ausgewählte Konto wurde nicht gefunden oder konnte nicht geladen werden.',
    'please_select_an_account_to_view_statement' => 'Bitte wählen Sie oben ein Konto aus, um den Kontoauszug anzuzeigen.',
    'no_accounts_found_in_system' => 'Keine Konten im System gefunden.',
    'specified_account_id_not_found_or_not_belongs_to_company' => 'Die angegebene Konto-ID wurde nicht gefunden oder gehört nicht zu diesem Unternehmen.',
    'database_error_while_creating_statement' => 'Beim Erstellen des Kontoauszugs ist ein Datenbankfehler aufgetreten.',
    
    // Cash Expense Receipts / Kassenausgangsbelege
    'cash_expense_receipts' => 'Kassenausgangsbelege',
    'and_transactions' => 'und Überweisungen',
    'new_receipt' => 'Neuer Beleg',
    'total_receipts' => 'Belege gesamt',
    'total_expense' => 'Gesamtausgaben',
    'average_expense' => 'Durchschnittsausgaben',
    'minimum_expense' => 'Mindestausgaben',
    'maximum_expense' => 'Höchstausgaben',
    'filtering_and_search' => 'Filter und Suche',
    'search_description' => 'Beschreibung durchsuchen',
    'search_description_placeholder' => 'Beschreibung suchen...',
    'filter' => 'Filtern',
    'clear' => 'Zurücksetzen',
    'cash_expense_receipts_and_transactions' => 'Kassenausgangsbelege und Überweisungen',
    'no_cash_expense_receipts_found' => 'Keine Kassenausgangsbelege gefunden, die den Kriterien entsprechen.',
    'transaction_type' => 'Transaktionstyp',
    'actions' => 'Aktionen',
    'transfer_out' => 'Überweisung Ausgang',
    'expense' => 'Ausgabe',
    'view_pdf' => 'PDF anzeigen',
    'page_navigation' => 'Seitennavigation',
    'edit_cash_expense_receipt' => 'Kassenausgangsbeleg bearbeiten',
    'update' => 'Aktualisieren',
    'confirm_receipt_deletion' => 'Beleg löschen bestätigen',
    'are_you_sure_delete_receipt' => 'Sind Sie sicher, dass Sie diesen Kassenausgangsbeleg löschen möchten?',
    'warning' => 'Warnung',
    'this_action_cannot_be_undone' => 'Diese Aktion kann nicht rückgängig gemacht werden und der Belegbetrag wird dem Konto wieder gutgeschrieben.',
    'yes_delete' => 'Ja, löschen',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'cash_expense_receipt_updated_successfully' => 'Kassenausgangsbeleg erfolgreich aktualisiert.',
    'record_to_update_not_found' => 'Zu aktualisierender Datensatz nicht gefunden.',
    'error_occurred_while_updating' => 'Fehler beim Aktualisieren',
    'please_fill_all_fields_correctly' => 'Bitte füllen Sie alle Felder korrekt aus.',
    'invalid_security_key' => 'Ungültiger Sicherheitsschlüssel!',
    'cash_expense_receipt_deleted_successfully' => 'Kassenausgangsbeleg erfolgreich gelöscht.',
    'record_to_delete_not_found' => 'Zu löschender Datensatz nicht gefunden.',
    'error_occurred_while_deleting' => 'Fehler beim Löschen',
    'cash_expense_receipt_updated' => 'Kassenausgangsbeleg aktualisiert',
    
    // Reports Page Additions / Berichte
    'odjoo_management' => 'Begeb Creative Verwaltung',
    'date_range_filtering' => 'Datumsbereichsfilterung',
    
    // Financial Reports / Finanzberichte
    'debts_by_category' => 'Schulden nach Kategorie',
    'delay' => 'Verzögerung',
    'description' => 'Beschreibung',
    'receivable' => 'Forderung',
    'debt' => 'Schulden',
    'day_late_singular' => 'Tag überfällig',
    'days_late_plural' => 'Tage überfällig',
    'total_liabilities' => 'Gesamtverbindlichkeiten',
    'equity_percentage' => 'Eigenkapital %',
    'net_current_position' => 'Netto-Umlaufvermögen',
    'our_total_receivables' => 'Unsere Gesamtforderungen',
    'receivables_from_customers' => 'Forderungen aus Lieferungen und Leistungen',
    'our_total_debts' => 'Unsere Gesamtschulden',
    'debts_to_suppliers' => 'Verbindlichkeiten aus Lieferungen und Leistungen',
    'total_stock_value_original' => 'Gesamter Lagerbestandswert (Original)',
    'multiple_currencies' => 'Mehrere Währungen',
    'stock_information' => 'Bestandsinformationen',
    'stock_product_count' => 'Bestandteile',
    'total_product_variety' => 'Gesamtproduktvielfalt',
    'total_stock_quantity' => 'Gesamtbestandsmenge',
    'filter' => 'Filtern',
    'clear_filter' => 'Filter zurücksetzen',
    'total_balance' => 'Gesamtsaldo',
    'total_assets' => 'Gesamtvermögen',
    'financial_status' => 'Finanzstatus',
    'our_receivables_exceed_debts' => 'Unsere Forderungen übersteigen die Schulden',
    'our_debts_exceed_receivables' => 'Unsere Schulden übersteigen die Forderungen',
    'net_position' => 'Netto-Position',
    'cash_expense_receipt_deleted' => 'Kassenausgangsbeleg gelöscht',
    
    // User Management / Benutzerverwaltung
    'user_management' => 'Benutzerverwaltung',
    'no_permission_to_access_this_page' => 'Sie haben keine Berechtigung, auf diese Seite zuzugreifen.',
    'company_selection_required' => 'Bitte wählen Sie ein Unternehmen aus, um auf diese Seite zuzugreifen.',
    'user_status_updated_successfully' => 'Benutzerstatus erfolgreich aktualisiert.',
    'admin' => 'Administrator',
    'manager' => 'Manager',
    'user' => 'Benutzer',
    'users' => 'Benutzer',
    'guest' => 'Gast',
    'odjoo_management' => 'Begeb Creative Verwaltung',
    'new_user' => 'Neuer Benutzer',
    'filters' => 'Filter',
    'permission_level' => 'Berechtigungsstufe',
    'all' => 'Alle',
    'status' => 'Status',
    'active' => 'Aktiv',
    'inactive' => 'Inaktiv',
    'search_users_placeholder' => 'Benutzername, vollständiger Name oder E-Mail',
    'username' => 'Benutzername',
    'full_name' => 'Vollständiger Name',
    'email' => 'E-Mail',
    'actions' => 'Aktionen',
    'you' => 'Sie',
    'no_users_found' => 'Keine Benutzer gefunden',
    'no_users_matching_criteria' => 'Keine Benutzer entsprechen den angegebenen Kriterien.',
    'last_login' => 'Letzte Anmeldung',
    'registration_date' => 'Registrierungsdatum',
    'login_count' => '%d Anmeldungen',
    'never_logged_in' => 'Noch nie angemeldet',
    'created_by' => 'Erstellt von: %s',
    'deactivate' => 'Deaktivieren',
    'activate' => 'Aktivieren',
    'confirm_change_user_status' => 'Möchten Sie den Benutzerstatus wirklich ändern?',
    'confirm_delete_user' => 'Möchten Sie diesen Benutzer wirklich löschen? Diese Aktion kann nicht rückgängig gemacht werden!',
    'database_error' => 'Datenbankfehler',
    'edit_user' => 'Benutzer bearbeiten',
    'invalid_user_id' => 'Ungültige Benutzer-ID.',
    'user_not_found' => 'Benutzer nicht gefunden.',
    'error_loading_user' => 'Fehler beim Laden der Benutzerdaten.',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'username_required' => 'Benutzername ist erforderlich.',
    'full_name_required' => 'Vollständiger Name ist erforderlich.',
    'permission_level_required' => 'Berechtigungsstufe ist erforderlich.',
    'password_min_length' => 'Das Passwort muss mindestens 6 Zeichen lang sein.',
    'passwords_do_not_match' => 'Die Passwörter stimmen nicht überein.',
    'user_updated_successfully' => 'Benutzer erfolgreich aktualisiert.',
    'error_updating_user' => 'Fehler beim Aktualisieren des Benutzers.',
    'please_correct_errors' => 'Bitte korrigieren Sie die Fehler',
    'new_password_leave_blank' => 'Neues Passwort (leer lassen, um nicht zu ändern)',
    'confirm_new_password' => 'Neues Passwort bestätigen',
    'update_user' => 'Benutzer aktualisieren',
    'go_back' => 'Zurück',
    
    // Reports / Berichte
    'reports' => 'Berichte',
    'income_expense_summary' => 'Einnahmen-Ausgaben-Übersicht',
    'account_balances' => 'Kontostände',
    'overdue_debts_credits' => 'Überfällige Schulden/Forderungen',
    'financial_status_summary' => 'Finanzstatus-Übersicht',
    'liabilities' => 'Verbindlichkeiten',
    'net_worth' => 'Reinvermögen',
    'stock_value_report' => 'Lagerbestandsbericht',
    'in_tl' => 'In EUR',
    'debug_information' => 'Debug-Informationen',
    'total_income' => 'Gesamteinnahmen',
    'total_expense' => 'Gesamtausgaben',
    'net_status' => 'Netto-Status',
    'account_name' => 'Kontobezeichnung',
    'account_type' => 'Kontotyp',
    'balance' => 'Saldo',
    'no_overdue_debts_or_credits_found' => 'Keine überfälligen Schulden oder Forderungen gefunden.',
    'assets' => 'Vermögen',
    'cash_bank' => 'Kasse & Bank',
    'customer_receivables' => 'Kundenforderungen',
    'stock_value' => 'Lagerwert',
    'supplier_debts' => 'Lieferantenverbindlichkeiten',
    'credit_card' => 'Kreditkarte',
    'type' => 'Typ',
    'current' => 'Aktuell',
    'amount' => 'Betrag',
    'due_date' => 'Fälligkeitsdatum',
    'product_name' => 'Produktname',
    'stock_quantity' => 'Bestandsmenge',
    'unit_purchase_price' => 'Einstandspreis',
    'original_value' => 'Ursprünglicher Wert',
    'equivalent_in_tl' => 'In EUR',
    'exchange_rates' => 'Wechselkurse',
    'currency' => 'Währung',
    'rate' => 'Kurs',
    'days_late' => 'Tage überfällig',
    'days_late_singular' => 'Tag überfällig',
    'days_late_plural' => 'Tage überfällig',
    'an_error_occurred_while_retrieving_reports_please_try_again_later' => 'Beim Abrufen der Berichte ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.',
    'assets_liabilities' => 'Vermögen - Verbindlichkeiten',
    'save_changes' => 'Änderungen speichern',
    'customer_name_label' => 'Name',
    'phone_label' => 'Telefon',
    'address_label' => 'Adresse',
    'customer_group_label' => 'Kundengruppe',
    'invalid_company' => 'Sie haben keine Berechtigung für diese Aktion.',
    
    // User Management / Benutzerverwaltung
    'add_new_user' => 'Neuen Benutzer hinzufügen',
    'user_information' => 'Benutzerinformationen',
    'username_allowed_chars' => 'Nur Buchstaben, Zahlen, Unterstriche und Punkte erlaubt',
    'password' => 'Passwort',
    'confirm_password' => 'Passwort bestätigen',
    'description' => 'Beschreibung',
    'user_active' => 'Benutzer ist aktiv',
    'add_user' => 'Benutzer hinzufügen',
    'user_added_successfully' => 'Benutzer erfolgreich hinzugefügt',
    'error_adding_user' => 'Fehler beim Hinzufügen des Benutzers',
    'permission_level_descriptions' => 'Berechtigungsstufen-Beschreibungen',
    'can_do_all_operations' => 'Kann alle Operationen durchführen',
    'system_settings' => 'Systemeinstellungen',
    'log_records' => 'Protokolleinträge',
    'stock_management' => 'Bestandsverwaltung',
    'sales_purchase_operations' => 'Verkaufs-/Kaufvorgänge',
    'current_account_management' => 'Kontoverwaltung',
    'account_management' => 'Kontoverwaltung',
    'reports_and_invoices' => 'Berichte und Rechnungen',
    'sales_operations' => 'Verkaufsvorgänge',
    'view_stock' => 'Bestand anzeigen',
    'view_current_account' => 'Konto anzeigen',
    'invoice_operations' => 'Rechnungsvorgänge',
    'only_view_stock' => 'Nur Bestandsansicht',
    'view_reports' => 'Berichte anzeigen',
    
    // Log Management / Protokollverwaltung
    'record_restored_successfully' => 'Datensatz erfolgreich wiederhergestellt.',
    'error_restoring_record' => 'Fehler beim Wiederherstellen des Datensatzes.',
    'operation_type' => 'Vorgangstyp',
    'table' => 'Tabelle',
    'date_time' => 'Datum/Zeit',
    'operation' => 'Vorgang',
    'record_id' => 'Datensatz-ID',
    'ip_address' => 'IP-Adresse',
    'system' => 'System',
    'view' => 'Anzeigen',
    'confirm_restore_record' => 'Möchten Sie diesen Datensatz wirklich wiederherstellen?',
    'restore' => 'Wiederherstellen',
    'restored' => 'Wiederhergestellt',
    'no_restore_info' => 'Keine Wiederherstellungsinformationen',
    'log_details' => 'Protokolldetails',
    'user_agent' => 'Benutzeragent',
    'old_values' => 'Alte Werte',
    'new_values' => 'Neue Werte',
    'previous' => 'Zurück',
    'next' => 'Weiter',
    'no_logs_found' => 'Keine Protokolleinträge gefunden',
    'no_logs_matching_criteria' => 'Keine Protokolleinträge entsprechen den angegebenen Kriterien.',
    
    // Settings / Einstellungen
    'site_settings' => 'Website-Einstellungen',
    'settings_menu' => 'Einstellungsmenü',
    'module_settings' => 'Moduleinstellungen',
    'cash_and_bank_accounts' => 'Kasse und Bankkonten',
    'categories' => 'Kategorien',
    'current_account_groups' => 'Kundengruppen',
    'stock_settings' => 'Bestandseinstellungen',
    'invoices' => 'Rechnungen',
    'invoice_settings' => 'Rechnungseinstellungen',
    'show_product_quantities_in_invoices' => 'Produktmengen in Rechnungen anzeigen?',
    'show_product_quantities_in_invoices_help' => 'Wenn diese Option aktiviert ist, werden die Mengen (Stückzahlen) der Produkte in den Rechnungen angezeigt.',
    'total_products' => 'Gesamtprodukte',
    'total_products_in_invoice' => 'Insgesamt %s Produkte vorhanden.',
    'items' => 'Artikel',
    'company_management' => 'Unternehmensverwaltung',
    'permission_levels' => 'Berechtigungsstufen',
    'screen_lock' => 'Bildschirmsperre',
    
    // Module Settings / Moduleinstellungen
    'invalid_security_token' => 'Ungültiges Sicherheitstoken!',
    'settings_saved_successfully' => 'Einstellungen erfolgreich gespeichert!',
    'error_saving_settings' => 'Fehler beim Speichern der Einstellungen',
    'enable_quotes_module' => 'Angebotsmodul aktivieren',
    'enable_quotes_module_description' => 'Steuert, ob das Angebotsmodul im Menü und an relevanten Stellen sichtbar ist.',
    'enable_stock_operations' => 'Bestandsverwaltung aktivieren',
    'enable_stock_operations_description' => 'Wenn diese Option aktiviert ist, werden die Menüs, Berichte und Funktionen zur Bestandsverwaltung angezeigt. Wenn deaktiviert, werden alle bestandsbezogenen Funktionen ausgeblendet und Produktbewegungen werden nur wertmäßig verwaltet.',
    'save_settings' => 'Einstellungen speichern',
    
    // Account Management / Kontoverwaltung
    'existing_accounts' => 'Vorhandene Konten',
    'initial_balance' => 'Anfangsbestand',
    'current_balance' => 'Aktueller Kontostand',
    'transactions' => 'Buchungen',
    'no_accounts_found' => 'Keine Konten gefunden.',
    'add_new_account' => 'Neues Konto hinzufügen',
    'edit_account' => 'Konto bearbeiten',
    'update_account' => 'Konto aktualisieren',
    'add_account' => 'Konto hinzufügen',
    'select_option' => 'Bitte wählen',
    'bank' => 'Bank',
    'cash' => 'Kasse',
    'turkish_lira' => 'Türkische Lira',
    'us_dollar' => 'US-Dollar',
    'euro' => 'Euro',
    'british_pound' => 'Britisches Pfund',
    'initial_balance_not_editable' => 'Der Anfangsbestand kann nicht geändert werden. Er kann über Kontobewegungen angepasst werden.',
    'example' => 'z.B.',
    'or' => 'oder',
    'cancel' => 'Abbrechen',
    'account_name_already_exists' => 'Dieser Kontoname existiert bereits!',
    'account_updated_successfully' => 'Konto erfolgreich aktualisiert.',
    'account_added_successfully' => 'Konto erfolgreich hinzugefügt.',
    'account_deleted_successfully' => 'Konto erfolgreich gelöscht.',
    'account_not_found_or_not_owned' => 'Konto nicht gefunden oder gehört nicht zu diesem Unternehmen.',
    'cannot_delete_account_with_transactions' => 'Dieses Konto kann nicht gelöscht werden, da damit Buchungen verbunden sind. Bitte löschen Sie zuerst die zugehörigen Buchungen oder übertragen Sie sie auf ein anderes Konto.',
    'confirm_delete_account' => 'Möchten Sie dieses Konto wirklich löschen? Wenn damit Buchungen verbunden sind, kann es nicht gelöscht werden!',
    'account_name_type_currency_required' => 'Kontobezeichnung, -typ und Währung sind erforderlich.',
    'account_operation_error' => 'Fehler bei der Kontobuchung',
    'error_loading_accounts' => 'Fehler beim Laden der Konten',
    'currency_formatting_script' => 'Währungsformatierungsskript',
    'convert_to_numeric_on_focus' => 'Beim Fokussieren in numerisches Format umwandeln',
    'convert_to_currency_on_blur' => 'Beim Verlassen in Währungsformat umwandeln',
    'format_existing_value_on_load' => 'Vorhandene Werte beim Laden formatieren',
    'account_updated_log' => 'Konto aktualisiert: :account (:currency)',
    'account_added_log' => 'Neues Konto hinzugefügt: :account (:currency)',
    'account_deleted_log' => 'Konto gelöscht: :account',
    
    // Category Management / Kategorieverwaltung
    'category_management' => 'Kategorieverwaltung',
    'transaction_categories' => 'Buchungskategorien (Ausgaben/Einnahmen)',
    'product_categories' => 'Produktkategorien',
    'category_name' => 'Kategoriename',
    'category_not_found' => 'Kategorie nicht gefunden.',
    'error_loading_category' => 'Fehler beim Laden der Kategorieinformationen.',
    'invalid_category_type' => 'Ungültiger Kategorietyp.',
    'category_name_required' => 'Kategoriename ist erforderlich.',
    'category_name_already_exists' => 'Dieser Kategoriename wird bereits verwendet!',
    'category_name_exists_for_type' => 'Dieser Kategoriename existiert bereits für diesen Typ!',
    'category_updated_successfully' => 'Kategorie erfolgreich aktualisiert.',
    'category_added_successfully' => 'Kategorie erfolgreich hinzugefügt.',
    'error_loading_categories' => 'Fehler beim Laden der Kategorien.',
    'edit_category' => 'Kategorie bearbeiten',
    'add_new_product_category' => 'Neue Produktkategorie hinzufügen',
    'add_new_transaction_category' => 'Neue Buchungskategorie hinzufügen',
    'save_category' => 'Kategorie speichern',
    'update' => 'Aktualisieren',
    'existing_product_categories' => 'Vorhandene Produktkategorien',
    'existing_transaction_categories' => 'Vorhandene Buchungskategorien',
    'actions' => 'Aktionen',
    
    // Company Management / Unternehmensverwaltung
    'company_management' => 'Unternehmensverwaltung',
    'company_logo' => 'Firmenlogo',
    'upload_logo' => 'Logo hochladen',
    'change_logo' => 'Logo ändern',
    'remove_logo' => 'Logo entfernen',
    'logo_upload_help' => 'Maximale Größe: 2MB. Erlaubte Formate: JPG, JPEG, PNG, GIF.',
    'logo_uploaded_success' => 'Logo erfolgreich hochgeladen.',
    'logo_upload_failed' => 'Fehler beim Hochladen des Logos.',
    'logo_removed_success' => 'Logo erfolgreich entfernt.',
    'invalid_file_type' => 'Ungültiger Dateityp. Es sind nur JPG, JPEG, PNG und GIF erlaubt.',
    'logo_upload_too_large' => 'Die Datei ist zu groß. Maximale Größe: 2MB.',
    'existing_companies' => 'Vorhandene Unternehmen',
    'company_name' => 'Firmenname',
    'status' => 'Status',
    'active' => 'Aktiv',
    'passive' => 'Inaktiv',
    'add_new_company' => 'Neues Unternehmen hinzufügen',
    'edit_company' => 'Unternehmen bearbeiten',
    'address' => 'Adresse',
    'phone' => 'Telefon',
    'email' => 'E-Mail',
    'company_settings' => 'Unternehmenseinstellungen',
    'currency' => 'Währung',
    'enable_quotes_module' => 'Angebotsmodul aktivieren',
    'quotes_module_description' => 'Steuert, ob das Angebotsmodul im Menü und an relevanten Stellen sichtbar ist.',
    'enable_inventory_management' => 'Bestandsverwaltung aktivieren',
    'inventory_management_description' => 'Wenn aktiviert, werden die Menüs, Berichte und Funktionen zur Bestandsverwaltung angezeigt. Wenn deaktiviert, werden alle bestandsbezogenen Funktionen ausgeblendet und Produktbewegungen werden nur wertmäßig verwaltet.',
    'enable_multiple_currencies' => 'Mehrere Währungen aktivieren',
    'multiple_currencies_description' => 'Ermöglicht Transaktionen in verschiedenen Währungen',
    'company_active' => 'Unternehmen aktiv',
    'no_permission_to_update_company' => 'Sie haben keine Berechtigung, dieses Unternehmen zu aktualisieren.',
    'company_info_updated_successfully' => 'Unternehmensinformationen und -einstellungen wurden erfolgreich aktualisiert.',
    'company_created_successfully' => 'Neues Unternehmen erfolgreich erstellt und Einstellungen gespeichert.',
    'cannot_delete_active_company' => 'Sie können das aktuell aktive Unternehmen nicht löschen. Bitte wechseln Sie zuerst zu einem anderen Unternehmen.',
    'cannot_delete_main_company' => 'Das Hauptunternehmen (ID: 1) kann aus Sicherheitsgründen nicht gelöscht werden.',
    'no_permission_to_delete_company' => 'Sie haben keine Berechtigung, dieses Unternehmen zu löschen.',
    'company_deleted_successfully' => 'Unternehmen und alle zugehörigen Daten wurden erfolgreich gelöscht.',
    'confirm_company_deletion' => 'Sind Sie sicher, dass Sie dieses Unternehmen und ALLE zugehörigen Daten (Produkte, Kunden, Rechnungen usw.) dauerhaft löschen möchten? Diese Aktion kann nicht rückgängig gemacht werden!',
    'no_product_categories_found' => 'Für dieses Unternehmen wurden noch keine Produktkategorien hinzugefügt.',
    'no_transaction_categories_found' => 'Für dieses Unternehmen wurden noch keine Buchungskategorien hinzugefügt.',
    'confirm_delete_category' => 'Möchten Sie diese Kategorie wirklich löschen? Wenn es damit verbundene Transaktionen gibt, kann sie nicht gelöscht werden.',
    'category_updated_log' => 'Kategorie :category wurde aktualisiert.',
    'category_added_log' => 'Kategorie :category wurde hinzugefügt.',
    
    // Customer Group Management / Kundengruppenverwaltung
    'customer_group_management' => 'Kundengruppenverwaltung',
    'group_not_found' => 'Gruppe nicht gefunden.',
    'error_loading_group' => 'Fehler beim Laden der Gruppendaten.',
    'group_name_required' => 'Gruppenname ist erforderlich.',
    'group_name_already_exists' => 'Dieser Gruppenname wird bereits verwendet!',
    'customer_group_updated_successfully' => 'Kundengruppe erfolgreich aktualisiert.',
    'customer_group_added_successfully' => 'Kundengruppe erfolgreich hinzugefügt.',
    'error_loading_customer_groups' => 'Fehler beim Laden der Kundengruppen.',
    'edit_group' => 'Gruppe bearbeiten',
    'add_new_group' => 'Neue Gruppe hinzufügen',
    'save_group' => 'Gruppe speichern',
    'existing_groups' => 'Vorhandene Gruppen',
    'group_name' => 'Gruppenname',
    'no_customer_groups_found' => 'Für dieses Unternehmen wurden noch keine Kundengruppen hinzugefügt.',
    'confirm_delete_group' => 'Möchten Sie diese Gruppe wirklich löschen? Falls Kunden zugeordnet sind, schlägt der Vorgang fehl.',
    'delete_group' => 'Gruppe löschen',
    
    // Stock and Image Settings / Bestands- und Bildeinstellungen
    'stock_and_image_settings' => 'Bestands- und Bildeinstellungen',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'directory_creation_failed' => 'Verzeichnis konnte nicht erstellt werden',
    'check_directory_permissions' => 'Bitte überprüfen Sie die Schreibrechte für das übergeordnete Verzeichnis.',
    'not_a_directory' => 'Der angegebene Pfad ist kein Verzeichnis',
    'database_error_while_updating_settings' => 'Datenbankfehler beim Aktualisieren der Einstellungen.',
    'information' => 'Information',
    'stock_settings_description' => 'Diese Einstellungen steuern das Hochladen von Produktbildern und andere allgemeine Systemverhalten in Bezug auf den Bestand.',
    'image_upload_settings' => 'Bild-Upload-Einstellungen',
    'enable_image_upload_in_stock_section' => 'Bild-Upload im Bestandsbereich aktivieren',
    'enable_image_upload_help' => 'Wenn aktiviert, wird in den Produktbearbeitungsseiten ein Bild-Upload-Feld angezeigt.',
    'image_upload_directory' => 'Bild-Upload-Verzeichnis',
    'image_upload_directory_help' => 'Verzeichnis, in dem die Produktbilder gespeichert werden. Muss relativ zum Hauptverzeichnis angegeben werden.',
    'directory_permissions_note' => 'Falls nicht vorhanden, wird das Verzeichnis erstellt und die Schreibrechte werden überprüft.',
    'image_visibility_settings' => 'Bildsichtbarkeitseinstellungen',
    'show_product_images' => 'Produktbilder anzeigen?',
    'show_product_images_help' => 'Wenn aktiviert, werden in den Produktlisten die Produktbilder angezeigt.',
    'show_images_in_pdf' => 'Produktbilder in PDFs anzeigen?',
    'show_images_in_pdf_help' => 'Wenn aktiviert, werden in Rechnungen und Berichts-PDFs die Produktbilder angezeigt.',
    'save_settings' => 'Einstellungen speichern',
    'important_notes' => 'Wichtige Hinweise',
    'image_settings_note_1' => 'Diese Einstellungen steuern, ob Produktbilder im System und in PDF-Ausgaben angezeigt werden.',
    'image_settings_note_2' => 'Wenn die zweite Preisoption aktiviert ist, bleiben diese Felder für bestehende Produkte leer.',
    'image_settings_note_3' => 'Diese Felder sind optional und müssen nicht ausgefüllt werden.',
    'image_settings_note_4' => 'Für API-Integrationen wird das Ausfüllen dieser Felder empfohlen.',
    'settings_take_effect_immediately' => 'Einstellungsänderungen werden sofort wirksam.',
    'example' => 'Beispiel',
    'stock_and_image_settings_updated_successfully' => 'Bestands- und Bildeinstellungen wurden erfolgreich aktualisiert.',
    'stock_and_image_settings_updated_log' => 'Bestands- und Bildeinstellungen wurden unternehmensweit aktualisiert',
    
    // Permission Levels / Berechtigungsstufen
    'permission_levels_management' => 'Berechtigungsstufenverwaltung',
    'add_new_permission_group' => 'Neue Berechtigungsgruppe hinzufügen',
    'edit_permission_group' => 'Berechtigungsgruppe bearbeiten',
    'existing_permission_groups' => 'Vorhandene Berechtigungsgruppen',
    'group_name' => 'Gruppenname',
    'description' => 'Beschreibung',
    'permissions' => 'Berechtigungen',
    'status' => 'Status',
    'actions' => 'Aktionen',
    'active' => 'Aktiv',
    'passive' => 'Inaktiv',
    'update_group' => 'Gruppe aktualisieren',
    'cancel' => 'Abbrechen',
    'add_group' => 'Gruppe hinzufügen',
    'no_permissions_defined' => 'Keine Berechtigungen definiert',
    'no_permission_groups_added' => 'Es wurden noch keine Berechtigungsgruppen hinzugefügt.',
    'delete' => 'Löschen',
    'edit' => 'Bearbeiten',
    'confirm_delete_group' => 'Möchten Sie diese Berechtigungsgruppe wirklich löschen? Wenn Benutzer dieser Gruppe zugeordnet sind, kann sie nicht gelöscht werden!',
    'group_name_cannot_be_empty' => 'Gruppenname darf nicht leer sein.',
    'group_name_already_exists' => 'Dieser Gruppenname existiert bereits!',
    'group_name_already_used' => 'Dieser Gruppenname wird bereits von einer anderen Gruppe verwendet!',
    'group_to_edit_not_found' => 'Zu bearbeitende Gruppe nicht gefunden.',
    'permission_group_added_successfully' => 'Berechtigungsgruppe erfolgreich hinzugefügt.',
    'permission_group_updated_successfully' => 'Berechtigungsgruppe erfolgreich aktualisiert.',
    'error_loading_group_info' => 'Fehler beim Laden der Gruppeninformationen.',
    'error_loading_permission_groups' => 'Fehler beim Laden der Berechtigungsgruppen.',
    'group_permissions' => 'Gruppenberechtigungen',
    
    // Permission Descriptions / Berechtigungsbeschreibungen
    'stock_management' => 'Bestandsverwaltung (Produkte hinzufügen/bearbeiten/löschen)',
    'stock_viewing' => 'Bestandsansicht (Produktlisten/Berichte)',
    'sales_operations' => 'Verkaufsvorgänge (Verkäufe/Rechnungen)',
    'purchase_operations' => 'Einkaufsvorgänge (Einkäufe/Rechnungen)',
    'quote_management' => 'Angebotsverwaltung (Erstellen/Bearbeiten/Umwandeln)',
    'customer_management' => 'Kundenverwaltung (Kunden hinzufügen/bearbeiten/löschen)',
    'customer_viewing' => 'Kundenansicht (Kundenliste/Details)',
    'account_management' => 'Kontoverwaltung (Konten hinzufügen/bearbeiten/löschen/Buchungen)',
    'view_reports' => 'Berichte anzeigen (Alle Berichte)',
    'view_invoices' => 'Rechnungen anzeigen (Alle Rechnungen)',
    'user_management' => 'Benutzerverwaltung (Benutzer hinzufügen/bearbeiten/löschen)',
    'view_logs' => 'Protokolle anzeigen',
    'access_general_settings' => 'Zugriff auf allgemeine Einstellungen (Seiteneinstellungen/Kategorien/Konten)',
    'all_admin_privileges' => 'Alle Administratorrechte (Achtung: Normalerweise nur für Admin-Rolle)',
    
    // Security Settings / Sicherheitseinstellungen
    'security_settings' => 'Sicherheitseinstellungen',
    'management' => 'Verwaltung',
    'invalid_form_submission' => 'Ungültige Formularübermittlung!',
    'screen_lock_time_minutes' => 'Die Bildschirmsperrzeit muss mindestens 1 Minute betragen.',
    'new_passwords_dont_match' => 'Die neuen Passwörter stimmen nicht überein.',
    'screen_lock_password_min_length' => 'Das Bildschirmsperrpasswort muss mindestens 4 Zeichen lang sein.',
    'security_settings_updated' => 'Sicherheitseinstellungen erfolgreich aktualisiert.',
    'an_error_occurred' => 'Ein Fehler ist aufgetreten',
    'enable_auto_screen_lock' => 'Automatische Bildschirmsperre aktivieren',
    'idle_timeout_minutes' => 'Inaktivitätszeit (Minuten)',
    'screen_will_lock_after' => 'Nach dieser Zeit der Inaktivität wird der Bildschirm gesperrt.',
    'screen_lock_password' => 'Bildschirmsperrpasswort',
    'no_screen_lock_password_set' => 'Sie haben noch kein Bildschirmsperrpasswort festgelegt. Bitte legen Sie ein Passwort fest, um diese Funktion zu nutzen.',
    'new_password' => 'Neues Passwort',
    'enter_new_password' => 'Geben Sie Ihr neues Passwort ein',
    'new_password_repeat' => 'Neues Passwort (Wiederholung)',
    're_enter_new_password' => 'Geben Sie Ihr neues Passwort erneut ein',
    'save_settings' => 'Einstellungen speichern',
    
    // Login Page / Anmeldeseite
    'login_page_title' => 'Begeb Creative Verwaltung - Anmeldung',
    'app_name' => 'Begeb Creative Verwaltung',
    'business_management_panel' => 'Anmeldung zum Unternehmensverwaltungspanel',
    'username_password_required' => 'Benutzername und Passwort dürfen nicht leer sein!',
    'too_many_failed_attempts' => 'Zu viele fehlgeschlagene Anmeldeversuche.',
    'invalid_username_or_password' => 'Ungültiger Benutzername oder Passwort!',
    'system_error_try_again' => 'Systemfehler. Bitte versuchen Sie es später erneut.',
    'session_expired_login_again' => 'Ihre Sitzung ist abgelaufen. Bitte melden Sie sich erneut an.',
    'session_terminated_security' => 'Ihre Sitzung wurde aus Sicherheitsgründen beendet.',
    'login_failed' => 'ANMELDUNG FEHLGESCHLAGEN!',
    'registration_successful_login_now' => 'Registrierung erfolgreich! Sie können sich jetzt anmelden.',
    'username' => 'Benutzername',
    'password' => 'Passwort',
    'login' => 'Anmelden',
    'sign_up' => 'Registrieren',
    'forgot_password' => 'Passwort vergessen?',
    'close' => 'Schließen',
    'full_name' => 'Vollständiger Name',
    'email' => 'E-Mail',
    'password_repeat' => 'Passwort (Wiederholung)',
    'register' => 'Registrieren',
    'already_have_account' => 'Haben Sie bereits ein Konto? Anmelden',
    'full_name_min_length' => 'Der vollständige Name muss mindestens 3 Zeichen lang sein.',
    'username_min_length' => 'Der Benutzername muss mindestens 3 Zeichen lang sein.',
    'enter_valid_email' => 'Bitte geben Sie eine gültige E-Mail-Adresse ein.',
    'password_min_length' => 'Das Passwort muss mindestens 6 Zeichen lang sein.',
    'passwords_dont_match' => 'Die Passwörter stimmen nicht überein.',
    'username_or_email_exists' => 'Dieser Benutzername oder diese E-Mail-Adresse ist bereits registriert.',
    'database_error_register' => 'Registrierung aufgrund eines Datenbankfehlers fehlgeschlagen. Bitte versuchen Sie es erneut.',
    
    // Installation / Installation
    'installation' => 'Installation',
    'system_management' => 'Systemverwaltung',
    'welcome_to_odjoo' => 'Willkommen bei Begeb Creative Verwaltungssystem',
    'welcome_description' => 'Sie können fortfahren, indem Sie eine der folgenden Optionen auswählen.',
    'new_installation' => 'Neue Installation',
    'new_installation_desc' => 'Führen Sie eine Neuinstallation durch',
    'system_backup' => 'System-Backup',
    'system_backup_desc' => 'Erstellen Sie ein Backup Ihres aktuellen Systems',
    'system_restore' => 'Systemwiederherstellung',
    'system_restore_desc' => 'Stellen Sie aus einer vorherigen Sicherung wieder her',
    'continue' => 'Weiter',
    'database_connection' => 'Datenbankverbindung',
    'database_connection_desc' => 'Bitte geben Sie die Datenbankverbindungsinformationen ein',
    'database_server' => 'Datenbankserver',
    'database_name' => 'Datenbankname',
    'database_username' => 'Datenbank-Benutzername',
    'database_password' => 'Datenbank-Passwort',
    'connection_successful' => 'Datenbankverbindung erfolgreich! Die Installation wird gestartet...',
    'connection_error' => 'Datenbankverbindungsfehler',
    'required_fields' => 'Bitte füllen Sie alle erforderlichen Felder aus.',
    'installation_in_progress' => 'Installation läuft',
    'installation_complete' => 'Installation abgeschlossen',
    'installation_error' => 'Installationsfehler',
    'create_company' => 'Unternehmen erstellen',
    'company_name' => 'Firmenname',
    'address' => 'Adresse',
    'phone' => 'Telefon',
    'email' => 'E-Mail',
    'currency' => 'Währung',
    'stock_module' => 'Lagerverwaltung aktiv',
    'quotation_module' => 'Angebotsmodul aktiv',
    'create_admin_user' => 'Administrator-Benutzer erstellen',
    'admin_full_name' => 'Vollständiger Name des Administrators',
    'admin_username' => 'Administrator-Benutzername',
    'admin_email' => 'Administrator-E-Mail',
    'admin_password' => 'Administrator-Passwort',
    'complete_installation' => 'Installation abschließen',
    'installation_success' => 'Installation erfolgreich!',
    'installation_success_desc' => 'Das System wurde erfolgreich installiert. Sie können auf die Anmeldeseite gelangen, indem Sie auf die Schaltfläche unten klicken.',
    'go_to_login' => 'Zur Anmeldeseite',
    'invalid_csrf' => 'Ungültiges CSRF-Token!',
    'company_required' => 'Firmenname ist erforderlich.',
    'admin_required' => 'Bitte füllen Sie alle erforderlichen Felder aus: Vollständiger Name, Benutzername und Passwort des Administrators.',
    'delete_install_file' => 'Löschen Sie die `install.php`-Datei von Ihrem Server.',
    'installation_type' => 'Installationstyp',
    'full_installation' => 'Vollständige Installation (Alle Tabellen erstellen)',
    'partial_installation' => 'Teilweise Installation (Nur fehlende Tabellen hinzufügen)',
    'sql_file_not_found' => 'SQL-Datei nicht gefunden: %s',
    'sql_file_not_readable' => 'SQL-Datei kann nicht gelesen werden: %s',
    'config_update_failed' => 'config.php konnte nicht aktualisiert werden. Bitte stellen Sie sicher, dass der Benutzer Schreibrechte für das Verzeichnis \'includes\' hat.',
    'config_not_found' => 'config.php nicht gefunden.',
    'sql_error' => 'SQL-Fehler',
    'start_installation' => 'Installation starten',
    'system_update' => 'System aktualisieren',
    'system_update_desc' => 'Aktualisieren Sie Ihr aktuelles System. Halten Sie Ihr System mit neuen Funktionen und Sicherheitsupdates auf dem neuesten Stand.',
    'start_update' => 'Update starten',
    'backup_restore' => 'Backup wiederherstellen',
    'backup_restore_desc' => 'Laden Sie zuvor erstellte Sicherungsdateien hoch und stellen Sie Ihre Daten wieder her.',
    'start_restore' => 'Wiederherstellung starten',
    'feature_secure' => 'Sicher',
    'feature_secure_desc' => 'Ihre Daten sind mit fortschrittlichen Sicherheitsmaßnahmen geschützt',
    'feature_easy' => 'Einfach zu bedienen',
    'feature_easy_desc' => 'Einfache Bedienung durch klares und verständliches Interface',
    'feature_support' => '24/7 Support',
    'feature_support_desc' => 'Unser Expertenteam steht Ihnen jederzeit zur Verfügung',
    'feature_customizable' => 'Anpassbar',
    'feature_customizable_desc' => 'Einfach an Ihre Bedürfnisse anpassbar',
    'feature_fast' => 'Schnell',
    'feature_fast_desc' => 'Hohe Leistung durch optimierte Infrastruktur',
    'feature_responsive' => 'Responsives Design',
    'feature_responsive_desc' => 'Optimale Darstellung auf allen Geräten',
    'feature_easy_install' => 'Einfache Installation',
    'feature_easy_install_desc' => 'Einfache Installation in wenigen Schritten',
    'feature_multi_user' => 'Mehrbenutzerfähig',
    'feature_multi_user_desc' => 'Gleichzeitige Nutzung durch mehrere Benutzer möglich',
    'missing_database_info' => 'Fehlende Datenbankinformationen. Bitte versuchen Sie es erneut.',
    'full_installation_complete' => 'Vollständige Installation erfolgreich abgeschlossen!',
    'partial_installation_complete' => 'Fehlende Tabellen und Standarddaten wurden hinzugefügt.',
    'invalid_installation_action' => 'Ungültige Installationsaktion ausgewählt.',
    'starting' => 'Starte',
    'admin_creation_error' => 'Fehler beim Erstellen des Administrator-Benutzers',
    'company_created_successfully' => 'Unternehmen erfolgreich erstellt! Bitte erstellen Sie nun einen Administrator-Benutzer.',
    'error_creating_company' => 'Fehler beim Erstellen des Unternehmens',
    'all_data_deleted_and_installed' => 'Alle Daten wurden gelöscht und die Neuinstallation wurde abgeschlossen!',
    'install_complete_message' => 'Installation erfolgreich abgeschlossen! Bitte löschen Sie die Datei `install.php` von Ihrem Server.',
    'odjoo_installation' => 'Begeb Creative Installation',
    'system_setup_guide' => 'Richten Sie Ihr System Schritt für Schritt ein',
    'odjoo_setup_wizard' => 'Begeb Creative Installationsassistent',
    'database_information' => 'Datenbankinformationen',
    'enter_database_credentials' => 'Bitte geben Sie Ihre Datenbankverbindungsdaten ein.',
    'test_connection_and_continue' => 'Verbindung testen und fortfahren',
    'installation_options' => 'Installationsoptionen',
    'create_company_and_continue' => 'Unternehmen erstellen und fortfahren',
    ];