<?php
// --- Dinamik BASE_URL Tanımlaması Başlangıç ---
if (!defined('BASE_URL')) {
    // Projenin kök dizinine göre dinamik ve güvenli bir base URL oluşturur.
    // Bu, projenin farklı sunucularda veya alt dizinlerde sorunsuz çalışmasını sağlar.
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $project_path = dirname(dirname($_SERVER['SCRIPT_NAME']));
    $project_path = str_replace('\\', '/', $project_path);
    $project_path = rtrim($project_path, '/');
    define('BASE_URL', $protocol . $host . $project_path);
}
// --- Dinamik BASE_URL Tanımlaması Bitiş ---

// Dil fonksiyonlarını yükle
require_once __DIR__ . '/language_functions.php';

// Ayarlar fonksiyonlarını yükle
require_once __DIR__ . '/ayar_fonksiyonlari.php';

global $db; // PDO bağlantısını global olarak tanımla
$aktif_sirket_id = $_SESSION['aktif_sirket_id'] ?? null; // Aktif şirket ID'sini al

// Mevcut dil ayarını al
$current_language = getCurrentLanguage();
$available_languages = getAvailableLanguages();

// Aktif şirketin ayarlarını doğrudan sirketler tablosundan çek
$sirket_ayarlari = [];
if ($aktif_sirket_id) {
    $stmt_sirket_ayarlari = $db->prepare("SELECT teklifler_modulu_aktif, stok_islemleri_aktif, coklu_para_birimi, depo_yonetimi_aktif FROM sirketler WHERE id = ?");
    $stmt_sirket_ayarlari->execute([$aktif_sirket_id]);
    $sirket_ayarlari = $stmt_sirket_ayarlari->fetch(PDO::FETCH_ASSOC);
}

$stok_islemleri_aktif = $sirket_ayarlari['stok_islemleri_aktif'] ?? '0';
$teklifler_modulu_aktif = $sirket_ayarlari['teklifler_modulu_aktif'] ?? '1';
$coklu_para_birimi_aktif = $sirket_ayarlari['coklu_para_birimi'] ?? '0';
$depo_yonetimi_aktif = $sirket_ayarlari['depo_yonetimi_aktif'] ?? '0';

// Menü filtresi fonksiyonunu çağır
$filtered_menu = navbar_menu_filtrele();
?>
<head>
    <link rel="stylesheet" href="<?= BASE_URL ?>/assets/css/custom.css">
</head>
<nav class="navbar navbar-expand-md navbar-light custom-navbar">
    <div class="container-fluid">
        <a class="navbar-brand" href="index.php">
            <i class="bi bi-shop"></i>Begeb Creative
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto mb-2 mb-md-0">
                
                <?php if (isset($filtered_menu['islemler']) && !empty($filtered_menu['islemler'])): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["satis_yeni.php", "alis_yeni.php", "cari_alacaklandir.php", "cari_borclandir.php", "odeme_al.php", "odeme_yap.php", "transfer_ekle.php", "kasa_gider.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownIslemler" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-receipt-cutoff me-1"></i> <?= __('operations') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownIslemler">
                        <?php foreach ($filtered_menu['islemler'] as $page => $title): ?>
                            <?php if ($stok_islemleri_aktif == '1' || !in_array($page, ['satis_yeni','alis_yeni'])): ?>
                            <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == $page . ".php" ? "active" : "" ?>" href="<?= $page ?>.php">
                                <i class="bi bi-<?= $page == 'satis_yeni' ? 'cart-plus' : ($page == 'alis_yeni' ? 'bag-plus' : ($page == 'cari_alacaklandir' ? 'arrow-up-circle' : ($page == 'cari_borclandir' ? 'arrow-down-circle' : ($page == 'transfer_ekle' ? 'arrow-left-right' : 'cash')))) ?> me-2"></i><?= $title ?>
                            </a></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == "kasa_gider.php" ? "active" : "" ?>" href="kasa_gider.php">
                            <i class="bi bi-cash-stack me-2"></i> <?= __('cash_receipt') ?>
                        </a></li>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if ($stok_islemleri_aktif == '1' && isset($filtered_menu['faturalar']) && !empty($filtered_menu['faturalar'])): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["satis_faturalari.php", "alis_faturalari.php", "fatura_goruntule.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownFaturalar" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-file-earmark-text me-1"></i> <?= __('invoices') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownFaturalar">
                        <?php foreach ($filtered_menu['faturalar'] as $page => $title): ?>
                            <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == $page . ".php" ? "active" : "" ?>" href="<?= $page ?>.php">
                                <i class="bi bi-<?= $page == 'satis_faturalari' ? 'receipt' : 'file-earmark-plus' ?> me-2"></i><?= $title ?>
                            </a></li>
                        <?php endforeach; ?>
                    </ul>
                </li>
                <?php endif; ?>

                <?php if ($teklifler_modulu_aktif == '1' && isset($filtered_menu['teklifler'])): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["teklifler.php", "teklif_yeni.php", "teklif_goruntule.php", "teklifstoksuz.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownTeklifler" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-file-earmark-text me-1"></i> <?= __('offers') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownTeklifler">
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == "teklifler.php" ? "active" : "" ?>" href="teklifler.php">
                            <i class="bi bi-list-ul me-2"></i><?= __('offer_list') ?>
                        </a></li>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == "teklif_yeni.php" ? "active" : "" ?>" href="teklif_yeni.php">
                            <i class="bi bi-file-earmark-plus me-2"></i><?= __('new_offer') ?>
                        </a></li>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == "teklifstoksuz.php" ? "active" : "" ?>" href="teklifstoksuz.php">
                            <i class="bi bi-file-earmark-text-fill me-2"></i><?= __('offer_without_stock') ?>
                        </a></li>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if ($stok_islemleri_aktif == '1' && isset($filtered_menu['stok']) && !empty($filtered_menu['stok'])): ?> <!-- Stok aktifse göster -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["urunler.php", "urun_ekle.php", "stok_hareketleri.php", "stok_raporlari.php", "en_cok_satan_urunler.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownStok" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-box-seam me-1"></i> <?= __('inventory') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownStok">
                        <?php foreach ($filtered_menu['stok'] as $page => $title): ?>
                            <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == $page . ".php" ? "active" : "" ?>" href="<?= $page ?>.php">
                                <i class="bi bi-<?= $page == 'urun_ekle' ? 'plus-circle' : ($page == 'urunler' ? 'list-ul' : ($page == 'stok_hareketleri' ? 'clock-history' : ($page == 'en_cok_satan_urunler' ? 'trophy' : 'graph-up'))) ?> me-2"></i><?= $title ?>
                            </a></li>
                        <?php endforeach; ?>
                    </ul>
                </li>
                <?php endif; ?>
                
                <?php if (isset($filtered_menu['cariler'])): ?>
                <li class="nav-item">
                    <a class="nav-link <?= basename($_SERVER["PHP_SELF"]) == "cariler.php" ? "active" : "" ?>" href="cariler.php">
                        <i class="bi bi-people me-1"></i> <?= __('customers') ?>
                    </a>
                </li>
                <?php endif; ?>
                
                <?php if (isset($filtered_menu['raporlar']) && !empty($filtered_menu['raporlar'])): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["hesap_hareketleri.php", "raporlar.php", "cari_ekstre.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownRaporlar" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                       <i class="bi bi-clipboard-data me-1"></i> <?= __('reports') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownRaporlar">
                        <?php foreach ($filtered_menu['raporlar'] as $page => $title): ?>
                            <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == $page . ".php" ? "active" : "" ?>" href="<?= $page ?>.php">
                                <i class="bi bi-<?= $page == 'hesap_hareketleri' ? 'list-ol' : ($page == 'cari_ekstre' ? 'person-lines-fill' : 'pie-chart') ?> me-2"></i><?= $title ?>
                            </a></li>
                        <?php endforeach; ?>
                    </ul>
                </li>
                <?php endif; ?>
                
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle <?= in_array(basename($_SERVER["PHP_SELF"]), ["kullanicilar.php", "loglar.php", "ayarlar.php", "guvenlik_kontrol.php", "toplu_islem.php", "hatirlatici.php", "yedek_islemi.php"]) ? "active" : "" ?>" href="#" id="navbarDropdownYonetim" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                       <i class="bi bi-gear me-1"></i> <?= __('management') ?>
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdownYonetim">
                        <?php foreach ($filtered_menu['yonetim'] as $page => $title): ?>
                            <?php if ($page === 'kategoriler' || $page === 'hesaplar' || $page === 'ayarlar' || $page === 'firma_yonetimi' || $page === 'yetki_seviyeleri' || $page === 'firma_bilgileri' || $page === 'guvenlik'): ?>
                                <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'ayarlar.php' && ($_GET['section'] ?? '') == $page ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=<?= $page ?>">
                                    <i class="bi bi-<?= $page == 'kategoriler' ? 'tags' : ($page == 'hesaplar' ? 'wallet2' : 'gear') ?> me-2"></i><?= $title ?>
                                </a></li>
                                <?php if ($page === 'kategoriler' && $depo_yonetimi_aktif == '1'): ?>
                                    <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'ayarlar.php' && ($_GET['section'] ?? '') == 'depolar' ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=depolar">
                                        <i class="bi bi-building me-2"></i><?= __('warehouse_management') ?>
                                    </a></li>
                                    <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'ayarlar.php' && ($_GET['section'] ?? '') == 'raflar' ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/ayarlar.php?section=raflar">
                                        <i class="bi bi-bookshelf me-2"></i><?= __('shelf_management') ?>
                                    </a></li>
                                <?php endif; ?>
                            <?php else: ?>
                                <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == $page . ".php" ? "active" : "" ?>" href="<?= BASE_URL ?>/views/<?= $page ?>.php">
                                    <i class="bi bi-<?= $page == 'kullanicilar' ? 'people-fill' : ($page == 'loglar' ? 'journal-text' : 'shield-check') ?> me-2"></i><?= $title ?>
                                </a></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        <li><hr class="dropdown-divider"></li>
                        <?php if ($coklu_para_birimi_aktif == '1'): ?>
                        <li><a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#dovizModal"><i class="bi bi-currency-exchange me-2"></i><?= __('exchange_rates') ?></a></li>
                        <?php endif; ?>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'toplu_islem.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/toplu_islem.php"><i class="bi bi-collection me-2"></i><?= __('batch_operations') ?></a></li>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'hatirlatici.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/hatirlatici.php"><i class="bi bi-bell me-2"></i><?= __('reminder') ?></a></li>
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == 'yedek_islemi.php' ? 'active' : '' ?>" href="<?= BASE_URL ?>/views/yedek_islemi.php"><i class="bi bi-download me-2"></i><?= __('backup_operations') ?></a></li>
                    </ul>
                </li>
            </ul>
            
            <ul class="navbar-nav ms-auto mb-2 mb-md-0 align-items-center">

                <?php if (isset($_SESSION['kullanici_sirketleri']) && count($_SESSION['kullanici_sirketleri']) > 0): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-warning" href="#" id="navbarDropdownSirket" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-building me-1"></i>
                        <strong><?= temizle($_SESSION['aktif_sirket_adi']) ?></strong>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdownSirket">
                        <?php foreach ($_SESSION['kullanici_sirketleri'] as $sirket): ?>
                            <li>
                                <a class="dropdown-item <?= ($sirket['id'] == $_SESSION['aktif_sirket_id']) ? 'active' : '' ?>" 
                                   href="<?= BASE_URL ?>/views/sirket_degistir.php?id=<?= $sirket['id'] ?>">
                                    <?= temizle($sirket['sirket_adi']) ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="<?= BASE_URL ?>/views/ayarlar.php?section=firma_yonetimi"><i class="bi bi-pencil-square me-2"></i>Firmaları Yönet</a></li>
                    </ul>
                </li>
                <li class="nav-item"><span class="navbar-text mx-2">|</span></li>
                <?php endif; ?>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdownUser" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-person-circle me-1"></i> 
                        <?= isset($_SESSION["ad_soyad"]) ? temizle($_SESSION["ad_soyad"]) : __('user') ?>
                        <?= isset($_SESSION['yetki_seviyesi']) ? yetki_seviyesi_badge($_SESSION['yetki_seviyesi']) : '' ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdownUser">
                        <li><a class="dropdown-item <?= basename($_SERVER["PHP_SELF"]) == "profil.php" ? "active" : "" ?>" href="profil.php">
                            <i class="bi bi-person-gear me-2"></i><?= __("profile") ?>
                        </a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="cikis.php">
                            <i class="bi bi-box-arrow-right me-2"></i><?= __("logout") ?>
                        </a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>

<?php
// Session mesajlarını göster (Bootstrap Alert ile)
if (isset($_SESSION["mesaj"])) {
    echo 
         "<div class=\"container mt-3\"><div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">" .
         "<i class=\"bi bi-check-circle-fill me-2\"></i>" . temizle($_SESSION["mesaj"]) .
         "<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\" aria-label=\"Close\"></button>" .
         "</div></div>";
    unset($_SESSION["mesaj"]);
}
if (isset($_SESSION["hata"])) {
     echo 
         "<div class=\"container mt-3\"><div class=\"alert alert-danger alert-dismissible fade show\" role=\"alert\">" .
         "<i class=\"bi bi-exclamation-triangle-fill me-2\"></i>" . temizle($_SESSION["hata"]) .
         "<button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"alert\" aria-label=\"Close\"></button>" .
         "</div></div>";
    unset($_SESSION["hata"]);
}
?>
<br />

<?php if (($coklu_para_birimi_aktif ?? '0') == '1'): ?>
<!-- Döviz Kurları Modal -->
<div class="modal fade" id="dovizModal" tabindex="-1" aria-labelledby="dovizModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="dovizModalLabel"><i class="bi bi-currency-exchange me-2"></i>Döviz Kurları</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="dovizKurlariContainer" class="table-responsive">
                    <div class="text-center py-4" id="dovizLoading">
                        <div class="spinner-border text-primary" role="status"><span class="visually-hidden">Yükleniyor...</span></div>
                    </div>
                    <table class="table table-sm align-middle" id="dovizTable" style="display:none;">
                        <thead>
                            <tr>
                                <th>Para Birimi</th>
                                <th class="text-end">Alış</th>
                                <th class="text-end">Satış</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer justify-content-between">
                <div class="small text-muted" id="dovizUpdatedFooter"></div>
                <div>
                    <button type="button" class="btn btn-primary" id="dovizGuncelleBtn">
                        <span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true" style="display: none;"></span>
                        <i class="bi bi-arrow-clockwise"></i>
                        <span>Güncelle</span>
                    </button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Kapat</button>
                </div>
            </div>
        </div>
    </div>
    </div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const dovizModalEl = document.getElementById('dovizModal');
    if (!dovizModalEl) return;

    const guncelleBtn = document.getElementById('dovizGuncelleBtn');
    const spinner = guncelleBtn.querySelector('.spinner-border');
    const icon = guncelleBtn.querySelector('.bi');
    const btnText = guncelleBtn.querySelector('span:last-child');

    // Modal açıldığında kurları yükle
    dovizModalEl.addEventListener('show.bs.modal', function () {
        // Otomatik güncellemeyi tetikle (TTL kontrolü ile)
        fetch('<?= BASE_URL ?>/views/doviz.php', { method: 'GET', cache: 'no-store' })
            .finally(() => loadKurlar()); // Sonrasında kurları göster
    });

    // Manuel güncelleme butonu
    guncelleBtn.addEventListener('click', function() {
        setButtonLoading(true);
        // Manuel güncelleme için AJAX isteği (TTL'yi atlar)
        fetch('<?= BASE_URL ?>/ajax/doviz_guncelle_manuel.php', { method: 'POST', cache: 'no-store' })
            .then(res => res.json())
            .then(data => {
                if (!data.success) {
                    throw new Error(data.message || 'Güncelleme başarısız.');
                }
                // Başarılı güncelleme sonrası kurları yeniden yükle
                return loadKurlar(); 
            })
            .catch(err => {
                const updatedEl = document.getElementById('dovizUpdatedFooter');
                if(updatedEl) updatedEl.textContent = err.message || 'Bir hata oluştu.';
            })
            .finally(() => setButtonLoading(false));
    });

    function setButtonLoading(isLoading) {
        if (isLoading) {
            guncelleBtn.disabled = true;
            spinner.style.display = '';
            icon.style.display = 'none';
            btnText.textContent = 'Güncelleniyor...';
        } else {
            guncelleBtn.disabled = false;
            spinner.style.display = 'none';
            icon.style.display = '';
            btnText.textContent = 'Güncelle';
        }
    }

    function loadKurlar() {
        const loading = document.getElementById('dovizLoading');
        const table = document.getElementById('dovizTable');
        const tbody = table.querySelector('tbody');
        const updatedEl = document.getElementById('dovizUpdatedFooter');
        
        tbody.innerHTML = '';
        table.style.display = 'none';
        loading.style.display = 'block';

        return fetch('<?= BASE_URL ?>/ajax/doviz_kurlari.php', { cache: 'no-store' })
            .then(res => res.json())
            .then(data => {
                if (!data || !data.success) throw new Error('Kur verisi okunamadı');
                
                const kurlar = data.kurlar || {};
                const order = ['USD','EUR','GBP','CHF','AUD','DKK','SEK','CAD','NOK','SAR','JPY','RUB'];
                const otherCurrencies = Object.keys(kurlar).filter(k => k !== 'updated' && !order.includes(k));
                const finalOrder = [...order, ...otherCurrencies, 'TRY'];

                finalOrder.forEach(kod => {
                    if (!kurlar[kod]) return;
                    const kur = kurlar[kod];
                    const tr = `<tr>
                        <td><strong>${kod}</strong></td>
                        <td class="text-end">${Number(kur.ForexBuying).toLocaleString('tr-TR', {minimumFractionDigits: 4, maximumFractionDigits: 4})}</td>
                        <td class="text-end">${Number(kur.ForexSelling).toLocaleString('tr-TR', {minimumFractionDigits: 4, maximumFractionDigits: 4})}</td>
                    </tr>`;
                    tbody.insertAdjacentHTML('beforeend', tr);
                });

                if (updatedEl) updatedEl.textContent = 'Son Güncelleme: ' + (kurlar.updated || 'Bilinmiyor');
                table.style.display = '';
            })
            .catch(err => {
                if (updatedEl) updatedEl.textContent = err.message || 'Kur verisi alınamadı.';
            })
            .finally(() => {
                loading.style.display = 'none';
            });
    }
});
</script>
<?php endif; ?>

<!-- Navbar Hover Script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Desktop'ta hover ile dropdown açma (768px üzeri)
    if (window.innerWidth > 768) {
        const dropdowns = document.querySelectorAll('.custom-navbar .nav-item.dropdown');
        
        dropdowns.forEach(dropdown => {
            dropdown.addEventListener('mouseenter', function() {
                const menu = this.querySelector('.dropdown-menu');
                if (menu) {
                    menu.classList.add('show');
                }
            });
            
            dropdown.addEventListener('mouseleave', function() {
                const menu = this.querySelector('.dropdown-menu');
                if (menu) {
                    menu.classList.remove('show');
                }
            });
        });
    }
});

// Window resize durumunda kontrol
window.addEventListener('resize', function() {
    if (window.innerWidth <= 768) {
        // Mobile'da hover'ı kaldır, normal click davranışı
        document.querySelectorAll('.custom-navbar .dropdown-menu').forEach(menu => {
            menu.classList.remove('show');
        });
    }
});
</script>