<?php

// Sadece adminler erişebilir
if (!isset($_SESSION["yetki_seviyesi"]) || $_SESSION["yetki_seviyesi"] !== "admin") {
    header("Location: index.php"); // Yetkisiz erişimde ana sayfaya yönlendir
    exit();
}

// Eğer güvenlik kontrolleri sayfası doğrudan çağrılmadıysa ve hata yoksa, çıkış yap
if (!isset($_GET["guvenlik_kontrol"]) && empty($guvenlik_kontrolleri)) {
    return;
}

/**
 * Kurulum Sonrası Güvenlik Kontrolleri
 * Bu dosya kurulum tamamlandıktan sonra çalıştırılmalıdır
 */

// Kurulum tamamlanmış mı kontrol et
if (!file_exists(__DIR__ . 
'/config.php')) {
    die('Önce kurulumu tamamlayın!');
}

require_once __DIR__ . 
'/config.php';

if (!defined('KURULUM_TAMAMLANDI')) {
    die('Kurulum henüz tamamlanmamış!');
}

$guvenlik_kontrolleri = [];

// 1. install.php dosyası kontrolü
if (file_exists('install.php')) {
    $guvenlik_kontrolleri[] = [
        'durum' => 'uyari',
        'baslik' => 'install.php Dosyası Mevcut',
        'mesaj' => 'Güvenlik için install.php dosyasını silin veya yeniden adlandırın.',
        'oncelik' => 'yuksek'
    ];
}

// 2. config.php dosya izinleri kontrolü
$config_perms = substr(sprintf('%o', fileperms('config.php')), -4);
if ($config_perms !== '0644' && $config_perms !== '0640') {
    $guvenlik_kontrolleri[] = [
        'durum' => 'uyari',
        'baslik' => 'config.php Dosya İzinleri',
        'mesaj' => "config.php dosyasının izinleri: $config_perms. Önerilen: 644 veya 640",
        'oncelik' => 'orta'
    ];
}

// 3. HTTPS kontrolü
if (!isset($_SERVER['HTTPS']) || $_SERVER['HTTPS'] !== 'on') {
    $guvenlik_kontrolleri[] = [
        'durum' => 'bilgi',
        'baslik' => 'HTTPS Kullanımı',
        'mesaj' => 'Canlı ortamda HTTPS kullanmanız önerilir.',
        'oncelik' => 'orta'
    ];
}

// 4. PHP sürümü kontrolü
if (version_compare(PHP_VERSION, '7.4.0', '<')) {
    $guvenlik_kontrolleri[] = [
        'durum' => 'uyari',
        'baslik' => 'PHP Sürümü',
        'mesaj' => 'PHP sürümünüz: ' . PHP_VERSION . '. PHP 7.4+ önerilir.',
        'oncelik' => 'orta'
    ];
}

// 5. Veritabanı bağlantısı kontrolü
try {
    $stmt = $db->query("SELECT COUNT(*) as tablo_sayisi FROM information_schema.tables WHERE table_schema = '$dbname'");
    $result = $stmt->fetch();
    
    if ($result['tablo_sayisi'] < 7) {
        $guvenlik_kontrolleri[] = [
            'durum' => 'hata',
            'baslik' => 'Veritabanı Tabloları',
            'mesaj' => 'Bazı veritabanı tabloları eksik olabilir.',
            'oncelik' => 'yuksek'
        ];
    }
} catch (Exception $e) {
    $guvenlik_kontrolleri[] = [
        'durum' => 'hata',
        'baslik' => 'Veritabanı Bağlantısı',
        'mesaj' => 'Veritabanı bağlantısında sorun: ' . $e->getMessage(),
        'oncelik' => 'yuksek'
    ];
}

// 6. Yönetici hesabı kontrolü
try {
    $stmt = $db->query("SELECT COUNT(*) as admin_sayisi FROM kullanicilar WHERE aktif = 1");
    $result = $stmt->fetch();
    
    if ($result['admin_sayisi'] == 0) {
        $guvenlik_kontrolleri[] = [
            'durum' => 'hata',
            'baslik' => 'Yönetici Hesabı',
            'mesaj' => 'Aktif yönetici hesabı bulunamadı.',
            'oncelik' => 'yuksek'
        ];
    }
} catch (Exception $e) {
    $guvenlik_kontrolleri[] = [
        'durum' => 'hata',
        'baslik' => 'Kullanıcı Tablosu',
        'mesaj' => 'Kullanıcı tablosuna erişim sorunu: ' . $e->getMessage(),
        'oncelik' => 'yuksek'
    ];
}

// 7. Yazma izinleri kontrolü
$yazilabilir_klasorler = ['uploads', 'logs', 'cache'];
foreach ($yazilabilir_klasorler as $klasor) {
    if (is_dir($klasor) && !is_writable($klasor)) {
        $guvenlik_kontrolleri[] = [
            'durum' => 'uyari',
            'baslik' => "Klasör İzinleri: $klasor",
            'mesaj' => "$klasor klasörü yazılabilir değil.",
            'oncelik' => 'orta'
        ];
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ArOdjoo - Güvenlik Kontrolleri</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f8f9fa;
            margin: 0;
            padding: 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 30px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
            padding-bottom: 20px;
            border-bottom: 2px solid #e9ecef;
        }
        
        .header h1 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .kontrol-item {
            margin-bottom: 15px;
            padding: 15px;
            border-radius: 8px;
            border-left: 4px solid;
        }
        
        .kontrol-item.hata {
            background: #f8d7da;
            border-left-color: #dc3545;
            color: #721c24;
        }
        
        .kontrol-item.uyari {
            background: #fff3cd;
            border-left-color: #ffc107;
            color: #856404;
        }
        
        .kontrol-item.bilgi {
            background: #d1ecf1;
            border-left-color: #17a2b8;
            color: #0c5460;
        }
        
        .kontrol-item.basarili {
            background: #d4edda;
            border-left-color: #28a745;
            color: #155724;
        }
        
        .kontrol-baslik {
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .oncelik {
            float: right;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .oncelik.yuksek {
            background: #dc3545;
            color: white;
        }
        
        .oncelik.orta {
            background: #ffc107;
            color: #212529;
        }
        
        .oncelik.dusuk {
            background: #6c757d;
            color: white;
        }
        
        .ozet {
            background: #e9ecef;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
        }
        
        .btn {
            background: #007bff;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            text-decoration: none;
            display: inline-block;
            margin: 5px;
        }
        
        .btn:hover {
            background: #0056b3;
        }
        
        .btn-success {
            background: #28a745;
        }
        
        .btn-success:hover {
            background: #1e7e34;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🔒 ArOdjoo Güvenlik Kontrolleri</h1>
            <p>Kurulum sonrası güvenlik durumu</p>
        </div>
        
        <div class="ozet">
            <h3>Kontrol Özeti</h3>
            <?php
            $hata_sayisi = count(array_filter($guvenlik_kontrolleri, function($k) { return $k['durum'] == 'hata'; }));
            $uyari_sayisi = count(array_filter($guvenlik_kontrolleri, function($k) { return $k['durum'] == 'uyari'; }));
            $bilgi_sayisi = count(array_filter($guvenlik_kontrolleri, function($k) { return $k['durum'] == 'bilgi'; }));
            ?>
            <p><strong>Toplam Kontrol:</strong> <?= count($guvenlik_kontrolleri) ?></p>
            <p><strong>Hatalar:</strong> <?= $hata_sayisi ?></p>
            <p><strong>Uyarılar:</strong> <?= $uyari_sayisi ?></p>
            <p><strong>Bilgiler:</strong> <?= $bilgi_sayisi ?></p>
        </div>
        
        <?php if (empty($guvenlik_kontrolleri)): ?>
            <div class="kontrol-item basarili">
                <div class="kontrol-baslik">✅ Tüm Kontroller Başarılı</div>
                <p>Güvenlik kontrolleri tamamlandı. Herhangi bir sorun tespit edilmedi.</p>
            </div>
        <?php else: ?>
            <?php foreach ($guvenlik_kontrolleri as $kontrol): ?>
                <div class="kontrol-item <?= $kontrol['durum'] ?>">
                    <span class="oncelik <?= $kontrol['oncelik'] ?>"><?= strtoupper($kontrol['oncelik']) ?></span>
                    <div class="kontrol-baslik"><?= htmlspecialchars($kontrol['baslik']) ?></div>
                    <p><?= htmlspecialchars($kontrol['mesaj']) ?></p>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
        
        <div style="text-align: center; margin-top: 30px;">
            <a href="index.php" class="btn btn-success">Sisteme Giriş Yap</a>
            <a href="KURULUM_KILAVUZU.md" class="btn" target="_blank">Kurulum Kılavuzu</a>
            <?php if (file_exists('install.php')): ?>
                <a href="#" class="btn" onclick="if(confirm('install.php dosyasını silmek istediğinizden emin misiniz?')) { window.location.href='?sil_install=1'; }">install.php Sil</a>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>

<?php
// install.php silme işlemi
if (isset($_GET['sil_install']) && $_GET['sil_install'] == '1') {
    if (file_exists('install.php')) {
        if (unlink('install.php')) {
            echo "<script>alert('install.php dosyası başarıyla silindi!'); window.location.href='guvenlik_kontrol.php';</script>";
        } else {
            echo "<script>alert('install.php dosyası silinemedi! Manuel olarak silin.'); window.location.href='guvenlik_kontrol.php';</script>";
        }
    }
}
?>

