<footer class="custom-footer">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6 text-center text-md-start mb-3 mb-md-0">
                <h5><i class="bi bi-shop me-2"></i>Begeb Creative</h5>
                <p class="mb-1">&copy; <?= date('Y') ?> <?= __('all_rights_reserved') ?></p>
                <p class="mb-0"><small><?= __('developer') ?>: Begeb Creative - Eren Gemici</small></p>
            </div>
            <div class="col-md-6 text-center text-md-end">
                <div class="social-icons mb-3">
                    <a href="#" title="Facebook"><i class="bi bi-facebook"></i></a>
                    <a href="#" title="Twitter"><i class="bi bi-twitter-x"></i></a>
                    <a href="#" title="Instagram"><i class="bi bi-instagram"></i></a>
                    <a href="#" title="LinkedIn"><i class="bi bi-linkedin"></i></a>
                </div>
                <p class="mb-0"><i class="bi bi-envelope me-2"></i>hi@begeb.net</p>
            </div>
        </div>
    </div>
</footer>

<?php
// Sadece kullanıcı giriş yapmışsa ekran kilidi özelliğini yükle
if (isset($_SESSION['kullanici_id'])):

    // Ekran kilidi ayarlarını çek
    $ekran_kilidi_ayarlari = null;
    try {
        $stmt = $db->prepare("SELECT ekran_kilidi_aktif, ekran_kilidi_sure, ekran_kilidi_sifre FROM kullanicilar WHERE id = ?");
        $stmt->execute([$_SESSION['kullanici_id']]);
        $kullanici_ayarlari = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Özelliğin çalışması için hem aktif olmalı hem de şifre belirlenmiş olmalı
        if ($kullanici_ayarlari && $kullanici_ayarlari['ekran_kilidi_aktif'] && !empty($kullanici_ayarlari['ekran_kilidi_sifre'])) {
            // BASE_URL sabitini kullan (config.php'de tanımlanmış)
            $ekran_kilidi_ayarlari = [
                'aktif' => true,
                'sure_ms' => $kullanici_ayarlari['ekran_kilidi_sure'] * 60 * 1000,
                'ajax_url' => BASE_URL . '/ajax/ekran_kilidi_dogrula.php'
            ];
        }
    } catch (PDOException $e) {
        error_log("Ekran kilidi ayarları çekilemedi: " . $e->getMessage());
    }

    // Sadece özellik aktifse HTML, JS ve CSS kodlarını sayfaya ekle
    if ($ekran_kilidi_ayarlari && $ekran_kilidi_ayarlari['aktif']):
?>
    <div id="lockScreen" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.8); z-index: 9999; backdrop-filter: blur(5px);">
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 40px; border-radius: 10px; text-align: center; width: 350px;">
            <i class="bi bi-lock-fill" style="font-size: 3rem; color: #6c757d;"></i>
            <h4 class="mt-3">Ekran Kilitlendi</h4>
            <p class="text-muted">Devam etmek için lütfen şifrenizi girin.</p>
            <form id="unlockForm">
                <div class="mb-3">
                    <input type="password" class="form-control" id="lockPassword" placeholder="Şifre" required autocomplete="current-password">
                </div>
                <button type="submit" class="btn btn-primary w-100">Kilidi Aç</button>
                <div id="unlockError" class="text-danger mt-2" style="display: none;"></div>
            </form>
        </div>
    </div>

    <style>
    @keyframes shake {
      10%, 90% { transform: translate(-51%, -50%) translate3d(-1px, 0, 0); }
      20%, 80% { transform: translate(-51%, -50%) translate3d(2px, 0, 0); }
      30%, 50%, 70% { transform: translate(-51%, -50%) translate3d(-4px, 0, 0); }
      40%, 60% { transform: translate(-51%, -50%) translate3d(4px, 0, 0); }
    }
    </style>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        console.log("Ekran Kilidi Modülü Aktif.");

        const lockScreen = document.getElementById('lockScreen');
        const unlockForm = document.getElementById('unlockForm');
        const lockPasswordInput = document.getElementById('lockPassword');
        const unlockError = document.getElementById('unlockError');
        
        let inactivityTimer;
        const timeoutDuration = <?= $ekran_kilidi_ayarlari['sure_ms'] ?>;
        const ajaxUrl = '<?= $ekran_kilidi_ayarlari['ajax_url'] ?>';
        
        // Debug: AJAX URL'yi konsola yazdır
        console.log('Ekran Kilidi AJAX URL:', ajaxUrl);

        function resetTimer() {
            clearTimeout(inactivityTimer);
            inactivityTimer = setTimeout(lockTheScreen, timeoutDuration);
        }

        function lockTheScreen() {
            if (lockScreen) lockScreen.style.display = 'flex';
            if (lockPasswordInput) lockPasswordInput.focus();
        }

        function unlockTheScreen() {
            if(lockScreen) lockScreen.style.display = 'none';
            if(lockPasswordInput) lockPasswordInput.value = '';
            if(unlockError) unlockError.style.display = 'none';
            resetTimer();
        }

        ['mousemove', 'keydown', 'click', 'scroll'].forEach(event => window.addEventListener(event, resetTimer, true));

        if (unlockForm) {
            unlockForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const password = lockPasswordInput.value;
                unlockError.style.display = 'none';

                const formData = new FormData();
                formData.append('sifre', password);

                fetch(ajaxUrl, {
                    method: 'POST',
                    body: formData
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error(`HTTP ${response.status}: ${response.statusText}`);
                    }
                    return response.json();
                })
                .then(data => {
                    if (data.success) {
                        unlockTheScreen();
                    } else {
                        unlockError.textContent = data.message || 'Hatalı şifre!';
                        unlockError.style.display = 'block';
                        lockPasswordInput.value = '';
                        lockPasswordInput.focus();
                        
                        const lockBox = unlockForm.parentElement;
                        lockBox.style.animation = 'shake 0.5s';
                        setTimeout(() => {
                            lockBox.style.animation = '';
                        }, 500);
                    }
                })
                .catch(error => {
                    console.error('Ekran kilidi açma hatası:', error);
                    unlockError.textContent = 'Sunucu hatası: ' + error.message;
                    unlockError.style.display = 'block';
                });
            });
        }

        resetTimer();
    });
    </script>
<?php 
    endif; // $ekran_kilidi_ayarlari && $ekran_kilidi_ayarlari['aktif']
endif; // isset($_SESSION['kullanici_id'])
?>
</body>
</html>
