<?php
// Veritabanı bağlantı bilgileri
$host = "localhost";
$dbname = "odjoo";
$username = "root";
$password = "";

// BASE URL tanımı
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http";
$http_host = $_SERVER['HTTP_HOST'];
$script_name = $_SERVER['SCRIPT_NAME'];
$base_path = dirname(dirname($script_name));
$base_url = $protocol . "://" . $http_host . $base_path;

// Debug: BASE_URL'yi logla
error_log("BASE_URL oluşturuldu: " . $base_url);

define('BASE_URL', $base_url);

// Session durumunu kontrol et ve ayarları yap
if (session_status() === PHP_SESSION_NONE) {
    // Oturum ayarları - session_start()'tan ÖNCE yapılmalı
    session_name("Odjoo_YONETIM_SID");
    session_set_cookie_params([
        "lifetime" => 86400,
        "path" => "/",
        "domain" => $_SERVER["HTTP_HOST"],
        "secure" => isset($_SERVER["HTTPS"]),
        "httponly" => true,
        "samesite" => "Strict"
    ]);
    
    // Session başlatma - Oturum ayarlarından SONRA
    session_start();
}

// KURULUM TAMAMLANDI - Bu sabit, diğer dosyaların doğrudan erişimini engellemek için kullanılır.
define('KURULUM_TAMAMLANDI', true);

// PDO bağlantısı
try {
    $db = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $db->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
    $db->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    error_log("Veritabanı bağlantı hatası: " . $e->getMessage());
    echo "Sistem şu anda kullanılamıyor. Lütfen daha sonra tekrar deneyin.";
    header("Location: ../install.php");
    exit();
}

// Hata raporlama - en üste taşındı
// error_reporting(E_ALL);
// ini_set("display_errors", 0);
// ini_set("log_errors", 1);
// ini_set("error_log", __DIR__ . "/php_errors.log");

// Çıktı tamponlamasını başlat
if (!headers_sent() && !ob_get_level()) {
    ob_start();
}

// Dil fonksiyonlarını yükle
require_once __DIR__ . '/language_functions.php';

// Oturum ve Şirket bilgilerini hazırla
// Bu dosya, global değişkenleri ($aktif_sirket_id, $kullanici_sirketleri vb.) ayarlar.
require_once __DIR__ . '/session_setup.php';

// Güvenlik başlıkları - header'ları tek bir yerde topluyoruz
if (!headers_sent()) {
    header("X-Frame-Options: DENY");
    header("X-Content-Type-Options: nosniff");
    header("Referrer-Policy: strict-origin-when-cross-origin");
    
    // Content Security Policy
    $csp = [
        "default-src 'self'",
        "script-src 'self' https://cdn.jsdelivr.net 'unsafe-inline' 'unsafe-eval'",
        "style-src 'self' https://cdn.jsdelivr.net 'unsafe-inline'",
        "font-src 'self' https://cdn.jsdelivr.net data:",
        "img-src 'self' data: https: http:",
        "connect-src 'self' https://cdn.jsdelivr.net",
        "frame-src 'self'",
        "object-src 'none'"
    ];
    header("Content-Security-Policy: " . implode("; ", $csp) . ";");
}

// Zaman dilimini ayarla
date_default_timezone_set('Europe/Istanbul');

// --- Fonksiyonlar ---
require_once __DIR__ . '/fonksiyonlar.php';

// --- Language System ---
// language_functions.php zaten yukarıda yüklenmiş durumda

// Yardımcı fonksiyonları dahil et
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php';
require_once __DIR__ . '/../functions/stok_fonksiyonlari.php';
require_once __DIR__ . '/../functions/log_fonksiyonlari.php';
require_once __DIR__ . '/../functions/kullanici_fonksiyonlari.php';
require_once __DIR__ . '/yetki_kontrol.php';

// KURULUM TAMAMLANDI - Bu satırı silmeyin! - BU SATIR YUKARI TAŞINDI
require_once __DIR__ . '/functions.php';
?>