-- Markalar Tablosu
-- Tarih: 2026-02-13

CREATE TABLE IF NOT EXISTS `markalar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sirket_id` int(11) NOT NULL,
  `marka_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturulma_tarihi` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `marka_adi_sirket` (`marka_adi`, `sirket_id`),
  KEY `fk_markalar_sirket_id` (`sirket_id`),
  CONSTRAINT `fk_markalar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Marka yönetimi tablosu';

-- Urunler tablosuna marka_id kolonu ekle
ALTER TABLE `urunler` 
ADD COLUMN IF NOT EXISTS `marka_id` int(11) DEFAULT NULL COMMENT 'Ürünün markası' AFTER `kategori_id`,
ADD KEY IF NOT EXISTS `fk_urunler_marka_id` (`marka_id`),
ADD CONSTRAINT `fk_urunler_marka_id` FOREIGN KEY (`marka_id`) REFERENCES `markalar` (`id`) ON DELETE SET NULL ON UPDATE CASCADE;
