-- Depo ve Raf Yönetimi Sistemi - Veritabanı Güncellemeleri
-- Tarih: 2026-02-13

-- 1. Depolar Tablosu
CREATE TABLE IF NOT EXISTS `depolar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sirket_id` int(11) NOT NULL,
  `depo_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturulma_tarihi` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `depo_adi_sirket` (`depo_adi`, `sirket_id`),
  KEY `fk_depolar_sirket_id` (`sirket_id`),
  CONSTRAINT `fk_depolar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Depo yönetimi tablosu';

-- 2. Raflar Tablosu
CREATE TABLE IF NOT EXISTS `raflar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sirket_id` int(11) NOT NULL,
  `raf_adi` varchar(100) COLLATE utf8mb4_turkish_ci NOT NULL,
  `aciklama` text COLLATE utf8mb4_turkish_ci DEFAULT NULL,
  `aktif` tinyint(1) DEFAULT 1,
  `olusturulma_tarihi` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `raf_adi_sirket` (`raf_adi`, `sirket_id`),
  KEY `fk_raflar_sirket_id` (`sirket_id`),
  CONSTRAINT `fk_raflar_sirket_id` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Raf yönetimi tablosu';

-- 3. Ürün Depo Raf İlişki Tablosu (Stok Dağılımı)
CREATE TABLE IF NOT EXISTS `urun_depo_raf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `urun_id` int(11) NOT NULL,
  `sirket_id` int(11) NOT NULL,
  `depo_id` int(11) DEFAULT NULL,
  `raf_id` int(11) DEFAULT NULL,
  `miktar` decimal(10,2) DEFAULT 0.00,
  `son_guncelleme` datetime DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `urun_depo_raf_unique` (`urun_id`, `depo_id`, `raf_id`),
  KEY `fk_urun_depo_raf_urun` (`urun_id`),
  KEY `fk_urun_depo_raf_depo` (`depo_id`),
  KEY `fk_urun_depo_raf_raf` (`raf_id`),
  KEY `fk_urun_depo_raf_sirket` (`sirket_id`),
  CONSTRAINT `fk_urun_depo_raf_urun` FOREIGN KEY (`urun_id`) REFERENCES `urunler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_urun_depo_raf_depo` FOREIGN KEY (`depo_id`) REFERENCES `depolar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_urun_depo_raf_raf` FOREIGN KEY (`raf_id`) REFERENCES `raflar` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_urun_depo_raf_sirket` FOREIGN KEY (`sirket_id`) REFERENCES `sirketler` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci COMMENT='Ürün depo ve raf stok dağılımı';

-- 4. Sirketler Tablosuna Modül Kolonu Ekleme
ALTER TABLE `sirketler` 
ADD COLUMN IF NOT EXISTS `depo_yonetimi_aktif` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Depo Yönetimi modülü aktif mi?' AFTER `stok_islemleri_aktif`;

-- Tamamlandı
