// Logo önizleme fonksiyonu
function previewLogo(input) {
    const fileInfo = document.getElementById('file-info');
    const fileName = document.getElementById('file-name');
    const fileSize = document.getElementById('file-size');
    const logoPreview = document.getElementById('logo-preview');
    const logoPlaceholder = document.getElementById('logo-placeholder');
    const deleteCheckbox = document.getElementById('logo_sil');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const fileSizeMB = (file.size / (1024 * 1024)).toFixed(2);
        const maxSize = 2; // MB
        
        // Dosya boyutu kontrolü
        if (fileSizeMB > maxSize) {
            alert(`Dosya boyutu çok büyük. Maksimum ${maxSize}MB boyutunda dosya yükleyebilirsiniz.`);
            input.value = '';
            return;
        }
        
        // Dosya türü kontrolü
        const validTypes = ['image/jpeg', 'image/png', 'image/gif'];
        if (!validTypes.includes(file.type)) {
            alert('Geçersiz dosya türü. Sadece JPG, PNG ve GIF formatında dosya yükleyebilirsiniz.');
            input.value = '';
            return;
        }
        
        // Önizleme göster
        const reader = new FileReader();
        
        reader.onload = function(e) {
            if (logoPreview) {
                logoPreview.src = e.target.result;
                logoPreview.classList.remove('d-none');
            }
            if (logoPlaceholder) {
                logoPlaceholder.classList.add('d-none');
            }
            
            // Dosya bilgilerini göster
            const maxLength = 20;
            const displayName = file.name.length > maxLength ? 
                file.name.substring(0, maxLength) + '...' + file.name.split('.').pop() : 
                file.name;
            
            fileName.textContent = displayName;
            fileName.title = file.name; // Show full name on hover
            fileSize.textContent = `${fileSizeMB} MB`;
            
            if (fileInfo) {
                fileInfo.classList.remove('d-none');
            }
            
            // Silme seçeneğini göster
            if (deleteCheckbox) {
                deleteCheckbox.checked = false;
                const formCheck = deleteCheckbox.closest('.form-check');
                if (formCheck) formCheck.classList.remove('d-none');
            }
        }
        
        reader.readAsDataURL(file);
    }
}

// Sayfa yüklendiğinde çalışacak kodlar
document.addEventListener('DOMContentLoaded', function() {
    // Dosya yükleme işlemi
    const fileInput = document.getElementById('logo');
    if (fileInput) {
        fileInput.addEventListener('change', function() {
            previewLogo(this);
        });
    }

    // Silme onayı
    const deleteCheckbox = document.getElementById('logo_sil');
    if (deleteCheckbox) {
        deleteCheckbox.addEventListener('change', function() {
            if (this.checked) {
                if (!confirm('Logoyu silmek istediğinize emin misiniz? Bu işlem geri alınamaz.')) {
                    this.checked = false;
                } else {
                    const logoPreview = document.getElementById('logo-preview');
                    const logoPlaceholder = document.getElementById('logo-placeholder');
                    const fileInput = document.getElementById('logo');
                    
                    if (logoPreview) {
                        logoPreview.src = '';
                        logoPreview.classList.add('d-none');
                    }
                    if (logoPlaceholder) {
                        logoPlaceholder.classList.remove('d-none');
                    }
                    if (fileInput) {
                        fileInput.value = '';
                    }
                    
                    // Dosya bilgilerini temizle
                    const fileInfo = document.getElementById('file-info');
                    if (fileInfo) fileInfo.classList.add('d-none');
                    
                    // Form submit et
                    const form = fileInput.closest('form');
                    if (form) {
                        // Önce formu submit et
                        form.submit();
                    }
                }
            }
        });
    }

    // Sürükle-bırak desteği
    const dropArea = document.querySelector('.card-body');
    const fileInput = document.getElementById('logo');

    if (dropArea) {
        ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
            dropArea.addEventListener(eventName, preventDefaults, false);
        });

        function preventDefaults(e) {
            e.preventDefault();
            e.stopPropagation();
        }

        ['dragenter', 'dragover'].forEach(eventName => {
            dropArea.addEventListener(eventName, highlight, false);
        });

        ['dragleave', 'drop'].forEach(eventName => {
            dropArea.addEventListener(eventName, unhighlight, false);
        });

        function highlight() {
            dropArea.classList.add('border', 'border-primary', 'rounded');
        }

        function unhighlight() {
            dropArea.classList.remove('border', 'border-primary', 'rounded');
        }

        dropArea.addEventListener('drop', handleDrop, false);

        function handleDrop(e) {
            const dt = e.dataTransfer;
            const files = dt.files;
            
            if (files.length) {
                fileInput.files = files;
                previewLogo(fileInput);
            }
        }
    }
});
