<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Uygulama yapılandırmalarını ve fonksiyonları dahil et
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/doviz_fonksiyonlari.php';

$from = isset($_GET['from']) ? strtoupper($_GET['from']) : 'USD';
$to = isset($_GET['to']) ? strtoupper($_GET['to']) : 'TRY';

// 'TL' -> 'TRY' standardizasyonu
if ($from === 'TL') $from = 'TRY';
if ($to === 'TL') $to = 'TRY';

if ($from === $to) {
    echo json_encode(['success' => true, 'rate' => 1]);
    exit;
}

try {
    $rate = get_exchange_rate($from, $to);
    if ($rate > 0) {
        echo json_encode(['success' => true, 'rate' => $rate]);
    } else {
        echo json_encode(['success' => false, 'rate' => 1, 'error' => 'Kur bulunamadı']);
    }
} catch (Throwable $e) {
    error_log('kur_proxy hata: ' . $e->getMessage());
    echo json_encode(['success' => false, 'rate' => 1, 'error' => 'Sunucu hatası']);
}
