<?php
require_once __DIR__ . '/../includes/config.php';

header('Content-Type: application/json');

// Debug için hata raporlamayı aç (geçici)
// error_reporting(E_ALL);
// ini_set('display_errors', 1);

// Session kontrolü
if (!isset($_SESSION['kullanici_id'])) {
    error_log("Ekran kilidi doğrulama: Session bulunamadı");
    echo json_encode(['success' => false, 'message' => 'Oturum bulunamadı.']);
    exit();
}

$sifre = $_POST['sifre'] ?? '';
if (empty($sifre)) {
    error_log("Ekran kilidi doğrulama: Şifre boş");
    echo json_encode(['success' => false, 'message' => 'Şifre boş olamaz.']);
    exit();
}

try {
    // Kullanıcı bilgilerini çek
    $stmt = $db->prepare("SELECT ekran_kilidi_sifre, kullanici_adi FROM kullanicilar WHERE id = ?");
    $stmt->execute([$_SESSION['kullanici_id']]);
    $kullanici = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$kullanici) {
        error_log("Ekran kilidi doğrulama: Kullanıcı bulunamadı. ID: " . $_SESSION['kullanici_id']);
        echo json_encode(['success' => false, 'message' => 'Kullanıcı bulunamadı.']);
        exit();
    }

    // Ekran kilidi şifresi var mı kontrol et
    if (empty($kullanici['ekran_kilidi_sifre'])) {
        error_log("Ekran kilidi doğrulama: Ekran kilidi şifresi ayarlanmamış. Kullanıcı: " . $kullanici['kullanici_adi']);
        echo json_encode(['success' => false, 'message' => 'Ekran kilidi şifresi ayarlanmamış. Lütfen ayarlardan şifre belirleyin.']);
        exit();
    }

    // Şifre doğrulama
    if (password_verify($sifre, $kullanici['ekran_kilidi_sifre'])) {
        error_log("Ekran kilidi doğrulama: Başarılı. Kullanıcı: " . $kullanici['kullanici_adi']);
        echo json_encode(['success' => true]);
    } else {
        error_log("Ekran kilidi doğrulama: Hatalı şifre. Kullanıcı: " . $kullanici['kullanici_adi']);
        echo json_encode(['success' => false, 'message' => 'Hatalı şifre!']);
    }
} catch (PDOException $e) {
    error_log("Ekran kilidi doğrulama hatası: " . $e->getMessage());
    error_log("Ekran kilidi doğrulama hatası - Stack trace: " . $e->getTraceAsString());
    echo json_encode(['success' => false, 'message' => 'Sistemsel bir hata oluştu: ' . $e->getMessage()]);
} catch (Exception $e) {
    error_log("Ekran kilidi doğrulama genel hatası: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Beklenmeyen bir hata oluştu: ' . $e->getMessage()]);
}
