<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// DB'den kurları oku ve döndür
require_once __DIR__ . '/../includes/config.php';

try {
    $kurlar = [];
    $son_tarih = null;
    $stmt = $db->query("SELECT para_birimi, alis, satis, guncelleme_tarihi FROM doviz_kurlari ORDER BY id");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $kod = strtoupper(trim($row['para_birimi']));
        if ($kod === '') continue;
        $kurlar[$kod] = [
            'ForexBuying' => (float)$row['alis'],
            'ForexSelling' => (float)$row['satis']
        ];
        if ($row['guncelleme_tarihi'] && !$son_tarih) {
            $son_tarih = $row['guncelleme_tarihi'];
        }
    }
    // TRY/TL sabit 1
    $kurlar['TRY'] = $kurlar['TRY'] ?? ['ForexBuying' => 1.0, 'ForexSelling' => 1.0];
    $kurlar['updated'] = $son_tarih ?: date('d.m.Y H:i:s');
    echo json_encode(['success' => true, 'kurlar' => $kurlar]);
} catch (Throwable $e) {
    error_log('doviz_kurlari hata: ' . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Kur verisi okunamadı']);
}
