<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../includes/config.php';

// Bu betik, TTL (Time-To-Live) kontrolünü atlayarak döviz kurlarını manuel olarak günceller.

try {
    // TCMB döviz kuru XML adresi
    $url = 'https://www.tcmb.gov.tr/kurlar/today.xml';

    // cURL ile ağ isteği
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CONNECTTIMEOUT => 5, // 5 saniye bağlantı zaman aşımı
        CURLOPT_TIMEOUT        => 10, // 10 saniye toplam zaman aşımı
        CURLOPT_USERAGENT      => 'Odjoo/1.0 (+manuel-doviz-guncelle)'
    ]);
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $error = curl_error($ch);
    curl_close($ch);

    if ($response === false || $http_code !== 200) {
        throw new Exception('TCMB verisi alınamadı. HTTP Kodu: ' . $http_code . ' - Hata: ' . $error);
    }

    $xml = @simplexml_load_string($response);
    if ($xml === false) {
        throw new Exception('XML verisi işlenemedi.');
    }

    $db->beginTransaction();

    $sql = "INSERT INTO doviz_kurlari (para_birimi, alis, satis, guncelleme_tarihi)
            VALUES (:code, :alis, :satis, NOW())
            ON DUPLICATE KEY UPDATE
            alis = VALUES(alis),
            satis = VALUES(satis),
            guncelleme_tarihi = VALUES(guncelleme_tarihi)";
    $stmt = $db->prepare($sql);

    foreach ($xml->Currency as $currency) {
        $code = (string)$currency['CurrencyCode'];
        $alis = (float)$currency->ForexBuying;
        $satis = (float)$currency->ForexSelling;

        // Sadece geçerli kur verilerini işle
        if (!empty($code) && $alis > 0 && $satis > 0) {
            $stmt->execute([
                ':code'  => $code,
                ':alis'  => $alis,
                ':satis' => $satis
            ]);
        }
    }
    
    // TRY (Türk Lirası) için 1.00 değerini ekle/güncelle
    $stmt->execute([
        ':code'  => 'TRY',
        ':alis'  => 1.0000,
        ':satis' => 1.0000
    ]);

    $db->commit();

    echo json_encode(['success' => true, 'message' => 'Döviz kurları başarıyla güncellendi.']);

} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
