<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../functions/yardimci_fonksiyonlar.php'; // yetkili_mi() ve temizle() için eklendi

// Yetki kontrolü (sadece yetkili kullanıcılar cari ekleyebilir)
yetkili_mi(); // Oturum ve temel güvenlik kontrolü

// AJAX isteği kontrolü
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek yöntemi.']);
    exit;
}

// CSRF token doğrulama
if (!csrf_token_dogrula($_POST['csrf_token'] ?? '')) {
    echo json_encode(['success' => false, 'message' => 'Güvenlik tokenı geçersiz veya eksik.']);
    exit;
}

// Form verilerini al
$ad_soyad = isset($_POST['ad_soyad']) ? temizle($_POST['ad_soyad']) : '';
$telefon = isset($_POST['telefon']) ? temizle($_POST['telefon']) : '';
$eposta = isset($_POST['eposta']) ? temizle($_POST['eposta']) : '';
$adres = isset($_POST['adres']) ? temizle($_POST['adres']) : '';
$grup_id = isset($_POST['grup_id']) ? filter_var($_POST['grup_id'], FILTER_VALIDATE_INT) : null;

// Veri doğrulama
if (empty($ad_soyad)) {
    echo json_encode(['success' => false, 'message' => 'Ad Soyad / Firma Adı alanı zorunludur.']);
    exit;
}

try {
    // Aktif şirket ID'sini al
    $sirket_id = $_SESSION['aktif_sirket_id'] ?? null;
    if (!$sirket_id) {
        throw new Exception("Aktif şirket bulunamadı.");
    }
    
    // Cari ekle
    // Yeni cari eklendiğinde başlangıç borç/alacak/bakiye 0 olarak ayarlanır.
    $stmt = $db->prepare("
        INSERT INTO cariler (sirket_id, ad_soyad, telefon, eposta, adres, grup_id, toplam_borc, toplam_alacak, bakiye, olusturulma_tarihi)
        VALUES (?, ?, ?, ?, ?, ?, 0, 0, 0, NOW())
    ");
    
    $stmt->execute([$sirket_id, $ad_soyad, $telefon, $eposta, $adres, $grup_id]);
    $cari_id = $db->lastInsertId();
    
    // Loglama: Cari Ekleme (eğer log sistemi entegre ise)
    // require_once __DIR__ . '/../functions/log_fonksiyonlari.php'; // Eğer bu dosyada doğrudan loglama yapmak istiyorsanız
    // sistem_log_ekle($db, 'ekle', 'cariler', $cari_id, null, ['ad_soyad' => $ad_soyad, 'telefon' => $telefon], 'AJAX ile yeni cari eklendi: ' . $ad_soyad);

    echo json_encode([
        'success' => true, 
        'message' => 'Cari başarıyla eklendi.',
        'cari_id' => $cari_id,
        'ad_soyad' => $ad_soyad
    ]);
    exit;
} catch (PDOException $e) {
    error_log("Cari ekleme hatası (AJAX): " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Cari eklenirken bir hata oluştu: ' . $e->getMessage()]);
    exit;
}
?>