<?php
require_once __DIR__ . 
'/../includes/config.php';
yetkili_mi();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek']);
    exit;
}

$arama = temizle($_POST['arama'] ?? '');
$cari_id_param = filter_input(INPUT_POST, 'cari_id', FILTER_VALIDATE_INT);

if (!empty($cari_id_param)) {
    try {
        $stmt = $db->prepare("SELECT id, ad_soyad, telefon, adres FROM cariler WHERE id = ? AND sirket_id = ?");
        $stmt->execute([$cari_id_param, $_SESSION['aktif_sirket_id']]);
        $cari = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($cari) {
            echo json_encode(['success' => true, 'cariler' => [$cari]]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Cari bulunamadı.']);
        }
    } catch (Exception $e) {
        error_log("Cari ID ile arama AJAX hatası: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'Arama sırasında bir hata oluştu.']);
    }
    exit;
}

if (strlen($arama) < 2) {
    echo json_encode(['success' => false, 'message' => 'En az 2 karakter giriniz']);
    exit;
}

try {
    $stmt = $db->prepare("
        SELECT id, ad_soyad, telefon, adres
        FROM cariler 
        WHERE aktif = 1 AND sirket_id = ? AND ad_soyad LIKE ?
        ORDER BY ad_soyad
        LIMIT 10
    ");
    $stmt->execute([$_SESSION['aktif_sirket_id'], '%' . $arama . '%']);
    $cariler = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'cariler' => $cariler
    ]);
    
} catch (Exception $e) {
    error_log("Cari arama AJAX hatası: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Arama sırasında bir hata oluştu'
    ]);
}
?>

