<?php
require_once __DIR__ . '/../includes/config.php';

// AJAX isteği olup olmadığını ve kullanıcının yetkili olup olmadığını kontrol et
if (
    !isset($_SERVER['HTTP_X_REQUESTED_WITH']) || 
    strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) != 'xmlhttprequest' ||
    !isset($_SESSION['kullanici_id'])
) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Geçersiz erişim.']);
    exit();
}

header('Content-Type: application/json');

// POST verilerini al
$borc_id = filter_input(INPUT_POST, 'borc_id', FILTER_VALIDATE_INT);
$yeni_durum = filter_input(INPUT_POST, 'yeni_durum', FILTER_SANITIZE_STRING);
$csrf_token = $_POST['csrf_token'] ?? '';

$aktif_sirket_id = $_SESSION['aktif_sirket_id'];

// Gerekli doğrulamaları yap
if (!$borc_id || !in_array($yeni_durum, ['odendi', 'odenmedi']) || !csrf_token_dogrula($csrf_token)) {
    echo json_encode(['success' => false, 'message' => 'Geçersiz veri veya güvenlik tokenı.']);
    exit();
}

try {
    $db->beginTransaction();

    // Önce borç bilgisini alalım
    $stmt_borc = $db->prepare("SELECT * FROM borclar WHERE id = ? AND sirket_id = ?");
    $stmt_borc->execute([$borc_id, $aktif_sirket_id]);
    $borc = $stmt_borc->fetch(PDO::FETCH_ASSOC);

    if (!$borc) {
        throw new Exception("İşlem bulunamadı veya yetkiniz yok.");
    }
    
    $guncellenecek_veriler = [];

    if ($yeni_durum == 'odendi') {
        // "Ödendi" olarak işaretleniyorsa
        $odenen_tutar = $borc['tutar'];
        $durum = 'odendi';
        
        $stmt_update = $db->prepare("UPDATE borclar SET odenen_tutar = ?, durum = ? WHERE id = ?");
        $stmt_update->execute([$odenen_tutar, $durum, $borc_id]);

        $guncellenecek_veriler = [
            'odenen_tutar' => number_format($odenen_tutar, 2, ',', '.'),
            'kalan_tutar' => number_format(0, 2, ',', '.'),
            'durum_text' => 'Ödendi',
            'durum_class' => 'badge-odendi'
        ];

    } elseif ($yeni_durum == 'odenmedi') {
        // "Ödenmedi" olarak işaretleniyorsa
        
        // Bu borç ile ilişkili tüm hesap hareketlerini bul
        $stmt_hareketler = $db->prepare("SELECT * FROM hesap_hareketleri WHERE borc_id = ? AND sirket_id = ?");
        $stmt_hareketler->execute([$borc_id, $aktif_sirket_id]);
        $hareketler = $stmt_hareketler->fetchAll(PDO::FETCH_ASSOC);
        
        foreach($hareketler as $hareket) {
            // Hareketin tersini yaparak hesap bakiyesini güncelle
            $islem = ($hareket['tur'] == 'giris') ? -1 : 1;
            $yeni_bakiye_degisimi = $hareket['tutar'] * $islem;
            
            $stmt_bakiye = $db->prepare("UPDATE hesaplar SET bakiye = bakiye + ? WHERE id = ?");
            $stmt_bakiye->execute([$yeni_bakiye_degisimi, $hareket['hesap_id']]);
        }
        
        // İlişkili tüm hesap hareketlerini sil
        $stmt_sil = $db->prepare("DELETE FROM hesap_hareketleri WHERE borc_id = ? AND sirket_id = ?");
        $stmt_sil->execute([$borc_id, $aktif_sirket_id]);
        
        // Borcun ödenen tutarını ve durumunu sıfırla
        $stmt_update = $db->prepare("UPDATE borclar SET odenen_tutar = 0, durum = 'odenmedi' WHERE id = ?");
        $stmt_update->execute([$borc_id]);
        
        $guncellenecek_veriler = [
            'odenen_tutar' => number_format(0, 2, ',', '.'),
            'kalan_tutar' => number_format($borc['tutar'], 2, ',', '.'),
            'durum_text' => 'Ödenmedi',
            'durum_class' => 'badge-odenmedi'
        ];
    }
    
    $db->commit();

    // Yeni CSRF token oluştur ve response'a ekle
    $yeni_csrf_token = csrf_token_olustur();
    
    echo json_encode([
        'success' => true, 
        'message' => 'Durum başarıyla güncellendi.', 
        'guncel_veriler' => $guncellenecek_veriler,
        'csrf_token' => $yeni_csrf_token
    ]);

} catch (Exception $e) {
    if ($db->inTransaction()) {
        $db->rollBack();
    }
    error_log("Borç durum güncelleme hatası: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Bir hata oluştu: ' . $e->getMessage()]);
} 